/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.utils;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.api.entities.ally.IServant;
import com.Polarice3.Goety.common.entities.ally.RedstoneGolem;
import com.Polarice3.Goety.common.entities.ally.undead.GraveGolem;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.entities.projectiles.BlastFungus;
import com.Polarice3.Goety.common.entities.projectiles.FireTornado;
import com.Polarice3.Goety.common.entities.projectiles.SnapFungus;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.items.magic.DarkWand;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.LichdomHelper;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.SEHelper;
import com.Polarice3.Goety.utils.WandUtil;
import com.google.common.collect.Lists;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.WebBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class MobUtil {
    public static final Predicate<LivingEntity> NO_CREATIVE_OR_SPECTATOR = p_200824_0_ -> !(p_200824_0_ instanceof Player) || !p_200824_0_.m_5833_() && !((Player)p_200824_0_).m_7500_();

    public static boolean isShifting(Entity entity) {
        return entity.m_6047_() || entity.m_6144_();
    }

    public static boolean validEntity(Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return MobUtil.playerValidity(player, false);
        }
        return entity.m_6097_();
    }

    public static boolean playerValidity(Player player, boolean isNotLich) {
        if (!player.m_7500_() && !player.m_5833_()) {
            if (isNotLich) {
                return !LichdomHelper.isLich(player);
            }
            return true;
        }
        return false;
    }

    public static boolean undeadAndLich(LivingEntity pLivingEntity) {
        if (pLivingEntity.m_21222_() || pLivingEntity.m_6336_() == MobType.f_21641_) {
            return true;
        }
        if (pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            return LichdomHelper.isLich(player);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean areAllies(@Nullable Entity entity, @Nullable Entity entity1) {
        if (entity == null) return false;
        if (entity1 == null) return false;
        if (entity.m_7307_(entity1)) return true;
        if (entity1.m_7307_(entity)) return true;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (entity1 instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity1;
                if (SEHelper.getAllyEntities(player).contains(living)) return true;
                if (SEHelper.getAllyEntityTypes(player).contains(living.m_6095_())) return true;
            }
        }
        if (!(entity1 instanceof Player)) return false;
        Player player1 = (Player)entity1;
        if (!(entity instanceof LivingEntity)) return false;
        LivingEntity living1 = (LivingEntity)entity;
        if (SEHelper.getAllyEntities(player1).contains(living1)) return true;
        if (!SEHelper.getAllyEntityTypes(player1).contains(living1.m_6095_())) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean areNotFullAllies(@Nullable Entity entity, @Nullable Entity entity1) {
        if (entity == null) return true;
        if (entity1 == null) return true;
        if (!entity.m_7307_(entity1)) return true;
        if (!entity1.m_7307_(entity)) return true;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (entity1 instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity1;
                if (!SEHelper.getAllyEntities(player).contains(living)) {
                    if (!SEHelper.getAllyEntityTypes(player).contains(living.m_6095_())) return true;
                }
            }
        }
        if (!(entity1 instanceof Player)) return false;
        Player player1 = (Player)entity1;
        if (!(entity instanceof LivingEntity)) return false;
        LivingEntity living1 = (LivingEntity)entity;
        if (SEHelper.getAllyEntities(player1).contains(living1)) return false;
        if (SEHelper.getAllyEntityTypes(player1).contains(living1.m_6095_())) return false;
        return true;
    }

    public static BlockHitResult rayTrace(Entity entity, double distance, boolean fluids) {
        return (BlockHitResult)entity.m_19907_(distance, 1.0f, fluids);
    }

    public static void ClimbAnyWall(LivingEntity livingEntity) {
        Vec3 movement = livingEntity.m_20184_();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!player.m_150110_().f_35935_ && player.f_19862_) {
                movement = new Vec3(movement.f_82479_, 0.2, movement.f_82481_);
            }
            player.m_20256_(movement);
        } else {
            if (livingEntity.f_19862_) {
                movement = new Vec3(movement.f_82479_, 0.2, movement.f_82481_);
            }
            livingEntity.m_20256_(movement);
        }
    }

    public static List<BlockState> surroundingBlocks(LivingEntity livingEntity, Predicate<BlockState> blockPredicate) {
        ArrayList<BlockState> blockStates = new ArrayList<BlockState>();
        AABB axisalignedbb = livingEntity.m_20191_();
        BlockPos blockpos = BlockPos.m_274561_((double)(axisalignedbb.f_82288_ + 0.001), (double)(axisalignedbb.f_82289_ + 0.001), (double)(axisalignedbb.f_82290_ + 0.001));
        BlockPos blockpos1 = BlockPos.m_274561_((double)(axisalignedbb.f_82291_ - 0.001), (double)(axisalignedbb.f_82292_ - 0.001), (double)(axisalignedbb.f_82293_ - 0.001));
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        if (livingEntity.f_19853_.m_46832_(blockpos, blockpos1)) {
            for (int i = blockpos.m_123341_(); i <= blockpos1.m_123341_(); ++i) {
                for (int j = blockpos.m_123342_(); j <= blockpos1.m_123342_(); ++j) {
                    for (int k = blockpos.m_123343_(); k <= blockpos1.m_123343_(); ++k) {
                        blockpos$mutable.m_122178_(i, j, k);
                        BlockState blockstate = livingEntity.f_19853_.m_8055_((BlockPos)blockpos$mutable);
                        if (!blockPredicate.test(blockstate)) continue;
                        blockStates.add(blockstate);
                    }
                }
            }
        }
        return blockStates;
    }

    public static boolean isInBlock(LivingEntity livingEntity, Predicate<BlockState> blockPredicate) {
        return !MobUtil.surroundingBlocks(livingEntity, blockPredicate).isEmpty();
    }

    public static boolean isInWeb(LivingEntity livingEntity) {
        return MobUtil.isInBlock(livingEntity, blockState -> blockState.m_60734_() instanceof WebBlock);
    }

    public static void WebMovement(LivingEntity livingEntity) {
        for (BlockState blockState2 : MobUtil.surroundingBlocks(livingEntity, blockState -> blockState.m_60734_() instanceof WebBlock)) {
            livingEntity.m_7601_(blockState2, Vec3.f_82478_);
        }
    }

    public static void PowderedSnowMovement(LivingEntity livingEntity) {
        for (BlockState blockState2 : MobUtil.surroundingBlocks(livingEntity, blockState -> blockState.m_60734_() instanceof PowderSnowBlock)) {
            livingEntity.m_7601_(blockState2, Vec3.f_82478_);
        }
    }

    public static void dropFromLootTable(LivingEntity living, float luck) {
        ResourceLocation resourcelocation = living.m_5743_();
        LootTable loottable = living.f_19853_.m_7654_().m_278653_().m_278676_(resourcelocation);
        LootParams.Builder lootcontext$builder = MobUtil.createLootContext(living.m_269291_().m_269264_(), living, luck);
        LootParams ctx = lootcontext$builder.m_287235_(LootContextParamSets.f_81415_);
        loottable.m_287195_(ctx).forEach(arg_0 -> ((LivingEntity)living).m_19983_(arg_0));
    }

    public static LootParams.Builder createLootContext(DamageSource pDamageSource, LivingEntity livingEntity, float luck) {
        return new LootParams.Builder((ServerLevel)livingEntity.f_19853_).m_287286_(LootContextParams.f_81455_, (Object)livingEntity).m_287286_(LootContextParams.f_81460_, (Object)livingEntity.m_20182_()).m_287286_(LootContextParams.f_81457_, (Object)pDamageSource).m_287289_(LootContextParams.f_81458_, (Object)pDamageSource.m_7639_()).m_287289_(LootContextParams.f_81459_, (Object)pDamageSource.m_7640_()).m_287239_(luck);
    }

    public static LootParams.Builder createLootContext(DamageSource pDamageSource, LivingEntity livingEntity) {
        LivingEntity livingEntity2;
        LootParams.Builder lootparams$builder = new LootParams.Builder((ServerLevel)livingEntity.m_9236_()).m_287286_(LootContextParams.f_81455_, (Object)livingEntity).m_287286_(LootContextParams.f_81460_, (Object)livingEntity.m_20182_()).m_287286_(LootContextParams.f_81457_, (Object)pDamageSource).m_287289_(LootContextParams.f_81458_, (Object)pDamageSource.m_7639_()).m_287289_(LootContextParams.f_81459_, (Object)pDamageSource.m_7640_());
        if (livingEntity.m_21188_() != null && (livingEntity2 = livingEntity.m_21188_()) instanceof Player) {
            Player player = (Player)livingEntity2;
            lootparams$builder = lootparams$builder.m_287286_(LootContextParams.f_81456_, (Object)player).m_287239_(player.m_36336_());
        }
        return lootparams$builder;
    }

    public static void knockBack(LivingEntity knocked, Entity knocker, double xPower, double yPower, double zPower) {
        Player player;
        Vec3 vec3 = new Vec3(knocker.m_20185_() - knocked.m_20185_(), knocker.m_20186_() - knocked.m_20186_(), knocker.m_20189_() - knocked.m_20189_()).m_82541_();
        double pY0 = Math.max(-vec3.f_82480_, yPower);
        Vec3 vec31 = new Vec3(-vec3.f_82479_ * xPower, pY0, -vec3.f_82481_ * zPower);
        double resist = knocked.m_21133_(Attributes.f_22278_);
        double resist1 = Math.max(0.0, 1.0 - resist);
        if (knocked instanceof Player && MobUtil.playerValidity(player = (Player)knocked, false)) {
            player.f_19864_ = true;
            if (!player.f_19853_.f_46443_) {
                player.m_6853_(false);
            }
        }
        knocked.m_20256_(knocked.m_20184_().m_82549_(vec31).m_82490_(resist1));
        knocked.f_19812_ = true;
    }

    public static void forcefulKnockBack(LivingEntity knocked, double strength, double ratioX, double ratioZ, double reduction) {
        LivingKnockBackEvent event = ForgeHooks.onLivingKnockBack((LivingEntity)knocked, (float)((float)strength), (double)ratioX, (double)ratioZ);
        if (event.isCanceled()) {
            return;
        }
        strength = event.getStrength();
        ratioX = event.getRatioX();
        ratioZ = event.getRatioZ();
        if (!((strength *= 1.0 - knocked.m_21133_(Attributes.f_22278_) * reduction) <= 0.0)) {
            knocked.f_19812_ = true;
            Vec3 vec3 = knocked.m_20184_();
            Vec3 vec31 = new Vec3(ratioX, 0.0, ratioZ).m_82541_().m_82490_(strength);
            knocked.m_20334_(vec3.f_82479_ / 2.0 - vec31.f_82479_, knocked.m_20096_() ? Math.min(0.4, vec3.f_82480_ / 2.0 + strength) : vec3.f_82480_, vec3.f_82481_ / 2.0 - vec31.f_82481_);
        }
    }

    public static void push(Entity pEntity, double pX, double pY, double pZ) {
        Player player;
        if (pEntity instanceof Player && MobUtil.playerValidity(player = (Player)pEntity, false)) {
            player.f_19864_ = true;
            if (!player.f_19853_.f_46443_) {
                player.m_6853_(false);
            }
        }
        double resist = 0.0;
        if (pEntity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)pEntity;
            resist = living.m_21133_(Attributes.f_22278_);
        }
        double resist1 = Math.max(0.0, 1.0 - resist);
        pEntity.m_20256_(pEntity.m_20184_().m_82520_(pX, pY, pZ).m_82490_(resist1));
        pEntity.f_19812_ = true;
    }

    public static void forcePush(Entity pEntity, double pX, double pY, double pZ) {
        Player player;
        if (pEntity instanceof Player && MobUtil.playerValidity(player = (Player)pEntity, false)) {
            player.f_19864_ = true;
            if (!player.f_19853_.f_46443_) {
                player.m_6853_(false);
            }
        }
        pEntity.m_20256_(pEntity.m_20184_().m_82520_(pX, pY, pZ));
        pEntity.f_19812_ = true;
    }

    public static void twister(Entity pEntity, double pX, double pY, double pZ) {
        pEntity.m_20334_(pX, pY, pZ);
        pEntity.f_19812_ = true;
    }

    public static int getSummonLifespan(Level world) {
        return 20 * (30 + world.f_46441_.m_188503_(90));
    }

    public static List<EntityType<?>> getEntityTypesConfig(List<? extends String> config) {
        ArrayList list = new ArrayList();
        if (!config.isEmpty()) {
            for (String string : config) {
                EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(string));
                if (entityType == null) continue;
                list.add(entityType);
            }
        }
        return list;
    }

    public static boolean hasEntityTypesConfig(List<? extends String> config, EntityType<?> entityType) {
        return !MobUtil.getEntityTypesConfig(config).isEmpty() && MobUtil.getEntityTypesConfig(config).contains(entityType);
    }

    public static boolean isInRain(Entity pEntity) {
        BlockPos blockpos = pEntity.m_20183_();
        return pEntity.f_19853_.m_46758_(blockpos) || pEntity.f_19853_.m_46758_(BlockPos.m_274561_((double)blockpos.m_123341_(), (double)pEntity.m_20191_().f_82292_, (double)blockpos.m_123343_()));
    }

    public static boolean healthIsHalved(LivingEntity livingEntity) {
        return livingEntity.m_21223_() <= livingEntity.m_21233_() / 2.0f;
    }

    public static boolean starAmuletActive(LivingEntity livingEntity) {
        return CuriosFinder.hasCurio(livingEntity, (Item)ModItems.STAR_AMULET.get()) && MobUtil.healthIsHalved(livingEntity);
    }

    public static void releaseAllPois(Villager villager) {
        villager.m_35428_(MemoryModuleType.f_26359_);
        villager.m_35428_(MemoryModuleType.f_26360_);
        villager.m_35428_(MemoryModuleType.f_26361_);
        villager.m_35428_(MemoryModuleType.f_26362_);
    }

    public static List<Entity> getTargets(Level level, LivingEntity pSource, double pRange, double pRadius) {
        return MobUtil.getTargets(level, pSource, pRange, pRadius, EntitySelector.f_20406_.and(EntitySelector.f_20403_).and(entity -> !MobUtil.areAllies(entity, (Entity)pSource)));
    }

    public static List<Entity> getTargets(Level level, LivingEntity pSource, double pRange, double pRadius, Predicate<? super Entity> predicate) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        Vec3 srcVec = pSource.m_146892_();
        Vec3 lookVec = pSource.m_20252_(1.0f);
        double[] lookRange = new double[]{lookVec.m_7096_() * pRange, lookVec.m_7098_() * pRange, lookVec.m_7094_() * pRange};
        Vec3 destVec = srcVec.m_82520_(lookRange[0], lookRange[1], lookRange[2]);
        List possibleList = level.m_6249_((Entity)pSource, pSource.m_20191_().m_82363_(lookRange[0], lookRange[1], lookRange[2]).m_82377_(pRadius, pRadius, pRadius), predicate);
        double hitDist = 0.0;
        for (Entity hit : possibleList) {
            double possibleDist;
            if (!hit.m_6087_() || !pSource.m_142582_(hit) || hit == pSource) continue;
            float maxSize = pSource instanceof Mob ? 2.0f : 0.8f;
            float borderSize = Math.max(maxSize, hit.m_6143_());
            AABB collisionBB = hit.m_20191_().m_82400_((double)borderSize);
            Optional interceptPos = collisionBB.m_82371_(srcVec, destVec);
            if (collisionBB.m_82390_(srcVec)) {
                if (!(0.0 <= hitDist)) continue;
                list.add(hit);
                hitDist = 0.0;
                continue;
            }
            if (!interceptPos.isPresent() || !((possibleDist = srcVec.m_82554_((Vec3)interceptPos.get())) < hitDist) && hitDist != 0.0) continue;
            list.add(hit);
            hitDist = possibleDist;
        }
        return list;
    }

    @Nullable
    public static Entity getSingleTarget(Level pLevel, LivingEntity pSource, double pRange, double pRadius) {
        return MobUtil.getSingleTarget(pLevel, pSource, pRange, pRadius, EntitySelector.f_20406_.and(EntitySelector.f_20403_).and(entity -> !MobUtil.areAllies(entity, (Entity)pSource) && entity.m_6087_()));
    }

    @Nullable
    public static Entity getSingleTarget(Level pLevel, LivingEntity pSource, double pRange, double pRadius, Predicate<? super Entity> predicate) {
        Entity target = null;
        Vec3 srcVec = pSource.m_146892_();
        Vec3 lookVec = pSource.m_20252_(1.0f);
        double[] lookRange = new double[]{lookVec.m_7096_() * pRange, lookVec.m_7098_() * pRange, lookVec.m_7094_() * pRange};
        Vec3 destVec = srcVec.m_82520_(lookRange[0], lookRange[1], lookRange[2]);
        List possibleList = pLevel.m_6249_((Entity)pSource, pSource.m_20191_().m_82363_(lookRange[0], lookRange[1], lookRange[2]).m_82377_(pRadius, pRadius, pRadius), predicate);
        double hitDist = 0.0;
        for (Entity hit : possibleList) {
            double possibleDist;
            if (!pSource.m_142582_(hit) || hit == pSource) continue;
            float borderSize = Math.max(0.8f, hit.m_6143_());
            AABB collisionBB = hit.m_20191_().m_82377_((double)borderSize, (double)borderSize, (double)borderSize);
            Optional interceptPos = collisionBB.m_82371_(srcVec, destVec);
            if (collisionBB.m_82390_(srcVec)) {
                if (!(0.0 <= hitDist)) continue;
                target = hit;
                hitDist = 0.0;
                continue;
            }
            if (!interceptPos.isPresent() || !((possibleDist = srcVec.m_82554_((Vec3)interceptPos.get())) < hitDist) && hitDist != 0.0) continue;
            target = hit;
            hitDist = possibleDist;
        }
        return target;
    }

    @Nullable
    public static Entity getNearbyTarget(Level pLevel, LivingEntity pSource, double pRange, double pRadius) {
        Entity target = null;
        if (MobUtil.getSingleTarget(pLevel, pSource, pRange, pRadius) != null) {
            target = MobUtil.getSingleTarget(pLevel, pSource, pRange, pRadius);
        } else {
            Vec3 lookVec = pSource.m_20252_(1.0f);
            double[] lookRange = new double[]{lookVec.m_7096_() * pRange, lookVec.m_7098_() * pRange, lookVec.m_7094_() * pRange};
            List possibleList = pLevel.m_6249_((Entity)pSource, pSource.m_20191_().m_82386_(lookVec.f_82479_ / 2.0, 0.0, lookVec.f_82481_ / 2.0).m_82363_(lookRange[0], lookRange[1], lookRange[2]).m_82377_(pRadius, pRadius, pRadius), EntitySelector.f_20406_.and(EntitySelector.f_20403_).and(entity -> !MobUtil.areAllies(entity, (Entity)pSource)));
            for (Entity hit : possibleList) {
                if (!hit.m_6087_() || !pSource.m_142582_(hit)) continue;
                target = hit;
            }
        }
        return target;
    }

    public static void moveDownToGround(Entity entity) {
        BlockHitResult hitResult;
        HitResult rayTrace = MobUtil.rayTrace(entity);
        if (rayTrace.m_6662_() == HitResult.Type.BLOCK && (hitResult = (BlockHitResult)rayTrace).m_82434_() == Direction.UP) {
            BlockState hitBlock = entity.f_19853_.m_8055_(hitResult.m_82425_());
            if (hitBlock.m_60734_() instanceof SlabBlock && hitBlock.m_61143_((Property)BlockStateProperties.f_61397_) == SlabType.BOTTOM) {
                entity.m_6034_(entity.m_20185_(), (double)((float)hitResult.m_82425_().m_123342_() + 1.0625f - 0.5f), entity.m_20189_());
            } else {
                entity.m_6034_(entity.m_20185_(), (double)((float)hitResult.m_82425_().m_123342_() + 1.0625f), entity.m_20189_());
            }
            if (entity.f_19853_ instanceof ServerLevel) {
                ((ServerLevel)entity.f_19853_).m_7726_().m_8394_(entity, (Packet)new ClientboundTeleportEntityPacket(entity));
            }
        }
    }

    public static void moveUpFromGround(Entity entity, int distance) {
        BlockHitResult hitResult;
        HitResult rayTrace = MobUtil.rayTraceToAir(entity, distance);
        if (rayTrace.m_6662_() == HitResult.Type.BLOCK && (hitResult = (BlockHitResult)rayTrace).m_82434_() == Direction.DOWN) {
            entity.m_6034_(entity.m_20185_(), (double)((float)hitResult.m_82425_().m_123342_() - 1.0625f), entity.m_20189_());
            if (entity.f_19853_ instanceof ServerLevel) {
                ((ServerLevel)entity.f_19853_).m_7726_().m_8394_(entity, (Packet)new ClientboundTeleportEntityPacket(entity));
            }
        }
    }

    private static HitResult rayTrace(Entity entity) {
        Vec3 startPos = new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        Vec3 endPos = new Vec3(entity.m_20185_(), (double)entity.f_19853_.m_141937_(), entity.m_20189_());
        return entity.f_19853_.m_45547_(new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity));
    }

    private static HitResult rayTraceToAir(Entity entity, int distance) {
        Vec3 startPos = new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        Vec3 endPos = new Vec3(entity.m_20185_(), entity.m_20186_() + (double)distance, entity.m_20189_());
        return entity.f_19853_.m_45547_(new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity));
    }

    public static void throwSnapFungus(LivingEntity livingEntity, Level level) {
        SnapFungus blastFungus = new SnapFungus(livingEntity, level);
        MobUtil.throwFungus((Projectile)blastFungus, livingEntity);
    }

    public static void throwBlastFungus(LivingEntity livingEntity, Level level) {
        BlastFungus blastFungus = new BlastFungus(livingEntity, level);
        MobUtil.throwFungus((Projectile)blastFungus, livingEntity);
    }

    public static void throwFungus(Projectile projectile, LivingEntity livingEntity) {
        MobUtil.shootUp(projectile, livingEntity);
    }

    public static float ceilingVelocity(LivingEntity livingEntity) {
        return MobUtil.ceilingVelocity(livingEntity, 0.75f);
    }

    public static float ceilingVelocity(LivingEntity livingEntity, float initialV) {
        float f2 = 0.35f;
        if (BlockFinder.emptySquareSpace(livingEntity.f_19853_, livingEntity.m_20183_(), 13, true)) {
            f2 = initialV;
        } else if (BlockFinder.emptySquareSpace(livingEntity.f_19853_, livingEntity.m_20183_(), 6, true)) {
            f2 = 0.55f;
        }
        return f2;
    }

    public static void shootUp(Projectile projectile, LivingEntity livingEntity) {
        MobUtil.shootUp(projectile, livingEntity, MobUtil.ceilingVelocity(livingEntity));
    }

    public static void shootUp(Projectile projectile, LivingEntity livingEntity, float velocity) {
        projectile.m_37251_((Entity)livingEntity, -90.0f, 0.0f, 0.0f, velocity, 12.0f);
        livingEntity.f_19853_.m_7967_((Entity)projectile);
    }

    public static void shoot(LivingEntity livingEntity, double p_37266_, double p_37267_, double p_37268_, float p_37269_, float p_37270_) {
        Vec3 vec3 = new Vec3(p_37266_, p_37267_, p_37268_).m_82541_().m_82520_(livingEntity.m_217043_().m_216328_(0.0, 0.0172275 * (double)p_37270_), livingEntity.m_217043_().m_216328_(0.0, 0.0172275 * (double)p_37270_), livingEntity.m_217043_().m_216328_(0.0, 0.0172275 * (double)p_37270_)).m_82490_((double)p_37269_);
        livingEntity.m_20256_(vec3);
    }

    public static int getPotentialBonusSpawns(Raid.RaiderType p_219829_, RandomSource p_219830_, int p_219831_, DifficultyInstance p_219832_, boolean p_219833_) {
        int i;
        Difficulty difficulty = p_219832_.m_19048_();
        boolean flag = difficulty == Difficulty.EASY;
        boolean flag1 = difficulty == Difficulty.NORMAL;
        switch (p_219829_) {
            case WITCH: {
                if (flag || p_219831_ <= 2 || p_219831_ == 4) {
                    return 0;
                }
                i = 1;
                break;
            }
            case PILLAGER: 
            case VINDICATOR: {
                if (flag) {
                    i = p_219830_.m_188503_(2);
                    break;
                }
                if (flag1) {
                    i = 1;
                    break;
                }
                i = 2;
                break;
            }
            case RAVAGER: {
                i = !flag && p_219833_ ? 1 : 0;
                break;
            }
            default: {
                return 0;
            }
        }
        return i > 0 ? p_219830_.m_188503_(i + 1) : 0;
    }

    public static boolean isFinalWave(Raid raid) {
        return raid.m_37771_() == raid.m_37724_(raid.m_37769_().m_46791_());
    }

    public static boolean hasBonusWave(Raid raid) {
        return raid.m_37773_() > 1;
    }

    public static boolean shouldSpawnBonusGroup(Raid raid) {
        return MobUtil.isFinalWave(raid) && raid.m_37778_() == 0 && MobUtil.hasBonusWave(raid);
    }

    public static List<Entity> explosionRangeEntities(Level level, Entity source, BlockPos blockPos, float range) {
        return MobUtil.explosionRangeEntities(level, source, blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_(), range);
    }

    public static List<Entity> explosionRangeEntities(Level level, Entity source, double x, double y, double z, float radius) {
        float f2 = radius * 2.0f;
        int k1 = Mth.m_14107_((double)(x - (double)f2 - 1.0));
        int l1 = Mth.m_14107_((double)(x + (double)f2 + 1.0));
        int i2 = Mth.m_14107_((double)(y - (double)f2 - 1.0));
        int i1 = Mth.m_14107_((double)(y + (double)f2 + 1.0));
        int j2 = Mth.m_14107_((double)(z - (double)f2 - 1.0));
        int j1 = Mth.m_14107_((double)(z + (double)f2 + 1.0));
        return level.m_45933_(source, new AABB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
    }

    public static void explosionDamage(Level level, Entity source, DamageSource damageSource, double x, double y, double z, float radius) {
        MobUtil.explosionDamage(level, source, damageSource, x, y, z, radius, 0.0f);
    }

    public static void explosionDamage(Level level, Entity source, DamageSource damageSource, BlockPos blockPos, float radius, float damage) {
        MobUtil.explosionDamage(level, source, damageSource, blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_(), radius, damage);
    }

    public static void explosionDamage(Level level, Entity source, DamageSource damageSource, double x, double y, double z, float radius, float damage) {
        float f2 = radius * 2.0f;
        Vec3 vec3 = new Vec3(x, y, z);
        for (Entity entity : MobUtil.explosionRangeEntities(level, source, x, y, z, radius)) {
            double d9;
            double d7;
            double d5;
            double d13;
            double d12 = Math.sqrt(entity.m_20238_(vec3)) / (double)f2;
            if (!(d12 <= 1.0) || (d13 = Math.sqrt((d5 = entity.m_20185_() - x) * d5 + (d7 = entity.m_20188_() - y) * d7 + (d9 = entity.m_20189_() - z) * d9)) == 0.0) continue;
            d5 /= d13;
            d7 /= d13;
            d9 /= d13;
            double d14 = MobUtil.getSeenPercent(vec3, entity);
            double d10 = (1.0 - d12) * d14;
            float actualDamage = damage == 0.0f ? (float)((int)((d10 * d10 + d10) / 2.0 * 7.0 * (double)f2 + 1.0)) : damage;
            entity.m_6469_(damageSource, actualDamage);
            double d11 = d10;
            if (entity instanceof LivingEntity) {
                d11 = ProtectionEnchantment.m_45135_((LivingEntity)((LivingEntity)entity), (double)d10);
            }
            if (damageSource.m_276093_(DamageTypes.f_268515_) && entity instanceof FireTornado) {
                FireTornado fireTornado = (FireTornado)entity;
                fireTornado.trueRemove();
            }
            MobUtil.push(entity, d5 * d11, d7 * d11, d9 * d11);
        }
    }

    public static float getSeenPercent(Vec3 vector, Entity target) {
        AABB aabb = target.m_20191_();
        double d0 = 1.0 / ((aabb.f_82291_ - aabb.f_82288_) * 2.0 + 1.0);
        double d1 = 1.0 / ((aabb.f_82292_ - aabb.f_82289_) * 2.0 + 1.0);
        double d2 = 1.0 / ((aabb.f_82293_ - aabb.f_82290_) * 2.0 + 1.0);
        double d3 = (1.0 - Math.floor(1.0 / d0) * d0) / 2.0;
        double d4 = (1.0 - Math.floor(1.0 / d2) * d2) / 2.0;
        if (!(d0 < 0.0 || d1 < 0.0 || d2 < 0.0)) {
            int i = 0;
            int j = 0;
            for (double d5 = 0.0; d5 <= 1.0; d5 += d0) {
                for (double d6 = 0.0; d6 <= 1.0; d6 += d1) {
                    for (double d7 = 0.0; d7 <= 1.0; d7 += d2) {
                        double d10;
                        double d9;
                        double d8 = Mth.m_14139_((double)d5, (double)aabb.f_82288_, (double)aabb.f_82291_);
                        Vec3 vec3 = new Vec3(d8 + d3, d9 = Mth.m_14139_((double)d6, (double)aabb.f_82289_, (double)aabb.f_82292_), (d10 = Mth.m_14139_((double)d7, (double)aabb.f_82290_, (double)aabb.f_82293_)) + d4);
                        if (target.f_19853_.m_45547_(new ClipContext(vec3, vector, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, target)).m_6662_() == HitResult.Type.MISS) {
                            ++i;
                        }
                        ++j;
                    }
                }
            }
            return (float)i / (float)j;
        }
        return 0.0f;
    }

    public static boolean canPositionBeSeen(Level level, LivingEntity living, double x, double y, double z) {
        BlockHitResult result = level.m_45547_(new ClipContext(new Vec3(living.m_20185_(), living.m_20186_() + (double)living.m_20192_(), living.m_20189_()), new Vec3(x, y, z), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)living));
        double dist = result.m_82450_().m_82531_(x, y, z);
        return dist <= 1.0 || result.m_6662_() == HitResult.Type.MISS;
    }

    public static float getEquipmentDropChance(Mob mob, EquipmentSlot p_21520_) {
        return switch (p_21520_.m_20743_()) {
            case EquipmentSlot.Type.HAND -> mob.f_21347_[p_21520_.m_20749_()];
            case EquipmentSlot.Type.ARMOR -> mob.f_21348_[p_21520_.m_20749_()];
            default -> 0.0f;
        };
    }

    @Nullable
    public static Entity convertTo(Entity originalEntity, EntityType<?> convertedType, boolean loot, Player player) {
        return MobUtil.convertTo(originalEntity, convertedType, loot, false, player);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static Entity convertTo(Entity originalEntity, EntityType<?> convertedType, boolean loot, boolean newEquip, Player player) {
        block11: {
            block12: {
                block13: {
                    if (originalEntity.m_213877_()) {
                        return null;
                    }
                    newEntity = convertedType.m_20615_(originalEntity.f_19853_);
                    if (newEntity == null) break block11;
                    newEntity.m_20359_(originalEntity);
                    if (!(originalEntity instanceof Mob)) break block12;
                    originalMob = (Mob)originalEntity;
                    if (!(newEntity instanceof Mob)) break block12;
                    newMob = (Mob)newEntity;
                    newMob.m_6863_(originalMob.m_6162_());
                    newMob.m_21557_(originalMob.m_21525_());
                    if (originalMob.m_8077_()) {
                        newEntity.m_6593_(originalMob.m_7770_());
                        newEntity.m_20340_(originalMob.m_20151_());
                    }
                    if (originalMob.m_21532_()) {
                        newMob.m_21530_();
                    }
                    newMob.m_20331_(originalMob.m_20147_());
                    if (loot) {
                        newMob.m_21553_(originalMob.m_21531_());
                        for (EquipmentSlot equipmentslot : EquipmentSlot.values()) {
                            itemstack = originalMob.m_6844_(equipmentslot);
                            if (itemstack.m_41619_()) continue;
                            newMob.m_8061_(equipmentslot, itemstack.m_41777_());
                            newMob.m_21409_(equipmentslot, MobUtil.getEquipmentDropChance(originalMob, equipmentslot));
                            itemstack.m_41764_(0);
                        }
                    }
                    if (player != null) {
                        MobUtil.summonTame((Entity)newMob, player);
                    }
                    if (!((var9_10 = originalMob.f_19853_) instanceof ServerLevel)) break block13;
                    serverLevel = (ServerLevel)var9_10;
                    if (!(originalMob instanceof Villager)) ** GOTO lbl-1000
                    villager = (Villager)originalMob;
                    if (newMob instanceof ZombieVillager) {
                        zombievillager = (ZombieVillager)newMob;
                        zombievillager.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(zombievillager.m_20183_()), MobSpawnType.CONVERSION, (SpawnGroupData)new Zombie.ZombieGroupData(false, true), (CompoundTag)null);
                        zombievillager.m_34375_(villager.m_7141_());
                        zombievillager.m_34391_((Tag)villager.m_35517_().m_262795_((DynamicOps)NbtOps.f_128958_));
                        zombievillager.m_34411_(villager.m_6616_().m_45388_());
                        zombievillager.m_34373_(villager.m_7809_());
                        if (!originalMob.m_20067_()) {
                            serverLevel.m_5898_((Player)null, 1026, originalMob.m_20183_(), 0);
                        }
                    } else if (newEquip && newMob instanceof IOwned) {
                        owned = (IOwned)newMob;
                        owned.convertNewEquipment(originalEntity);
                    }
                }
                originalMob.f_19853_.m_7967_(newEntity);
                if (originalMob.m_20159_() && (entity = originalMob.m_20202_()) != null) {
                    originalMob.m_8127_();
                    newEntity.m_7998_(entity, true);
                }
            }
            originalEntity.m_146870_();
        }
        return newEntity;
    }

    public static void summonTame(Entity entity, Player player) {
        if (entity instanceof TamableAnimal) {
            TamableAnimal tamableAnimal = (TamableAnimal)entity;
            tamableAnimal.m_21828_(player);
        } else if (entity instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)entity;
            horse.m_30651_(true);
            horse.m_30586_(player.m_20148_());
        } else if (entity instanceof IOwned) {
            IOwned summonedEntity = (IOwned)entity;
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                mob.m_21530_();
                summonedEntity.setTrueOwner((LivingEntity)player);
                if (summonedEntity instanceof IServant) {
                    IServant summoned = (IServant)summonedEntity;
                    summoned.setWandering(false);
                }
                if (summonedEntity instanceof RedstoneGolem || summonedEntity instanceof GraveGolem) {
                    SEHelper.addSummon(player, (LivingEntity)mob);
                }
            }
        }
    }

    public static void explodeCreeper(Creeper creeper) {
        if (!creeper.f_19853_.f_46443_) {
            float f = creeper.m_7090_() ? 2.0f : 1.0f;
            creeper.f_19853_.m_254849_((Entity)creeper, creeper.m_20185_(), creeper.m_20186_(), creeper.m_20189_(), 3.0f * f, Level.ExplosionInteraction.MOB);
            creeper.m_146870_();
            MobUtil.spawnLingeringCloud(creeper);
        }
    }

    public static void spawnLingeringCloud(Creeper creeper) {
        Collection collection = creeper.m_21220_();
        if (!collection.isEmpty()) {
            AreaEffectCloud areaeffectcloud = new AreaEffectCloud(creeper.f_19853_, creeper.m_20185_(), creeper.m_20186_(), creeper.m_20189_());
            areaeffectcloud.m_19712_(2.5f);
            areaeffectcloud.m_19732_(-0.5f);
            areaeffectcloud.m_19740_(10);
            areaeffectcloud.m_19734_(areaeffectcloud.m_19748_() / 2);
            areaeffectcloud.m_19738_(-areaeffectcloud.m_19743_() / (float)areaeffectcloud.m_19748_());
            for (MobEffectInstance mobeffectinstance : collection) {
                areaeffectcloud.m_19716_(new MobEffectInstance(mobeffectinstance));
            }
            creeper.f_19853_.m_7967_((Entity)areaeffectcloud);
        }
    }

    public static boolean hasNegativeEffects(LivingEntity livingEntity) {
        return !livingEntity.m_21220_().isEmpty() && livingEntity.m_21220_().stream().anyMatch(mobEffectInstance2 -> mobEffectInstance2.m_19544_().m_19483_() == MobEffectCategory.HARMFUL);
    }

    public static boolean hasLongNegativeEffects(LivingEntity livingEntity) {
        return !livingEntity.m_21220_().isEmpty() && livingEntity.m_21220_().stream().anyMatch(mobEffectInstance2 -> mobEffectInstance2.m_19544_().m_19483_() == MobEffectCategory.HARMFUL && mobEffectInstance2.m_19557_() > MathHelper.secondsToTicks(5));
    }

    public static boolean isMoving(LivingEntity livingEntity) {
        return livingEntity.m_20096_() && livingEntity.m_20184_().m_165925_() > 2.500000277905201E-7;
    }

    public static boolean hasVisualLineOfSight(LivingEntity looker, Entity target) {
        if (target.f_19853_ != looker.f_19853_) {
            return false;
        }
        Vec3 vec3 = new Vec3(looker.m_20185_(), looker.m_20188_(), looker.m_20189_());
        Vec3 vec31 = new Vec3(target.m_20185_(), target.m_20188_(), target.m_20189_());
        if (vec31.m_82554_(vec3) > 128.0) {
            return false;
        }
        return looker.f_19853_.m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, (Entity)looker)).m_6662_() == HitResult.Type.MISS;
    }

    public static boolean isPushed(LivingEntity livingEntity) {
        List list = livingEntity.f_19853_.m_6249_((Entity)livingEntity, livingEntity.m_20191_(), EntitySelector.m_20421_((Entity)livingEntity));
        return !list.isEmpty() && livingEntity.m_6094_();
    }

    public static boolean isInSunlight(LivingEntity livingEntity) {
        if (livingEntity.m_9236_().m_46461_() && !livingEntity.m_9236_().f_46443_) {
            float f = livingEntity.m_213856_();
            BlockPos blockpos = BlockPos.m_274561_((double)livingEntity.m_20185_(), (double)livingEntity.m_20188_(), (double)livingEntity.m_20189_());
            boolean flag = livingEntity.m_20071_() || livingEntity.f_146808_ || livingEntity.f_146809_;
            return f > 0.5f && livingEntity.m_217043_().m_188501_() * 30.0f < (f - 0.4f) * 2.0f && !flag && livingEntity.m_9236_().m_45527_(blockpos);
        }
        return false;
    }

    public static boolean ownerStack(IOwned owned0, IOwned owned1) {
        LivingEntity masterOwner0 = owned0.getMasterOwner();
        LivingEntity masterOwner1 = owned1.getMasterOwner();
        LivingEntity trueOwner0 = owned0.getTrueOwner();
        LivingEntity trueOwner1 = owned1.getTrueOwner();
        if (trueOwner0 != null && trueOwner1 != null) {
            if (masterOwner0 != null && masterOwner1 != null) {
                return masterOwner0 == masterOwner1;
            }
            if (masterOwner0 != null) {
                return masterOwner0 == trueOwner1;
            }
            if (masterOwner1 != null) {
                return masterOwner1 == trueOwner0;
            }
            return trueOwner0 == trueOwner1;
        }
        return false;
    }

    public static boolean isSpellCasting(LivingEntity livingEntity) {
        return livingEntity.m_6117_() && livingEntity.m_21211_().m_41720_() instanceof DarkWand && !WandUtil.findFocus(livingEntity).m_41619_();
    }

    public static void instaLook(Mob mob, Vec3 vec3) {
        mob.m_21563_().m_24950_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 200.0f, (float)mob.m_8132_());
        double d2 = vec3.f_82479_ - mob.m_20185_();
        double d1 = vec3.f_82481_ - mob.m_20189_();
        mob.m_146922_(-((float)Mth.m_14136_((double)d2, (double)d1)) * 57.295776f);
        mob.f_20883_ = mob.m_146908_();
    }

    public static void instaLook(Mob looker, LivingEntity target) {
        looker.m_21563_().m_24960_((Entity)target, 200.0f, (float)looker.m_8132_());
        double d2 = target.m_20185_() - looker.m_20185_();
        double d1 = target.m_20189_() - looker.m_20189_();
        looker.m_146922_(-((float)Mth.m_14136_((double)d2, (double)d1)) * 57.295776f);
        looker.f_20883_ = looker.m_146908_();
    }

    public static ItemStack createFirework(int explosions, DyeColor[] dyeColor) {
        ItemStack firework = new ItemStack((ItemLike)Items.f_42688_);
        ItemStack star = new ItemStack((ItemLike)Items.f_42689_);
        CompoundTag starTag = star.m_41698_("Explosion");
        starTag.m_128405_("Type", FireworkRocketItem.Shape.BURST.m_41236_());
        CompoundTag fireworkTag = firework.m_41698_("Fireworks");
        ListTag explosionTags = new ListTag();
        CompoundTag starExplosionTag = star.m_41737_("Explosion");
        if (starExplosionTag != null) {
            ArrayList colorList = Lists.newArrayList();
            for (DyeColor color : dyeColor) {
                int pinkFireworkColor = color.m_41070_();
                colorList.add(pinkFireworkColor);
            }
            starExplosionTag.m_128408_("Colors", (List)colorList);
            starExplosionTag.m_128408_("FadeColors", (List)colorList);
            for (int i = 0; i < explosions; ++i) {
                explosionTags.add((Object)starExplosionTag);
            }
        }
        if (!explosionTags.isEmpty()) {
            fireworkTag.m_128365_("Explosions", (Tag)explosionTags);
        }
        return firework;
    }

    public static void hurtUsedShield(LivingEntity living, float p_36383_) {
        if (living.m_21211_().canPerformAction(ToolActions.SHIELD_BLOCK)) {
            if (!living.f_19853_.f_46443_ && living instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)living;
                player.m_36246_(Stats.f_12982_.m_12902_((Object)player.m_21211_().m_41720_()));
            }
            if (p_36383_ >= 3.0f) {
                int i = 1 + Mth.m_14143_((float)p_36383_);
                InteractionHand interactionhand = living.m_7655_();
                living.m_21211_().m_41622_(i, living, p_219739_ -> {
                    p_219739_.m_21190_(interactionhand);
                    if (living instanceof Player) {
                        Player player = (Player)living;
                        ForgeEventFactory.onPlayerDestroyItem((Player)player, (ItemStack)living.m_21211_(), (InteractionHand)interactionhand);
                    }
                });
                if (living.m_21211_().m_41619_()) {
                    if (interactionhand == InteractionHand.MAIN_HAND) {
                        living.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                    } else {
                        living.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
                    }
                    living.m_5496_(SoundEvents.f_12347_, 0.8f, 0.8f + living.f_19853_.f_46441_.m_188501_() * 0.4f);
                }
            }
        }
    }

    public static boolean canAttack(LivingEntity attacker, LivingEntity target) {
        return !attacker.m_7307_((Entity)target) && !target.m_7307_((Entity)attacker) && EntitySelector.f_20406_.test(target) && attacker.m_6779_(target);
    }

    public static boolean mobCanAttack(Mob attacker, LivingEntity target) {
        if (attacker.m_5448_() == target) {
            return EntitySelector.f_20406_.test(target) && attacker.m_6779_(target);
        }
        return MobUtil.canAttack((LivingEntity)attacker, target);
    }

    public static boolean ownedCanAttack(Owned attacker, LivingEntity target) {
        if (attacker.getTrueOwner() != null) {
            LivingEntity owner = attacker.getTrueOwner();
            if (owner instanceof Mob) {
                Mob mob = (Mob)owner;
                return MobUtil.mobCanAttack(mob, target);
            }
            return MobUtil.canAttack(owner, target);
        }
        return MobUtil.mobCanAttack((Mob)attacker, target);
    }

    public static void sweepAttack(LivingEntity attacker, Entity target, DamageSource damageSource, float damage) {
        MobUtil.sweepAttack(attacker, target, damageSource, 1.0, damage);
    }

    public static void sweepAttack(LivingEntity attacker, Entity target, DamageSource damageSource, double radius, float damage) {
        for (LivingEntity livingentity : attacker.f_19853_.m_45976_(LivingEntity.class, target.m_20191_().m_82377_(radius, 0.25, radius))) {
            if (livingentity == attacker || livingentity == target || attacker.m_7307_((Entity)livingentity) || livingentity instanceof ArmorStand && ((ArmorStand)livingentity).m_31677_() || !attacker.m_6779_(livingentity)) continue;
            livingentity.m_147240_((double)0.4f, (double)Mth.m_14031_((float)(attacker.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(attacker.m_146908_() * ((float)Math.PI / 180)))));
            livingentity.m_6469_(damageSource, damage);
        }
    }

    public static List<LivingEntity> getAttackableLivingEntitiesNearby(LivingEntity source, double distanceX, double distanceY, double distanceZ, double radius) {
        return MobUtil.getLivingEntitiesNearby((Entity)source, distanceX, distanceY, distanceZ, radius).stream().filter(target -> MobUtil.canAttack(source, target)).toList();
    }

    public static List<LivingEntity> getLivingEntitiesNearby(Entity source, double distanceX, double distanceY, double distanceZ, double radius) {
        return MobUtil.getEntitiesNearby(source, LivingEntity.class, distanceX, distanceY, distanceZ, radius);
    }

    public static <T extends Entity> List<T> getEntitiesNearby(Entity source, Class<T> entityClass, double dX, double dY, double dZ, double radius) {
        return source.f_19853_.m_6443_(entityClass, source.m_20191_().m_82377_(dX, dY, dZ), target -> target != source && (double)source.m_20270_(target) <= radius + (double)(target.m_20205_() / 2.0f) && target.m_20186_() <= source.m_20186_() + dY);
    }

    public static WeightedRandomList<MobSpawnSettings.SpawnerData> mobsAt(ServerLevel p_220444_, StructureManager p_220445_, ChunkGenerator p_220446_, MobCategory p_220447_, BlockPos p_220448_, @Nullable Holder<Biome> p_220449_) {
        return ForgeEventFactory.getPotentialSpawns((LevelAccessor)p_220444_, (MobCategory)p_220447_, (BlockPos)p_220448_, (WeightedRandomList)(NaturalSpawner.m_220455_((BlockPos)p_220448_, (ServerLevel)p_220444_, (MobCategory)p_220447_, (StructureManager)p_220445_) ? ((StructureSpawnOverride)((Structure)p_220445_.m_220521_().m_175515_(Registries.f_256944_).m_123013_(BuiltinStructures.f_209859_)).m_226612_().get(MobCategory.MONSTER)).f_210044_() : p_220446_.m_223133_(p_220449_ != null ? p_220449_ : p_220444_.m_204166_(p_220448_), p_220445_, p_220447_, p_220448_)));
    }

    public static Vec3 calculateViewVector(float p_20172_, float p_20173_) {
        float f = p_20172_ * ((float)Math.PI / 180);
        float f1 = -p_20173_ * ((float)Math.PI / 180);
        float f2 = Mth.m_14089_((float)f1);
        float f3 = Mth.m_14031_((float)f1);
        float f4 = Mth.m_14089_((float)f);
        float f5 = Mth.m_14031_((float)f);
        return new Vec3((double)(f3 * f4), (double)(-f5), (double)(f2 * f4));
    }

    public static void setRot(Entity entity, float p_19916_, float p_19917_) {
        entity.m_146922_(p_19916_ % 360.0f);
        entity.m_146926_(p_19917_ % 360.0f);
    }

    public static void setBaseAttributes(AttributeInstance attribute, double value) {
        if (attribute != null) {
            attribute.m_22100_(value);
        }
    }

    public static double getAttributeValue(LivingEntity livingEntity, Attribute attribute) {
        return MobUtil.getAttributeValue(livingEntity, attribute, 0.0);
    }

    public static double getAttributeValue(LivingEntity livingEntity, Attribute attribute, double nullCheck) {
        if (livingEntity.m_21051_(attribute) != null) {
            return livingEntity.m_21133_(attribute);
        }
        return nullCheck;
    }

    public static class WraithMoveController
    extends MoveControl {
        public WraithMoveController(Mob mob) {
            super(mob);
        }

        public void m_8126_() {
            if (this.f_24974_.m_20068_()) {
                if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                    Vec3 vector3d = new Vec3(this.f_24975_ - this.f_24974_.m_20185_(), this.f_24976_ - this.f_24974_.m_20186_(), this.f_24977_ - this.f_24974_.m_20189_());
                    double d0 = vector3d.m_82553_();
                    if (d0 < this.f_24974_.m_20191_().m_82309_()) {
                        this.f_24981_ = MoveControl.Operation.WAIT;
                        this.f_24974_.m_20256_(this.f_24974_.m_20184_().m_82490_(0.5));
                    } else {
                        this.f_24974_.m_20256_(this.f_24974_.m_20184_().m_82549_(vector3d.m_82490_(this.f_24978_ * 0.05 / d0)));
                        if (this.f_24974_.m_5448_() == null) {
                            Vec3 vector3d1 = this.f_24974_.m_20184_();
                            this.f_24974_.m_146922_(-((float)Mth.m_14136_((double)vector3d1.f_82479_, (double)vector3d1.f_82481_)) * 57.295776f);
                        } else {
                            double d2 = this.f_24974_.m_5448_().m_20185_() - this.f_24974_.m_20185_();
                            double d1 = this.f_24974_.m_5448_().m_20189_() - this.f_24974_.m_20189_();
                            this.f_24974_.m_146922_(-((float)Mth.m_14136_((double)d2, (double)d1)) * 57.295776f);
                        }
                        this.f_24974_.f_20883_ = this.f_24974_.m_146908_();
                    }
                }
            } else {
                super.m_8126_();
            }
        }
    }

    public static class MinionMoveControl
    extends MoveControl {
        public MinionMoveControl(Mob mob) {
            super(mob);
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                Vec3 vector3d = new Vec3(this.f_24975_ - this.f_24974_.m_20185_(), this.f_24976_ - this.f_24974_.m_20186_(), this.f_24977_ - this.f_24974_.m_20189_());
                double d0 = vector3d.m_82553_();
                if (d0 < this.f_24974_.m_20191_().m_82309_()) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                    this.f_24974_.m_20256_(this.f_24974_.m_20184_().m_82490_(0.5));
                } else {
                    this.f_24974_.m_20256_(this.f_24974_.m_20184_().m_82549_(vector3d.m_82490_(this.f_24978_ * 0.05 / d0)));
                    if (this.f_24974_.m_5448_() == null) {
                        Vec3 vec31 = this.f_24974_.m_20184_();
                        this.f_24974_.m_146922_(-((float)Mth.m_14136_((double)vec31.f_82479_, (double)vec31.f_82481_)) * 57.295776f);
                        this.f_24974_.f_20883_ = this.f_24974_.m_146908_();
                    } else {
                        double d2 = this.f_24974_.m_5448_().m_20185_() - this.f_24974_.m_20185_();
                        double d1 = this.f_24974_.m_5448_().m_20189_() - this.f_24974_.m_20189_();
                        this.f_24974_.m_146922_(-((float)Mth.m_14136_((double)d2, (double)d1)) * 57.295776f);
                    }
                    this.f_24974_.f_20883_ = this.f_24974_.m_146908_();
                }
            }
        }
    }
}

