/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.utils;

import com.Polarice3.Goety.ItemConfig;
import com.Polarice3.Goety.utils.SEHelper;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class ItemHelper {
    public static <T extends LivingEntity> void hurtAndRemove(ItemStack stack, int pAmount, T pEntity) {
        if (!(pEntity.f_19853_.f_46443_ || pEntity instanceof Player && ((Player)pEntity).m_150110_().f_35937_ || !stack.m_41763_() || !stack.m_220157_(pAmount, pEntity.m_217043_(), pEntity instanceof ServerPlayer ? (ServerPlayer)pEntity : null))) {
            stack.m_41774_(1);
            stack.m_41721_(0);
        }
    }

    public static <T extends LivingEntity> void hurtAndBreak(ItemStack itemStack, int pAmount, T pEntity) {
        itemStack.m_41622_(pAmount, pEntity, p_220045_0_ -> p_220045_0_.m_21166_(EquipmentSlot.MAINHAND));
    }

    public static void hurtNoEntity(ItemStack itemStack, int pAmount, Level level) {
        if (!level.f_46443_ && itemStack.m_41763_() && itemStack.m_220157_(pAmount, level.m_213780_(), null)) {
            itemStack.m_41774_(1);
            itemStack.m_41721_(0);
        }
    }

    public static ItemEntity itemEntityDrop(LivingEntity livingEntity, ItemStack itemStack) {
        return new ItemEntity(livingEntity.f_19853_, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), itemStack);
    }

    public static void addItemEntity(Level level, BlockPos blockPos, ItemStack itemStack) {
        double d0 = (double)(level.f_46441_.m_188501_() * 0.5f) + 0.25;
        double d1 = (double)(level.f_46441_.m_188501_() * 0.5f) + 0.25;
        double d2 = (double)(level.f_46441_.m_188501_() * 0.5f) + 0.25;
        ItemEntity itementity = new ItemEntity(level, (double)blockPos.m_123341_() + d0, (double)blockPos.m_123342_() + d1, (double)blockPos.m_123343_() + d2, itemStack);
        itementity.m_32060_();
        level.m_7967_((Entity)itementity);
    }

    public static void addAndConsumeItem(Player player, InteractionHand hand, ItemStack toAdd) {
        ItemHelper.addAndConsumeItem(player, hand, toAdd, true);
    }

    public static void addAndConsumeItem(Player player, InteractionHand hand, ItemStack toAdd, boolean addToInventory) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41613_() == 1) {
            if (!player.m_7500_()) {
                player.m_21008_(hand, toAdd);
            } else if (addToInventory && !player.m_150109_().m_36054_(toAdd)) {
                player.m_7197_(toAdd, false, true);
            }
        } else {
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            if (!player.m_150109_().m_36054_(toAdd)) {
                player.m_7197_(toAdd, false, true);
            }
        }
    }

    public static boolean hasItem(Player player, Item item) {
        return !ItemHelper.findItem(player, item).m_41619_();
    }

    public static ItemStack findItem(Player playerEntity, Item item) {
        ItemStack foundStack = ItemStack.f_41583_;
        for (int i = 0; i < playerEntity.m_150109_().m_6643_(); ++i) {
            ItemStack itemStack = playerEntity.m_150109_().m_8020_(i);
            if (itemStack.m_41619_() || itemStack.m_41720_() != item) continue;
            foundStack = itemStack;
            break;
        }
        return foundStack;
    }

    public static ItemStack findItem(Player playerEntity, Predicate<ItemStack> item) {
        ItemStack foundStack = ItemStack.f_41583_;
        for (int i = 0; i < playerEntity.m_150109_().m_6643_(); ++i) {
            ItemStack itemStack = playerEntity.m_150109_().m_8020_(i);
            if (itemStack.m_41619_() || !item.test(itemStack)) continue;
            foundStack = itemStack;
            break;
        }
        return foundStack;
    }

    public static boolean findHelmet(Player player, Item item) {
        return player.m_6844_(EquipmentSlot.HEAD).m_41720_() == item;
    }

    public static boolean armorSet(LivingEntity living, ArmorMaterial material) {
        int i = 0;
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            ArmorItem armorItem;
            Item item;
            if (equipmentSlot.m_20743_() != EquipmentSlot.Type.ARMOR || !((item = living.m_6844_(equipmentSlot).m_41720_()) instanceof ArmorItem) || (armorItem = (ArmorItem)item).m_40401_() != material) continue;
            ++i;
        }
        return i >= 4;
    }

    public static boolean isFullEquipped(LivingEntity living) {
        int i = 0;
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            if (equipmentSlot.m_20743_() != EquipmentSlot.Type.ARMOR || living.m_6844_(equipmentSlot).m_41619_()) continue;
            ++i;
        }
        return i >= 4;
    }

    public static boolean isFullArmored(LivingEntity living) {
        int i = 0;
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            if (equipmentSlot.m_20743_() != EquipmentSlot.Type.ARMOR || !(living.m_6844_(equipmentSlot).m_41720_() instanceof ArmorItem)) continue;
            ++i;
        }
        return i >= 4;
    }

    public static boolean noArmor(LivingEntity living) {
        int i = 0;
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            if (equipmentSlot.m_20743_() != EquipmentSlot.Type.ARMOR || !living.m_6844_(equipmentSlot).m_41619_()) continue;
            ++i;
        }
        return i >= 4;
    }

    public static void repairTick(ItemStack stack, Entity entityIn, boolean isSelected) {
        if (((Boolean)ItemConfig.SoulRepair.get()).booleanValue() && entityIn instanceof Player) {
            Player player = (Player)entityIn;
            if ((!player.f_20911_ || !isSelected) && stack.m_41768_() && SEHelper.getSoulsContainer(player)) {
                int i = 1;
                if (!stack.getAllEnchantments().isEmpty()) {
                    i += stack.getAllEnchantments().size();
                }
                if (SEHelper.getSoulsAmount(player, (Integer)ItemConfig.ItemsRepairAmount.get() * i) && player.f_19797_ % 20 == 0) {
                    stack.m_41721_(stack.m_41773_() - 1);
                    SEHelper.decreaseSouls(player, (Integer)ItemConfig.ItemsRepairAmount.get() * i);
                }
            }
        }
    }

    public static boolean isValidFluidContainerToDrain(ItemStack stack, Fluid fluid) {
        if (stack.m_41619_() || stack.m_41613_() != 1) {
            return false;
        }
        return stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).map(handler -> {
            FluidStack simulate = handler.drain(new FluidStack(fluid, 1000), IFluidHandler.FluidAction.SIMULATE);
            return !simulate.isEmpty() && simulate.getFluid() == fluid && simulate.getAmount() == 1000;
        }).orElse(false);
    }

    public static ItemStack drain(Fluid fluid, ItemStack stack) {
        return stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).map(handler -> {
            handler.drain(new FluidStack(fluid, 1000), IFluidHandler.FluidAction.EXECUTE);
            return handler.getContainer();
        }).orElse(stack);
    }

    public static boolean isValidFluidContainerToFill(ItemStack stack, Fluid fluid) {
        if (stack.m_41619_()) {
            return false;
        }
        ItemStack container = stack;
        if (stack.m_41613_() > 1) {
            container = new ItemStack((ItemLike)stack.m_41720_());
        }
        return container.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).map(handler -> {
            int amount = handler.fill(new FluidStack(fluid, 1000), IFluidHandler.FluidAction.SIMULATE);
            return amount == 1000;
        }).orElse(false);
    }

    public static ItemStack fill(Fluid fluid, ItemStack stack) {
        return stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).map(handler -> {
            handler.fill(new FluidStack(fluid, 1000), IFluidHandler.FluidAction.EXECUTE);
            return handler.getContainer();
        }).orElse(stack);
    }
}

