/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.utils;

import com.Polarice3.Goety.ItemConfig;
import com.Polarice3.Goety.common.entities.neutral.AbstractNecromancer;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.items.brew.ThrowableBrewItem;
import com.Polarice3.Goety.common.items.curios.IllusionRobeItem;
import com.Polarice3.Goety.common.items.curios.MagicRobeItem;
import com.Polarice3.Goety.common.items.curios.RingItem;
import com.Polarice3.Goety.common.items.curios.WarlockRobeItem;
import com.Polarice3.Goety.common.items.curios.WildRobeItem;
import com.Polarice3.Goety.common.items.curios.WindyRobeItem;
import com.Polarice3.Goety.common.items.curios.WitchHatItem;
import com.Polarice3.Goety.common.items.curios.WitchRobeItem;
import com.Polarice3.Goety.common.items.handler.BrewBagItemHandler;
import com.Polarice3.Goety.compat.curios.CuriosLoaded;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public class CuriosFinder {
    public static ItemStack findCurio(LivingEntity livingEntity, Predicate<ItemStack> filter) {
        Optional slotResult;
        ItemStack foundStack = ItemStack.f_41583_;
        if (livingEntity != null && CuriosLoaded.CURIOS.isLoaded() && (slotResult = CuriosApi.getCuriosInventory((LivingEntity)livingEntity).map(inv -> inv.findFirstCurio(filter)).orElse(Optional.empty())).isPresent()) {
            foundStack = ((SlotResult)slotResult.get()).stack();
        }
        return foundStack;
    }

    public static boolean hasCurio(LivingEntity livingEntity, Predicate<ItemStack> filter) {
        return !CuriosFinder.findCurio(livingEntity, filter).m_41619_();
    }

    public static boolean hasCurio(LivingEntity livingEntity, Item item) {
        return !CuriosFinder.findCurio(livingEntity, item).m_41619_();
    }

    public static ItemStack findCurio(LivingEntity livingEntity, Item item) {
        Optional slotResult;
        ItemStack foundStack = ItemStack.f_41583_;
        if (livingEntity != null && CuriosLoaded.CURIOS.isLoaded() && (slotResult = CuriosApi.getCuriosInventory((LivingEntity)livingEntity).map(inv -> inv.findFirstCurio(item)).orElse(Optional.empty())).isPresent()) {
            foundStack = ((SlotResult)slotResult.get()).stack();
        }
        return foundStack;
    }

    public static boolean hasDarkRobe(LivingEntity livingEntity) {
        return CuriosFinder.hasCurio(livingEntity, (ItemStack itemStack) -> itemStack.m_41720_() instanceof MagicRobeItem);
    }

    public static boolean hasWildRobe(LivingEntity livingEntity) {
        return CuriosFinder.hasCurio(livingEntity, (ItemStack itemStack) -> itemStack.m_41720_() instanceof WildRobeItem);
    }

    public static boolean hasIllusionRobe(LivingEntity livingEntity) {
        return CuriosFinder.hasCurio(livingEntity, (ItemStack itemStack) -> itemStack.m_41720_() instanceof IllusionRobeItem);
    }

    public static boolean hasWitchHat(LivingEntity livingEntity) {
        return CuriosFinder.hasCurio(livingEntity, (ItemStack itemStack) -> itemStack.m_41720_() instanceof WitchHatItem);
    }

    public static boolean hasWitchRobe(LivingEntity livingEntity) {
        return CuriosFinder.hasCurio(livingEntity, (ItemStack itemStack) -> itemStack.m_41720_() instanceof WitchRobeItem);
    }

    public static boolean hasWarlockRobe(LivingEntity livingEntity) {
        return CuriosFinder.hasCurio(livingEntity, (ItemStack itemStack) -> itemStack.m_41720_() instanceof WarlockRobeItem);
    }

    public static boolean hasWitchSet(LivingEntity livingEntity) {
        return CuriosFinder.hasWitchHat(livingEntity) && CuriosFinder.hasWitchRobe(livingEntity);
    }

    public static boolean neutralNecroCrown(LivingEntity livingEntity) {
        return CuriosFinder.hasCurio(livingEntity, (Item)ModItems.NECRO_CROWN.get()) && (Boolean)ItemConfig.NecroSetUndeadNeutral.get() != false;
    }

    public static boolean neutralNecroCape(LivingEntity livingEntity) {
        return CuriosFinder.hasCurio(livingEntity, (Item)ModItems.NECRO_CAPE.get()) && (Boolean)ItemConfig.NecroSetUndeadNeutral.get() != false;
    }

    public static boolean hasNecroSet(LivingEntity livingEntity) {
        return CuriosFinder.hasCurio(livingEntity, (Item)ModItems.NECRO_CROWN.get()) && CuriosFinder.hasCurio(livingEntity, (Item)ModItems.NECRO_CAPE.get());
    }

    public static boolean neutralNecroSet(LivingEntity livingEntity) {
        return CuriosFinder.hasNecroSet(livingEntity) && (Boolean)ItemConfig.NecroSetUndeadNeutral.get() != false;
    }

    public static boolean neutralNamelessCrown(LivingEntity livingEntity) {
        return CuriosFinder.hasCurio(livingEntity, (Item)ModItems.NAMELESS_CROWN.get()) && (Boolean)ItemConfig.NamelessSetUndeadNeutral.get() != false;
    }

    public static boolean neutralNamelessCape(LivingEntity livingEntity) {
        return CuriosFinder.hasCurio(livingEntity, (Item)ModItems.NAMELESS_CAPE.get()) && (Boolean)ItemConfig.NamelessSetUndeadNeutral.get() != false;
    }

    public static boolean hasNamelessSet(LivingEntity livingEntity) {
        return CuriosFinder.hasCurio(livingEntity, (Item)ModItems.NAMELESS_CROWN.get()) && CuriosFinder.hasCurio(livingEntity, (Item)ModItems.NAMELESS_CAPE.get());
    }

    public static boolean neutralNamelessSet(LivingEntity livingEntity) {
        return CuriosFinder.hasNamelessSet(livingEntity) && (Boolean)ItemConfig.NamelessSetUndeadNeutral.get() != false;
    }

    public static boolean hasUndeadCrown(LivingEntity livingEntity) {
        return CuriosFinder.hasCurio(livingEntity, (Item)ModItems.NECRO_CROWN.get()) || CuriosFinder.hasCurio(livingEntity, (Item)ModItems.NAMELESS_CROWN.get()) || livingEntity instanceof AbstractNecromancer;
    }

    public static boolean hasUndeadCape(LivingEntity livingEntity) {
        return CuriosFinder.hasCurio(livingEntity, (Item)ModItems.NECRO_CAPE.get()) || CuriosFinder.hasCurio(livingEntity, (Item)ModItems.NAMELESS_CAPE.get()) || livingEntity instanceof AbstractNecromancer;
    }

    public static boolean hasUndeadSet(LivingEntity livingEntity) {
        return CuriosFinder.hasUndeadCrown(livingEntity) && CuriosFinder.hasUndeadCape(livingEntity);
    }

    public static boolean hasWindyRobes(LivingEntity livingEntity) {
        return CuriosFinder.hasCurio(livingEntity, (ItemStack item) -> item.m_41720_() instanceof WindyRobeItem);
    }

    private static boolean isRing(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof RingItem;
    }

    public static ItemStack findRing(Player playerEntity) {
        ItemStack foundStack;
        block2: {
            block1: {
                foundStack = ItemStack.f_41583_;
                if (!CuriosLoaded.CURIOS.isLoaded()) break block1;
                Optional slotResult = CuriosApi.getCuriosInventory((LivingEntity)playerEntity).map(inv -> inv.findFirstCurio(CuriosFinder::isRing)).orElse(Optional.empty());
                if (!slotResult.isPresent()) break block2;
                foundStack = ((SlotResult)slotResult.get()).stack();
                break block2;
            }
            for (int i = 0; i < playerEntity.m_150109_().m_6643_(); ++i) {
                ItemStack itemStack = playerEntity.m_150109_().m_8020_(i);
                if (itemStack.m_41619_() || !CuriosFinder.isRing(itemStack)) continue;
                foundStack = itemStack;
                break;
            }
        }
        return foundStack;
    }

    public static ItemStack findBrewInBag(Player player) {
        ItemStack foundStack = ItemStack.f_41583_;
        if (!CuriosFinder.findBrewBag(player).m_41619_()) {
            BrewBagItemHandler brewBagItemHandler = BrewBagItemHandler.get(CuriosFinder.findBrewBag(player));
            for (int i = 1; i < brewBagItemHandler.getSlots(); ++i) {
                ItemStack itemStack = brewBagItemHandler.getStackInSlot(i);
                if (!(itemStack.m_41720_() instanceof ThrowableBrewItem)) continue;
                foundStack = itemStack;
            }
        }
        return foundStack;
    }

    public static int getBrewBagTotal(Player player) {
        int num = 0;
        if (!CuriosFinder.findBrewBag(player).m_41619_()) {
            BrewBagItemHandler brewBagItemHandler = BrewBagItemHandler.get(CuriosFinder.findBrewBag(player));
            for (int i = 1; i < brewBagItemHandler.getSlots(); ++i) {
                ItemStack itemStack = brewBagItemHandler.getStackInSlot(i);
                if (!(itemStack.m_41720_() instanceof ThrowableBrewItem)) continue;
                ++num;
            }
        }
        return num;
    }

    public static boolean hasEmptyBrewBagSpace(Player player) {
        return CuriosFinder.getBrewBagTotal(player) < 10;
    }

    public static boolean hasBrewInBag(Player player) {
        return !CuriosFinder.findBrewInBag(player).m_41619_();
    }

    private static boolean isBrewBag(ItemStack itemStack) {
        return itemStack.m_41720_() == ModItems.BREW_BAG.get();
    }

    public static ItemStack findBrewBag(Player playerEntity) {
        Optional slotResult;
        ItemStack foundStack = ItemStack.f_41583_;
        if (CuriosLoaded.CURIOS.isLoaded() && (slotResult = CuriosApi.getCuriosInventory((LivingEntity)playerEntity).map(inv -> inv.findFirstCurio(CuriosFinder::isBrewBag)).orElse(Optional.empty())).isPresent()) {
            foundStack = ((SlotResult)slotResult.get()).stack();
        }
        for (int i = 0; i < playerEntity.m_150109_().m_6643_(); ++i) {
            ItemStack itemStack = playerEntity.m_150109_().m_8020_(i);
            if (itemStack.m_41619_() || !CuriosFinder.isBrewBag(itemStack)) continue;
            foundStack = itemStack;
            break;
        }
        return foundStack;
    }
}

