/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.utils;

import com.Polarice3.Goety.common.effects.brew.BrewEffect;
import com.Polarice3.Goety.common.effects.brew.BrewEffectInstance;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import org.jetbrains.annotations.NotNull;

public class BrewUtils {
    public static String AOE_ID = "AreaOfEffect";
    public static String LINGERING_ID = "Lingering";
    public static String QUAFF_ID = "Quaff";
    public static String VELOCITY_ID = "Velocity";
    private static final Component NO_EFFECT = Component.m_237115_((String)"effect.none").m_130940_(ChatFormatting.GRAY);

    public static int getAreaOfEffect(ItemStack p_43576_) {
        CompoundTag compoundtag = p_43576_.m_41783_();
        if (compoundtag != null && compoundtag.m_128441_(AOE_ID)) {
            return compoundtag.m_128451_(AOE_ID);
        }
        return 0;
    }

    public static void setAreaOfEffect(ItemStack pStack, int aoe) {
        pStack.m_41784_().m_128405_(AOE_ID, aoe);
    }

    public static float getLingering(ItemStack p_43576_) {
        CompoundTag compoundtag = p_43576_.m_41783_();
        if (compoundtag != null && compoundtag.m_128441_(LINGERING_ID)) {
            return compoundtag.m_128457_(LINGERING_ID);
        }
        return 0.0f;
    }

    public static void setLingering(ItemStack pStack, float lingering) {
        pStack.m_41784_().m_128350_(LINGERING_ID, lingering);
    }

    public static int getQuaff(ItemStack itemStack) {
        CompoundTag compoundtag = itemStack.m_41783_();
        if (compoundtag != null && compoundtag.m_128441_(QUAFF_ID)) {
            return compoundtag.m_128451_(QUAFF_ID);
        }
        return 0;
    }

    public static int getQuaffLevel(ItemStack itemStack) {
        int quaff = BrewUtils.getQuaff(itemStack);
        if (quaff == 4) {
            return 1;
        }
        if (quaff == 8) {
            return 2;
        }
        if (quaff >= 16) {
            return 3;
        }
        return 0;
    }

    public static void setQuaff(ItemStack pStack, int quaff) {
        pStack.m_41784_().m_128405_(QUAFF_ID, quaff);
    }

    public static float getVelocity(@NotNull ItemStack itemStack) {
        CompoundTag compoundtag = itemStack.m_41783_();
        if (compoundtag != null && compoundtag.m_128441_(VELOCITY_ID)) {
            return compoundtag.m_128457_(VELOCITY_ID);
        }
        return 0.0f;
    }

    public static int getVelocityLevel(ItemStack itemStack) {
        float velocity = BrewUtils.getVelocity(itemStack);
        if (velocity == 0.1f) {
            return 1;
        }
        if (velocity == 0.3f) {
            return 2;
        }
        if (velocity >= 0.5f) {
            return 3;
        }
        return 0;
    }

    public static void setVelocity(ItemStack pStack, float velocity) {
        pStack.m_41784_().m_128350_(VELOCITY_ID, velocity);
    }

    public static List<BrewEffectInstance> getBrewEffects(ItemStack p_43548_) {
        return BrewUtils.getAllEffects(p_43548_.m_41783_());
    }

    public static List<BrewEffectInstance> getAllEffects(@Nullable CompoundTag p_43567_) {
        ArrayList list = Lists.newArrayList();
        BrewUtils.getCustomEffects(p_43567_, list);
        return list;
    }

    public static List<BrewEffectInstance> getCustomEffects(ItemStack p_43572_) {
        return BrewUtils.getCustomEffects(p_43572_.m_41783_());
    }

    public static List<BrewEffectInstance> getCustomEffects(@Nullable CompoundTag p_43574_) {
        ArrayList list = Lists.newArrayList();
        BrewUtils.getCustomEffects(p_43574_, list);
        return list;
    }

    public static void getCustomEffects(@Nullable CompoundTag p_43569_, List<BrewEffectInstance> p_43570_) {
        if (p_43569_ != null && p_43569_.m_128425_("CustomBrewEffects", 9)) {
            ListTag listtag = p_43569_.m_128437_("CustomBrewEffects", 10);
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag compoundtag = listtag.m_128728_(i);
                BrewEffectInstance instance = BrewEffectInstance.load(compoundtag);
                if (instance == null) continue;
                p_43570_.add(instance);
            }
        }
    }

    public static ItemStack setCustomEffects(ItemStack stack, Collection<MobEffectInstance> instances1, Collection<BrewEffectInstance> instances) {
        ListTag listtag;
        CompoundTag compoundtag;
        if (!instances1.isEmpty()) {
            compoundtag = stack.m_41784_();
            listtag = compoundtag.m_128437_("CustomPotionEffects", 9);
            for (MobEffectInstance mobeffectinstance : instances1) {
                listtag.add((Object)mobeffectinstance.m_19555_(new CompoundTag()));
            }
            compoundtag.m_128365_("CustomPotionEffects", (Tag)listtag);
        }
        if (!instances.isEmpty()) {
            compoundtag = stack.m_41784_();
            listtag = compoundtag.m_128437_("CustomBrewEffects", 9);
            for (BrewEffectInstance instance : instances) {
                listtag.add((Object)instance.save(new CompoundTag()));
            }
            compoundtag.m_128365_("CustomBrewEffects", (Tag)listtag);
        }
        return stack;
    }

    public static void addBrewTooltip(ItemStack itemStack, List<Component> p_43557_, float p_43558_) {
        List list = PotionUtils.m_43547_((ItemStack)itemStack);
        ArrayList list1 = Lists.newArrayList();
        List<BrewEffectInstance> list2 = BrewUtils.getBrewEffects(itemStack);
        if (list.isEmpty() && list2.isEmpty()) {
            p_43557_.add(NO_EFFECT);
        } else {
            BrewEffect mobeffect;
            MutableComponent mutablecomponent;
            if (!list2.isEmpty()) {
                for (BrewEffectInstance brewEffectInstance : list2) {
                    mutablecomponent = brewEffectInstance.getName();
                    mobeffect = brewEffectInstance.getEffect();
                    if (brewEffectInstance.getAmplifier() > 0) {
                        mutablecomponent = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{mutablecomponent, Component.m_237115_((String)("potion.potency." + brewEffectInstance.getAmplifier()))});
                    }
                    p_43557_.add((Component)mutablecomponent.m_130940_(mobeffect.getCategory().m_19497_()));
                }
            }
            if (!list.isEmpty()) {
                for (MobEffectInstance mobeffectinstance : list) {
                    mutablecomponent = Component.m_237115_((String)mobeffectinstance.m_19576_());
                    mobeffect = mobeffectinstance.m_19544_();
                    Map map = mobeffect.m_19485_();
                    if (!map.isEmpty()) {
                        for (Map.Entry entry : map.entrySet()) {
                            AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                            AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.m_22214_(), mobeffect.m_7048_(mobeffectinstance.m_19564_(), attributemodifier), attributemodifier.m_22217_());
                            list1.add(new Pair((Object)((Attribute)entry.getKey()), (Object)attributemodifier1));
                        }
                    }
                    if (mobeffectinstance.m_19564_() > 0) {
                        mutablecomponent = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{mutablecomponent, Component.m_237115_((String)("potion.potency." + mobeffectinstance.m_19564_()))});
                    }
                    if (mobeffectinstance.m_19557_() > 20) {
                        mutablecomponent = Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{mutablecomponent, MobEffectUtil.m_267641_((MobEffectInstance)mobeffectinstance, (float)p_43558_)});
                    }
                    p_43557_.add((Component)mutablecomponent.m_130940_(mobeffect.m_19483_().m_19497_()));
                }
            }
            if (BrewUtils.getAreaOfEffect(itemStack) > 0) {
                p_43557_.add((Component)Component.m_237110_((String)"tooltip.goety.brew.area", (Object[])new Object[]{Component.m_237115_((String)("potion.potency." + BrewUtils.getAreaOfEffect(itemStack)))}).m_130940_(ChatFormatting.BLUE));
            }
            if (BrewUtils.getLingering(itemStack) > 0.0f) {
                p_43557_.add((Component)Component.m_237110_((String)"tooltip.goety.brew.lingering", (Object[])new Object[]{Component.m_237115_((String)("potion.potency." + (int)BrewUtils.getLingering(itemStack)))}).m_130940_(ChatFormatting.BLUE));
            }
            if (BrewUtils.getQuaffLevel(itemStack) > 0) {
                p_43557_.add((Component)Component.m_237110_((String)"tooltip.goety.brew.quaff", (Object[])new Object[]{Component.m_237115_((String)("potion.potency." + BrewUtils.getQuaffLevel(itemStack)))}).m_130940_(ChatFormatting.BLUE));
            }
            if (BrewUtils.getVelocityLevel(itemStack) > 0) {
                p_43557_.add((Component)Component.m_237110_((String)"tooltip.goety.brew.velocity", (Object[])new Object[]{Component.m_237115_((String)("potion.potency." + BrewUtils.getVelocityLevel(itemStack)))}).m_130940_(ChatFormatting.BLUE));
            }
            if (!list1.isEmpty()) {
                p_43557_.add(CommonComponents.f_237098_);
                p_43557_.add((Component)Component.m_237115_((String)"potion.whenDrank").m_130940_(ChatFormatting.DARK_PURPLE));
                for (Pair pair : list1) {
                    AttributeModifier attributemodifier2 = (AttributeModifier)pair.getSecond();
                    double d0 = attributemodifier2.m_22218_();
                    double d1 = attributemodifier2.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier2.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? attributemodifier2.m_22218_() : attributemodifier2.m_22218_() * 100.0;
                    if (d0 > 0.0) {
                        p_43557_.add((Component)Component.m_237110_((String)("attribute.modifier.plus." + attributemodifier2.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1), Component.m_237115_((String)((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.BLUE));
                        continue;
                    }
                    if (!(d0 < 0.0)) continue;
                    p_43557_.add((Component)Component.m_237110_((String)("attribute.modifier.take." + attributemodifier2.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1 *= -1.0), Component.m_237115_((String)((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.RED));
                }
            }
        }
    }

    public static boolean hasBrewEffect(ItemStack itemStack) {
        return !BrewUtils.getBrewEffects(itemStack).isEmpty();
    }

    public static boolean hasEffect(ItemStack itemStack) {
        return !PotionUtils.m_43571_((ItemStack)itemStack).isEmpty() || !BrewUtils.getBrewEffects(itemStack).isEmpty();
    }

    public static int getColor(ItemStack p_43576_) {
        CompoundTag compoundtag = p_43576_.m_41783_();
        if (compoundtag != null && compoundtag.m_128425_("CustomPotionColor", 99)) {
            return compoundtag.m_128451_("CustomPotionColor");
        }
        return BrewUtils.getColor(PotionUtils.m_43547_((ItemStack)p_43576_), BrewUtils.getBrewEffects(p_43576_));
    }

    public static int getColor(Collection<MobEffectInstance> instance1, Collection<BrewEffectInstance> instance2) {
        int l;
        int k;
        if (instance1.isEmpty() && instance2.isEmpty()) {
            return 3694022;
        }
        float f = 0.0f;
        float f1 = 0.0f;
        float f2 = 0.0f;
        int j = 0;
        for (MobEffectInstance mobeffectinstance : instance1) {
            if (!mobeffectinstance.m_19572_()) continue;
            k = mobeffectinstance.m_19544_().m_19484_();
            l = mobeffectinstance.m_19564_() + 1;
            f += (float)(l * (k >> 16 & 0xFF)) / 255.0f;
            f1 += (float)(l * (k >> 8 & 0xFF)) / 255.0f;
            f2 += (float)(l * (k >> 0 & 0xFF)) / 255.0f;
            j += l;
        }
        for (BrewEffectInstance brewEffectInstance : instance2) {
            k = brewEffectInstance.getEffect().getColor();
            l = brewEffectInstance.getAmplifier() + 1;
            f += (float)(l * (k >> 16 & 0xFF)) / 255.0f;
            f1 += (float)(l * (k >> 8 & 0xFF)) / 255.0f;
            f2 += (float)(l * (k >> 0 & 0xFF)) / 255.0f;
            j += l;
        }
        if (j == 0) {
            return 0;
        }
        f = f / (float)j * 255.0f;
        f1 = f1 / (float)j * 255.0f;
        f2 = f2 / (float)j * 255.0f;
        return (int)f << 16 | (int)f1 << 8 | (int)f2;
    }
}

