/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.utils;

import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockFinder {
    private static final Predicate<Block> isAir = block -> block == Blocks.f_50016_ || block == Blocks.f_50627_;

    public static boolean isScytheBreak(BlockState blockState) {
        return (blockState.m_204336_(BlockTags.f_13073_) || blockState.m_60734_() instanceof BushBlock) && !(blockState.m_60734_() instanceof StemBlock);
    }

    public static double moveDownToGround(Entity entity) {
        BlockHitResult hitResult;
        HitResult rayTrace = BlockFinder.rayTrace(entity);
        if (rayTrace.m_6662_() == HitResult.Type.BLOCK && (hitResult = (BlockHitResult)rayTrace).m_82434_() == Direction.UP) {
            BlockState hitBlock = entity.f_19853_.m_8055_(hitResult.m_82425_());
            if (hitBlock.m_60734_() instanceof SlabBlock && hitBlock.m_61143_((Property)BlockStateProperties.f_61397_) == SlabType.BOTTOM) {
                return (float)hitResult.m_82425_().m_123342_() + 1.0625f - 0.5f;
            }
            return (float)hitResult.m_82425_().m_123342_() + 1.0625f;
        }
        return entity.m_20186_();
    }

    private static HitResult rayTrace(Entity entity) {
        Vec3 startPos = new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        Vec3 endPos = new Vec3(entity.m_20185_(), 0.0, entity.m_20189_());
        return entity.f_19853_.m_45547_(new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity));
    }

    public static double distanceFromGround(Entity entity) {
        BlockHitResult hitResult;
        HitResult rayTrace = BlockFinder.rayTrace(entity);
        if (rayTrace.m_6662_() == HitResult.Type.BLOCK && (hitResult = (BlockHitResult)rayTrace).m_82434_() == Direction.UP) {
            BlockState hitBlock = entity.f_19853_.m_8055_(hitResult.m_82425_());
            if (hitBlock.m_60734_() instanceof SlabBlock && hitBlock.m_61143_((Property)BlockStateProperties.f_61397_) == SlabType.BOTTOM) {
                return entity.m_20186_() - (double)((float)hitResult.m_82425_().m_123342_() - 0.5f);
            }
            return entity.m_20186_() - (double)hitResult.m_82425_().m_123342_();
        }
        return 0.0;
    }

    public static double moveBlockDownToGround(Level level, BlockPos blockPos) {
        BlockHitResult hitResult;
        HitResult rayTrace = BlockFinder.blockRayTrace(level, blockPos);
        if (rayTrace.m_6662_() == HitResult.Type.BLOCK && (hitResult = (BlockHitResult)rayTrace).m_82434_() == Direction.UP) {
            BlockState hitBlock = level.m_8055_(hitResult.m_82425_());
            if (hitBlock.m_60734_() instanceof SlabBlock && hitBlock.m_61143_((Property)BlockStateProperties.f_61397_) == SlabType.BOTTOM) {
                return (float)hitResult.m_82425_().m_123342_() + 1.0625f - 0.5f;
            }
            return (float)hitResult.m_82425_().m_123342_() + 1.0625f;
        }
        return blockPos.m_123342_();
    }

    private static HitResult blockRayTrace(Level level, BlockPos blockPos) {
        Vec3 startPos = new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
        Vec3 endPos = new Vec3((double)blockPos.m_123341_(), 0.0, (double)blockPos.m_123343_());
        return level.m_45547_(new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
    }

    public static boolean hasChunksAt(LivingEntity livingEntity) {
        Level world = livingEntity.f_19853_;
        BlockPos.MutableBlockPos blockpos$mutable = livingEntity.m_20183_().m_122032_().m_122184_(0, 0, 0);
        return world.m_46812_(blockpos$mutable.m_123341_() - 10, blockpos$mutable.m_123342_() - 10, blockpos$mutable.m_123343_() - 10, blockpos$mutable.m_123341_() + 10, blockpos$mutable.m_123342_() + 10, blockpos$mutable.m_123343_() + 10);
    }

    public static boolean isEmptyBlock(BlockGetter pLevel, BlockPos pPos, BlockState pBlockState, FluidState pFluidState, EntityType<?> pEntityType, boolean pWater) {
        if (pWater) {
            if (pBlockState.m_60838_(pLevel, pPos)) {
                return false;
            }
            return !pEntityType.m_20630_(pBlockState) || pFluidState.m_76178_();
        }
        if (pBlockState.m_60838_(pLevel, pPos)) {
            return false;
        }
        if (!pFluidState.m_76178_()) {
            return false;
        }
        return !pEntityType.m_20630_(pBlockState);
    }

    public static double spawnWaterY(LivingEntity livingEntity, BlockPos blockPos) {
        BlockPos blockpos = blockPos;
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1 = blockpos.m_7495_();
            FluidState fluidState = livingEntity.f_19853_.m_6425_(blockpos);
            BlockState blockstate = livingEntity.f_19853_.m_8055_(blockpos1);
            if (fluidState.m_205070_(FluidTags.f_13131_)) {
                BlockState blockstate12;
                VoxelShape voxelshape2;
                if (!livingEntity.f_19853_.m_46801_(blockpos) && !(voxelshape2 = (blockstate12 = livingEntity.f_19853_.m_8055_(blockpos)).m_60812_((BlockGetter)livingEntity.f_19853_, blockpos)).m_83281_()) {
                    d0 = voxelshape2.m_83297_(Direction.Axis.Y);
                }
                flag = true;
                break;
            }
            if (!blockstate.m_60783_((BlockGetter)livingEntity.f_19853_, blockpos1, Direction.UP)) continue;
            if (!livingEntity.f_19853_.m_46859_(blockpos) && !(voxelshape = (blockstate1 = livingEntity.f_19853_.m_8055_(blockpos)).m_60812_((BlockGetter)livingEntity.f_19853_, blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)livingEntity.m_20186_()) - 1);
        if (flag) {
            if (!((double)blockpos.m_123342_() + d0 > livingEntity.m_20186_() + 5.0)) {
                return (double)blockpos.m_123342_() + d0;
            }
            return livingEntity.m_20186_();
        }
        return livingEntity.m_20186_();
    }

    public static BlockPos SummonPosition(LivingEntity livingEntity, BlockPos blockPos) {
        return BlockFinder.SummonPosition(livingEntity, blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
    }

    public static BlockPos SummonPosition(LivingEntity livingEntity, double x, double y, double z) {
        double d3 = y;
        boolean flag = false;
        Level level = livingEntity.f_19853_;
        BlockPos blockpos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        if (level.m_46805_(blockpos)) {
            boolean flag1 = false;
            while (!flag1 && blockpos.m_123342_() > level.m_141937_()) {
                BlockPos blockpos1 = blockpos.m_7495_();
                BlockState blockstate = level.m_8055_(blockpos1);
                if (blockstate.m_280555_()) {
                    flag1 = true;
                    continue;
                }
                d3 -= 1.0;
                blockpos = blockpos1;
            }
            if (flag1 && level.m_45786_((Entity)livingEntity) && !level.m_46855_(livingEntity.m_20191_())) {
                flag = true;
            }
        }
        if (!flag) {
            return blockpos;
        }
        return BlockPos.m_274561_((double)x, (double)d3, (double)z);
    }

    public static BlockPos SummonRadius(LivingEntity livingEntity, Level world) {
        BlockPos.MutableBlockPos blockpos$mutable = livingEntity.m_20183_().m_122032_().m_122184_(0, 0, 0);
        blockpos$mutable.m_142451_(blockpos$mutable.m_123341_() + world.f_46441_.m_188503_(5) - world.f_46441_.m_188503_(5));
        blockpos$mutable.m_142448_(livingEntity.m_146904_());
        blockpos$mutable.m_142443_(blockpos$mutable.m_123343_() + world.f_46441_.m_188503_(5) - world.f_46441_.m_188503_(5));
        if (world.m_45786_((Entity)livingEntity) && !world.m_46855_(livingEntity.m_20191_())) {
            return BlockFinder.SummonPosition(livingEntity, (BlockPos)blockpos$mutable);
        }
        return livingEntity.m_20183_();
    }

    public static BlockPos SummonFurtherRadius(LivingEntity livingEntity, Level world) {
        BlockPos.MutableBlockPos blockpos$mutable = livingEntity.m_20183_().m_122032_();
        blockpos$mutable.m_142451_(blockpos$mutable.m_123341_() + world.f_46441_.m_188503_(9) - world.f_46441_.m_188503_(9));
        blockpos$mutable.m_142448_((int)BlockFinder.moveDownToGround((Entity)livingEntity));
        blockpos$mutable.m_142443_(blockpos$mutable.m_123343_() + world.f_46441_.m_188503_(9) - world.f_46441_.m_188503_(9));
        if (world.m_45786_((Entity)livingEntity) && !world.m_46855_(livingEntity.m_20191_())) {
            return BlockFinder.SummonPosition(livingEntity, (BlockPos)blockpos$mutable);
        }
        return livingEntity.m_20183_();
    }

    public static BlockPos SummonWaterRadius(LivingEntity livingEntity, Level world) {
        BlockPos.MutableBlockPos blockpos$mutable = livingEntity.m_20183_().m_122032_().m_122184_(0, 0, 0);
        blockpos$mutable.m_142451_(blockpos$mutable.m_123341_() + world.f_46441_.m_188503_(5) - world.f_46441_.m_188503_(5));
        blockpos$mutable.m_142448_((int)BlockFinder.spawnWaterY(livingEntity, livingEntity.m_20183_()));
        blockpos$mutable.m_142443_(blockpos$mutable.m_123343_() + world.f_46441_.m_188503_(5) - world.f_46441_.m_188503_(5));
        if (BlockFinder.hasChunksAt(livingEntity) && BlockFinder.isEmptyBlock((BlockGetter)world, (BlockPos)blockpos$mutable, world.m_8055_((BlockPos)blockpos$mutable), world.m_6425_((BlockPos)blockpos$mutable), (EntityType)ModEntityType.ZOMBIE_SERVANT.get(), true)) {
            return blockpos$mutable;
        }
        return livingEntity.m_20183_().m_122032_().m_122184_(0, (int)BlockFinder.spawnWaterY(livingEntity, livingEntity.m_20183_()), 0);
    }

    public static boolean findStructure(ServerLevel serverLevel, LivingEntity livingEntity, ResourceKey<Structure> resourceKey) {
        return BlockFinder.findStructure(serverLevel, livingEntity.m_20183_(), resourceKey);
    }

    public static boolean findStructure(ServerLevel serverLevel, BlockPos blockPos, ResourceKey<Structure> resourceKey) {
        StructureStart structureStart;
        Structure structure = (Structure)serverLevel.m_215010_().m_220521_().m_175515_(Registries.f_256944_).m_6246_(resourceKey);
        if (structure != null && !(structureStart = serverLevel.m_215010_().m_220524_(blockPos, structure)).m_73602_().isEmpty()) {
            return structureStart.m_73601_().m_71051_((Vec3i)blockPos);
        }
        return false;
    }

    public static boolean findStructure(ServerLevel serverLevel, BlockPos blockPos, TagKey<Structure> structureTagKey) {
        return serverLevel.m_215010_().m_220491_(blockPos, structureTagKey).m_73603_();
    }

    public static boolean isEmptyBox(Level level, BlockPos p_46860_) {
        return level.m_46859_(p_46860_) && level.m_46859_(p_46860_.m_7495_()) && level.m_46859_(p_46860_.m_7494_()) && level.m_46859_(p_46860_.m_122024_()) && level.m_46859_(p_46860_.m_122029_()) && level.m_46859_(p_46860_.m_122024_().m_122012_()) && level.m_46859_(p_46860_.m_122024_().m_122019_()) && level.m_46859_(p_46860_.m_122029_().m_122012_()) && level.m_46859_(p_46860_.m_122029_().m_122019_()) && level.m_46859_(p_46860_.m_122012_()) && level.m_46859_(p_46860_.m_122019_()) && level.m_46859_(p_46860_.m_7494_().m_122024_()) && level.m_46859_(p_46860_.m_7494_().m_122029_()) && level.m_46859_(p_46860_.m_7494_().m_122024_().m_122012_()) && level.m_46859_(p_46860_.m_7494_().m_122024_().m_122019_()) && level.m_46859_(p_46860_.m_7494_().m_122029_().m_122012_()) && level.m_46859_(p_46860_.m_7494_().m_122029_().m_122019_()) && level.m_46859_(p_46860_.m_7494_().m_122012_()) && level.m_46859_(p_46860_.m_7494_().m_122019_()) && level.m_46859_(p_46860_.m_7495_().m_122024_()) && level.m_46859_(p_46860_.m_7495_().m_122029_()) && level.m_46859_(p_46860_.m_7495_().m_122024_().m_122012_()) && level.m_46859_(p_46860_.m_7495_().m_122024_().m_122019_()) && level.m_46859_(p_46860_.m_7495_().m_122029_().m_122012_()) && level.m_46859_(p_46860_.m_7495_().m_122029_().m_122019_()) && level.m_46859_(p_46860_.m_7495_().m_122012_()) && level.m_46859_(p_46860_.m_7495_().m_122019_());
    }

    public static boolean emptySpaceBetween(Level level, BlockPos blockPos, int distance, boolean up) {
        BlockPos.MutableBlockPos blockpos$mutable = blockPos.m_122032_();
        boolean flag = false;
        if (up) {
            while (blockpos$mutable.m_123342_() < blockPos.m_123342_() + distance && (level.m_8055_((BlockPos)blockpos$mutable).m_60795_() || BlockFinder.canBeReplaced(level, (BlockPos)blockpos$mutable))) {
                blockpos$mutable.m_122173_(Direction.UP);
                flag = true;
            }
        } else {
            while (blockpos$mutable.m_123342_() > blockPos.m_123342_() - distance && level.m_8055_((BlockPos)blockpos$mutable).m_60795_() || BlockFinder.canBeReplaced(level, (BlockPos)blockpos$mutable)) {
                blockpos$mutable.m_122173_(Direction.DOWN);
                flag = true;
            }
        }
        if (!level.m_8055_((BlockPos)blockpos$mutable).m_60795_()) {
            flag = false;
        }
        return flag;
    }

    public static boolean emptySquareSpace(Level level, BlockPos blockPos, int distance, boolean up) {
        return BlockFinder.emptySpaceBetween(level, blockPos, distance, up) && BlockFinder.emptySpaceBetween(level, blockPos.m_122012_(), distance, up) && BlockFinder.emptySpaceBetween(level, blockPos.m_122019_(), distance, up) && BlockFinder.emptySpaceBetween(level, blockPos.m_122024_(), distance, up) && BlockFinder.emptySpaceBetween(level, blockPos.m_122029_(), distance, up) && BlockFinder.emptySpaceBetween(level, blockPos.m_122024_().m_122012_(), distance, up) && BlockFinder.emptySpaceBetween(level, blockPos.m_122024_().m_122019_(), distance, up) && BlockFinder.emptySpaceBetween(level, blockPos.m_122029_().m_122012_(), distance, up) && BlockFinder.emptySpaceBetween(level, blockPos.m_122029_().m_122019_(), distance, up);
    }

    public static boolean getVerticalBlock(Level level, BlockPos blockPos, BlockState blockState, int distance, boolean up) {
        BlockPos.MutableBlockPos blockpos$mutable = blockPos.m_122032_();
        boolean flag = false;
        if (up) {
            while (blockpos$mutable.m_123342_() < blockPos.m_123342_() + distance && level.m_8055_((BlockPos)blockpos$mutable).m_60795_()) {
                blockpos$mutable.m_122173_(Direction.UP);
                flag = true;
            }
        } else {
            while (blockpos$mutable.m_123342_() > blockPos.m_123342_() - distance && level.m_8055_((BlockPos)blockpos$mutable).m_60795_()) {
                blockpos$mutable.m_122173_(Direction.DOWN);
                flag = true;
            }
        }
        if (level.m_8055_((BlockPos)blockpos$mutable) != blockState) {
            flag = false;
        }
        return flag;
    }

    public static Iterable<BlockPos> multiBlockBreak(LivingEntity livingEntity, BlockPos blockPos, int x, int y, int z) {
        BlockHitResult blockHitResult = MobUtil.rayTrace((Entity)livingEntity, 10.0, false);
        Direction direction = blockHitResult.m_82434_();
        boolean hasX = direction.m_122429_() == 0;
        boolean hasY = direction.m_122430_() == 0;
        boolean hasZ = direction.m_122431_() == 0;
        Vec3i start = new Vec3i(hasX ? -x : 0, hasY ? -y : 0, hasZ ? -z : 0);
        Vec3i end = new Vec3i(hasX ? x : 0, hasY ? y * 2 - 1 : 0, hasZ ? z : 0);
        return BlockPos.m_121940_((BlockPos)blockPos.m_121955_(start), (BlockPos)blockPos.m_121955_(end));
    }

    public static void spawnRedstoneParticles(Level pLevel, BlockPos pPos) {
        double d0 = 0.5625;
        RandomSource random = pLevel.f_46441_;
        for (Direction direction : Direction.values()) {
            BlockPos blockpos = pPos.m_121945_(direction);
            if (pLevel.m_8055_(blockpos).m_60804_((BlockGetter)pLevel, blockpos)) continue;
            Direction.Axis direction$axis = direction.m_122434_();
            double d1 = direction$axis == Direction.Axis.X ? 0.5 + d0 * (double)direction.m_122429_() : (double)random.m_188501_();
            double d2 = direction$axis == Direction.Axis.Y ? 0.5 + d0 * (double)direction.m_122430_() : (double)random.m_188501_();
            double d3 = direction$axis == Direction.Axis.Z ? 0.5 + d0 * (double)direction.m_122431_() : (double)random.m_188501_();
            pLevel.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, (double)pPos.m_123341_() + d1, (double)pPos.m_123342_() + d2, (double)pPos.m_123343_() + d3, 0.0, 0.0, 0.0);
        }
    }

    public static BlockState findBlock(Level pLevel, BlockPos initial, int range) {
        return BlockFinder.findBlock(pLevel, initial, range, range, range);
    }

    public static BlockState findBlock(Level pLevel, BlockPos initial, int xRange, int yRange, int zRange) {
        BlockState blockState = pLevel.m_8055_(initial);
        for (int i = -xRange; i <= xRange; ++i) {
            for (int j = -yRange; j <= yRange; ++j) {
                for (int k = -zRange; k <= zRange; ++k) {
                    BlockPos blockpos1 = initial.m_7918_(i, j, k);
                    blockState = pLevel.m_8055_(blockpos1);
                }
            }
        }
        return blockState;
    }

    @Nullable
    public static BlockEntity findBlockEntity(BlockEntityType<?> blockEntityType, Level pLevel, BlockPos initial, int range) {
        return BlockFinder.findBlockEntity(blockEntityType, pLevel, initial, range, range, range);
    }

    @Nullable
    public static BlockEntity findBlockEntity(BlockEntityType<?> blockEntityType, Level pLevel, BlockPos initial, int xRange, int yRange, int zRange) {
        for (int i = -xRange; i <= xRange; ++i) {
            for (int j = -yRange; j <= yRange; ++j) {
                for (int k = -zRange; k <= zRange; ++k) {
                    BlockEntity blockEntity;
                    BlockPos blockPos = initial.m_7918_(i, j, k);
                    if (pLevel.m_7702_(blockPos) == null || (blockEntity = pLevel.m_7702_(blockPos)) == null || blockEntity.m_58903_() != blockEntityType) continue;
                    return blockEntity;
                }
            }
        }
        return null;
    }

    public static void copyValues(Level level, BlockPos blockPos, BlockState newBlock, BlockState oldBlock) {
        if (oldBlock.m_60734_() instanceof SlabBlock && newBlock.m_60734_() instanceof SlabBlock) {
            BlockFinder.copySlab(level, blockPos, newBlock, oldBlock);
        } else if (oldBlock.m_60734_() instanceof StairBlock && newBlock.m_60734_() instanceof StairBlock) {
            BlockFinder.copyStairs(level, blockPos, newBlock, oldBlock);
        } else if (oldBlock.m_60734_() instanceof WallBlock && newBlock.m_60734_() instanceof WallBlock) {
            BlockFinder.copyWalls(level, blockPos, newBlock, oldBlock);
        }
    }

    public static void copySlab(Level level, BlockPos blockPos, BlockState newBlock, BlockState oldBlock) {
        if (oldBlock.m_60734_() instanceof SlabBlock && newBlock.m_60734_() instanceof SlabBlock) {
            level.m_46597_(blockPos, (BlockState)newBlock.m_61124_((Property)SlabBlock.f_56353_, (Comparable)((SlabType)oldBlock.m_61143_((Property)SlabBlock.f_56353_))));
        }
    }

    public static void copyStairs(Level level, BlockPos blockPos, BlockState newBlock, BlockState oldBlock) {
        if (oldBlock.m_60734_() instanceof StairBlock && newBlock.m_60734_() instanceof StairBlock) {
            level.m_46597_(blockPos, (BlockState)((BlockState)((BlockState)newBlock.m_61124_((Property)StairBlock.f_56841_, (Comparable)((Direction)oldBlock.m_61143_((Property)StairBlock.f_56841_)))).m_61124_((Property)StairBlock.f_56842_, (Comparable)((Half)oldBlock.m_61143_((Property)StairBlock.f_56842_)))).m_61124_((Property)StairBlock.f_56843_, (Comparable)((StairsShape)oldBlock.m_61143_((Property)StairBlock.f_56843_))));
        }
    }

    public static void copyWalls(Level level, BlockPos blockPos, BlockState newBlock, BlockState oldBlock) {
        if (oldBlock.m_60734_() instanceof WallBlock && newBlock.m_60734_() instanceof WallBlock) {
            level.m_46597_(blockPos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)newBlock.m_61124_((Property)WallBlock.f_57949_, (Comparable)((Boolean)oldBlock.m_61143_((Property)WallBlock.f_57949_)))).m_61124_((Property)WallBlock.f_57953_, (Comparable)((WallSide)oldBlock.m_61143_((Property)WallBlock.f_57953_)))).m_61124_((Property)WallBlock.f_57950_, (Comparable)((WallSide)oldBlock.m_61143_((Property)WallBlock.f_57950_)))).m_61124_((Property)WallBlock.f_57951_, (Comparable)((WallSide)oldBlock.m_61143_((Property)WallBlock.f_57951_)))).m_61124_((Property)WallBlock.f_57952_, (Comparable)((WallSide)oldBlock.m_61143_((Property)WallBlock.f_57952_))));
        }
    }

    public static boolean canBeReplaced(Level pLevel, BlockPos pReplaceablePos) {
        return BlockFinder.canBeReplaced(pLevel, pReplaceablePos, pReplaceablePos);
    }

    public static boolean canBeReplaced(Level pLevel, BlockPos pReplaceablePos, BlockPos pReplacedBlockPos) {
        return pLevel.m_8055_(pReplaceablePos).m_60629_((BlockPlaceContext)new DirectionalPlaceContext(pLevel, pReplacedBlockPos, Direction.DOWN, ItemStack.f_41583_, Direction.UP));
    }

    public static Optional<BlockPos> findLightningRod(ServerLevel serverLevel, BlockPos blockPos) {
        return BlockFinder.findLightningRod(serverLevel, blockPos, 128);
    }

    public static Optional<BlockPos> findLightningRod(ServerLevel serverLevel, BlockPos blockPos, int range) {
        Optional optional = serverLevel.m_8904_().m_148658_(poiTypeHolder -> poiTypeHolder.m_203565_(PoiTypes.f_218066_), blockPos1 -> blockPos1.m_123342_() == serverLevel.m_6924_(Heightmap.Types.WORLD_SURFACE, blockPos1.m_123341_(), blockPos1.m_123343_()) - 1, blockPos, range, PoiManager.Occupancy.ANY);
        return optional.map(blockPos1 -> blockPos1.m_6630_(1));
    }

    public static void preventCreativeDropFromBottomPart(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        BlockPos blockpos;
        BlockState blockstate;
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)pState.m_61143_((Property)BlockStateProperties.f_61401_);
        if (doubleblockhalf == DoubleBlockHalf.UPPER && (blockstate = pLevel.m_8055_(blockpos = pPos.m_7495_())).m_60713_(pState.m_60734_()) && blockstate.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.LOWER) {
            BlockState blockstate1 = blockstate.m_60819_().m_192917_((Fluid)Fluids.f_76193_) ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_();
            pLevel.m_7731_(blockpos, blockstate1, 35);
            pLevel.m_5898_(pPlayer, 2001, blockpos, Block.m_49956_((BlockState)blockstate));
        }
    }
}

