/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.compat.patchouli;

import com.Polarice3.Goety.common.crafting.RitualRecipe;
import com.Polarice3.Goety.common.items.ModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class RitualRecipeProcessor
implements IComponentProcessor {
    protected RitualRecipe recipe;
    protected ItemStack pedestal;

    public void setup(Level level, IVariableProvider iVariableProvider) {
        String recipeId = iVariableProvider.get("recipe").asString();
        this.recipe = Minecraft.m_91087_().f_91073_.m_7465_().m_44043_(new ResourceLocation(recipeId)).orElse(null);
        this.pedestal = new ItemStack((ItemLike)ModItems.PEDESTAL_DUMMY.get());
    }

    public IVariable process(Level level, String key) {
        if (this.recipe == null) {
            return IVariable.empty();
        }
        if (key.startsWith("activation_item")) {
            return IVariable.from((Object)this.recipe.getActivationItem().m_43908_());
        }
        if (key.startsWith("craftType") && this.recipe.getCraftType() != null) {
            return IVariable.wrap((String)I18n.m_118938_((String)("jei.goety.craftType." + I18n.m_118938_((String)this.recipe.getCraftType(), (Object[])new Object[0])), (Object[])new Object[0]));
        }
        if (key.startsWith("ingredient")) {
            int index = Integer.parseInt(key.substring("ingredient".length())) - 1;
            if (index >= this.recipe.m_7527_().size()) {
                return IVariable.empty();
            }
            Ingredient ingredient = (Ingredient)this.recipe.m_7527_().get(index);
            return IVariable.from((Object)ingredient.m_43908_());
        }
        if (key.startsWith("pedestal")) {
            int index = Integer.parseInt(key.substring("pedestal".length())) - 1;
            if (index >= this.recipe.m_7527_().size()) {
                return IVariable.empty();
            }
            return IVariable.from((Object)this.pedestal);
        }
        if (key.equals("output")) {
            if (this.recipe.m_8043_(level.m_9598_()).m_41720_() != ModItems.JEI_DUMMY_NONE.get()) {
                return IVariable.from((Object)this.recipe.m_8043_(level.m_9598_()));
            }
            return IVariable.from((Object)new ItemStack((ItemLike)ModItems.JEI_DUMMY_NONE.get()));
        }
        if (key.equals("entity_to_summon") && this.recipe.getEntityToSummon() != null) {
            return IVariable.wrap((String)I18n.m_118938_((String)"jei.goety.summon", (Object[])new Object[]{I18n.m_118938_((String)this.recipe.getEntityToSummon().m_20675_(), (Object[])new Object[0])}));
        }
        if (key.equals("entity_to_sacrifice") && this.recipe.requiresSacrifice()) {
            return IVariable.wrap((String)I18n.m_118938_((String)"jei.goety.sacrifice", (Object[])new Object[]{I18n.m_118938_((String)this.recipe.getEntityToSacrificeDisplayName(), (Object[])new Object[0])}));
        }
        if (key.equals("entity_to_convert") && this.recipe.getEntityToConvert() != null) {
            return IVariable.wrap((String)I18n.m_118938_((String)"jei.goety.convert", (Object[])new Object[]{I18n.m_118938_((String)this.recipe.getEntityToConvertDisplayName(), (Object[])new Object[0])}));
        }
        if (key.equals("entity_to_convert_into") && this.recipe.getEntityToConvertInto() != null) {
            return IVariable.wrap((String)I18n.m_118938_((String)"jei.goety.convertInto", (Object[])new Object[]{I18n.m_118938_((String)this.recipe.getEntityToConvertInto().m_20675_(), (Object[])new Object[0])}));
        }
        if (key.startsWith("soulCost")) {
            return IVariable.wrap((String)I18n.m_118938_((String)"jei.goety.soulCost", (Object[])new Object[]{this.recipe.getSoulCost()}));
        }
        if (key.startsWith("duration")) {
            return IVariable.wrap((String)I18n.m_118938_((String)"jei.goety.duration", (Object[])new Object[]{this.recipe.getDuration()}));
        }
        return IVariable.empty();
    }
}

