/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.compat.jei;

import com.Polarice3.Goety.common.blocks.ModBlocks;
import com.Polarice3.Goety.common.crafting.RitualRecipe;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.compat.jei.JeiRecipeTypes;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ModRitualCategory
implements IRecipeCategory<RitualRecipe> {
    private final IDrawable background;
    private final IDrawable arrow;
    private final Component localizedName;
    private final ItemStack darkAltar = new ItemStack((ItemLike)ModBlocks.DARK_ALTAR.get());
    private final ItemStack pedestals = new ItemStack((ItemLike)ModItems.PEDESTAL_DUMMY.get());
    private final int iconWidth = 16;
    private final int ritualCenterX;
    private final int ritualCenterY;
    private int recipeOutputOffsetX = 50;

    public ModRitualCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(168, 120);
        this.ritualCenterX = this.background.getWidth() / 2 - this.iconWidth / 2 - 30;
        this.ritualCenterY = this.background.getHeight() / 2 - this.iconWidth / 2 + 10;
        this.localizedName = Component.m_237115_((String)"goety.jei.ritual");
        this.darkAltar.m_41784_().m_128379_("RenderFull", true);
        this.pedestals.m_41784_().m_128379_("RenderFull", true);
        this.arrow = guiHelper.createDrawable(new ResourceLocation("goety", "textures/gui/jei/arrow.png"), 0, 0, 64, 46);
    }

    public RecipeType<RitualRecipe> getRecipeType() {
        return JeiRecipeTypes.RITUAL;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return null;
    }

    public void setRecipe(IRecipeLayoutBuilder recipeLayout, RitualRecipe recipe, IFocusGroup ingredients) {
        boolean index = false;
        this.recipeOutputOffsetX = 75;
        recipeLayout.addSlot(RecipeIngredientRole.INPUT, this.ritualCenterX, this.ritualCenterY - 15).addIngredients(recipe.getActivationItem());
        recipeLayout.addSlot(RecipeIngredientRole.CATALYST, this.ritualCenterX, this.ritualCenterY).addItemStack(this.darkAltar);
        int sacrificialCircleRadius = 30;
        int pedestalsPaddingVertical = 20;
        int pedestalsPaddingHorizontal = 15;
        List pedestalsPosition = Stream.of(new Vec3i(this.ritualCenterX, this.ritualCenterY - sacrificialCircleRadius, 0), new Vec3i(this.ritualCenterX + sacrificialCircleRadius, this.ritualCenterY, 0), new Vec3i(this.ritualCenterX, this.ritualCenterY + sacrificialCircleRadius, 0), new Vec3i(this.ritualCenterX - sacrificialCircleRadius, this.ritualCenterY, 0), new Vec3i(this.ritualCenterX + pedestalsPaddingHorizontal, this.ritualCenterY - sacrificialCircleRadius, 0), new Vec3i(this.ritualCenterX + sacrificialCircleRadius, this.ritualCenterY - pedestalsPaddingVertical, 0), new Vec3i(this.ritualCenterX - pedestalsPaddingHorizontal, this.ritualCenterY + sacrificialCircleRadius, 0), new Vec3i(this.ritualCenterX - sacrificialCircleRadius, this.ritualCenterY + pedestalsPaddingVertical, 0), new Vec3i(this.ritualCenterX - pedestalsPaddingHorizontal, this.ritualCenterY - sacrificialCircleRadius, 0), new Vec3i(this.ritualCenterX + sacrificialCircleRadius, this.ritualCenterY + pedestalsPaddingVertical, 0), new Vec3i(this.ritualCenterX + pedestalsPaddingHorizontal, this.ritualCenterY + sacrificialCircleRadius, 0), new Vec3i(this.ritualCenterX - sacrificialCircleRadius, this.ritualCenterY - pedestalsPaddingVertical, 0)).collect(Collectors.toList());
        for (int i = 0; i < recipe.m_7527_().size(); ++i) {
            Vec3i pos = (Vec3i)pedestalsPosition.get(i);
            recipeLayout.addSlot(RecipeIngredientRole.INPUT, pos.m_123341_(), pos.m_123342_() - 5).addIngredients((Ingredient)recipe.m_7527_().get(i));
            recipeLayout.addSlot(RecipeIngredientRole.RENDER_ONLY, pos.m_123341_(), pos.m_123342_()).addItemStack(this.pedestals);
        }
        recipeLayout.addSlot(RecipeIngredientRole.OUTPUT, this.ritualCenterX + this.recipeOutputOffsetX, this.ritualCenterY - 15).addItemStack(recipe.m_8043_(null));
        recipeLayout.addSlot(RecipeIngredientRole.CATALYST, this.ritualCenterX + this.recipeOutputOffsetX, this.ritualCenterY).addItemStack(this.darkAltar);
        if (recipe.getCraftType().contains("animation")) {
            recipeLayout.addSlot(RecipeIngredientRole.RENDER_ONLY, 0, 0).addItemStack(new ItemStack((ItemLike)Items.f_42521_));
        } else if (recipe.getCraftType().contains("necroturgy") || recipe.getCraftType().contains("lich")) {
            recipeLayout.addSlot(RecipeIngredientRole.RENDER_ONLY, 0, 0).addItemStack(new ItemStack((ItemLike)Items.f_42681_));
        } else if (recipe.getCraftType().contains("forge")) {
            recipeLayout.addSlot(RecipeIngredientRole.RENDER_ONLY, 0, 0).addItemStack(new ItemStack((ItemLike)Items.f_42146_));
        } else if (recipe.getCraftType().contains("magic")) {
            recipeLayout.addSlot(RecipeIngredientRole.RENDER_ONLY, 0, 0).addItemStack(new ItemStack((ItemLike)Items.f_42100_));
        } else if (recipe.getCraftType().contains("adept_nether")) {
            recipeLayout.addSlot(RecipeIngredientRole.RENDER_ONLY, 0, 0).addItemStack(new ItemStack((ItemLike)Items.f_42755_));
        } else if (recipe.getCraftType().contains("expert_nether")) {
            recipeLayout.addSlot(RecipeIngredientRole.RENDER_ONLY, 0, 0).addItemStack(new ItemStack((ItemLike)Items.f_42095_));
        } else if (recipe.getCraftType().contains("sabbath")) {
            recipeLayout.addSlot(RecipeIngredientRole.RENDER_ONLY, 0, 0).addItemStack(new ItemStack((ItemLike)Items.f_42754_));
        } else if (recipe.getCraftType().contains("sky")) {
            recipeLayout.addSlot(RecipeIngredientRole.RENDER_ONLY, 0, 0).addItemStack(new ItemStack((ItemLike)Items.f_42402_));
        } else if (recipe.getCraftType().contains("storm")) {
            recipeLayout.addSlot(RecipeIngredientRole.RENDER_ONLY, 0, 0).addItemStack(new ItemStack((ItemLike)Items.f_151041_));
        } else if (recipe.getCraftType().contains("geoturgy")) {
            recipeLayout.addSlot(RecipeIngredientRole.RENDER_ONLY, 0, 0).addItemStack(new ItemStack((ItemLike)Items.f_151034_));
        } else {
            recipeLayout.addSlot(RecipeIngredientRole.RENDER_ONLY, 0, 0).addItemStack(new ItemStack((ItemLike)Items.f_41999_));
        }
    }

    public void draw(RitualRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics stack, double mouseX, double mouseY) {
        RenderSystem.enableBlend();
        this.arrow.draw(stack, this.ritualCenterX + this.recipeOutputOffsetX - 20, this.ritualCenterY);
        RenderSystem.disableBlend();
        int infotextY = 0;
        int initial = 14;
        if (recipe.requiresSacrifice()) {
            this.drawStringCentered(stack, Minecraft.m_91087_().f_91062_, I18n.m_118938_((String)"jei.goety.sacrifice", (Object[])new Object[]{I18n.m_118938_((String)recipe.getEntityToSacrificeDisplayName(), (Object[])new Object[0])}), 84, infotextY += initial);
        }
        int sequence = 8;
        if (recipe.getEntityToSummon() != null) {
            this.drawStringCentered(stack, Minecraft.m_91087_().f_91062_, I18n.m_118938_((String)"jei.goety.summon", (Object[])new Object[]{I18n.m_118938_((String)recipe.getEntityToSummon().m_20675_(), (Object[])new Object[0])}), 84, infotextY += infotextY == 0 ? initial : sequence);
        }
        if (recipe.getEntityToConvert() != null) {
            this.drawStringCentered(stack, Minecraft.m_91087_().f_91062_, I18n.m_118938_((String)"jei.goety.convert", (Object[])new Object[]{I18n.m_118938_((String)recipe.getEntityToConvertDisplayName(), (Object[])new Object[0])}), 84, infotextY += infotextY == 0 ? initial : sequence);
        }
        if (recipe.getEntityToConvertInto() != null) {
            this.drawStringCentered(stack, Minecraft.m_91087_().f_91062_, I18n.m_118938_((String)"jei.goety.convertInto", (Object[])new Object[]{I18n.m_118938_((String)recipe.getEntityToConvertInto().m_20675_(), (Object[])new Object[0])}), 84, infotextY += infotextY == 0 ? initial : sequence);
        }
        if (recipe.getCraftType() != null) {
            this.drawStringCentered(stack, Minecraft.m_91087_().f_91062_, I18n.m_118938_((String)("jei.goety.craftType." + I18n.m_118938_((String)recipe.getCraftType(), (Object[])new Object[0])), (Object[])new Object[0]), 84, 5);
        }
    }

    protected int getStringCenteredMaxX(Font fontRenderer, String text, int x, int y) {
        int width = fontRenderer.m_92895_(text);
        int actualX = (int)((float)x - (float)width / 2.0f);
        return actualX + width;
    }

    protected void drawStringCentered(GuiGraphics matrixStack, Font fontRenderer, String text, int x, int y) {
        matrixStack.m_280056_(fontRenderer, text, (int)((float)x - (float)fontRenderer.m_92895_(text) / 2.0f), y, 0, false);
    }
}

