/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.compat.curios;

import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.compat.ICompatable;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotTypeMessage;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class CuriosIntegration
implements ICompatable {
    private static final Map<Item, String> TYPES = ImmutableMap.builder().put((Object)((Item)ModItems.RING_OF_WANT.get()), (Object)"ring").put((Object)((Item)ModItems.RING_OF_FORCE.get()), (Object)"ring").put((Object)((Item)ModItems.RING_OF_THE_DRAGON.get()), (Object)"ring").put((Object)((Item)ModItems.DARK_HAT.get()), (Object)"head").put((Object)((Item)ModItems.GRAND_TURBAN.get()), (Object)"head").put((Object)((Item)ModItems.WITCH_HAT.get()), (Object)"head").put((Object)((Item)ModItems.WITCH_HAT_HEDGE.get()), (Object)"head").put((Object)((Item)ModItems.CRONE_HAT.get()), (Object)"head").put((Object)((Item)ModItems.NECRO_CROWN.get()), (Object)"head").put((Object)((Item)ModItems.NAMELESS_CROWN.get()), (Object)"head").put((Object)((Item)ModItems.TARGETING_MONOCLE.get()), (Object)"head").put((Object)((Item)ModItems.AMETHYST_NECKLACE.get()), (Object)"necklace").put((Object)((Item)ModItems.PENDANT_OF_HUNGER.get()), (Object)"necklace").put((Object)((Item)ModItems.STAR_AMULET.get()), (Object)"necklace").put((Object)((Item)ModItems.SEA_AMULET.get()), (Object)"necklace").put((Object)((Item)ModItems.FELINE_AMULET.get()), (Object)"necklace").put((Object)((Item)ModItems.DARK_ROBE.get()), (Object)"body").put((Object)((Item)ModItems.GRAND_ROBE.get()), (Object)"body").put((Object)((Item)ModItems.FROST_ROBE.get()), (Object)"body").put((Object)((Item)ModItems.FROST_ROBE_CRYO.get()), (Object)"body").put((Object)((Item)ModItems.WIND_ROBE.get()), (Object)"body").put((Object)((Item)ModItems.STORM_ROBE.get()), (Object)"body").put((Object)((Item)ModItems.WILD_ROBE.get()), (Object)"body").put((Object)((Item)ModItems.ILLUSION_ROBE.get()), (Object)"body").put((Object)((Item)ModItems.ILLUSION_ROBE_MIRROR.get()), (Object)"body").put((Object)((Item)ModItems.WITCH_ROBE.get()), (Object)"body").put((Object)((Item)ModItems.WITCH_ROBE_HEDGE.get()), (Object)"body").put((Object)((Item)ModItems.WARLOCK_ROBE.get()), (Object)"body").put((Object)((Item)ModItems.WARLOCK_ROBE_DARK.get()), (Object)"body").put((Object)((Item)ModItems.NECRO_CAPE.get()), (Object)"back").put((Object)((Item)ModItems.NAMELESS_CAPE.get()), (Object)"back").put((Object)((Item)ModItems.GRAVE_GLOVE.get()), (Object)"hands").put((Object)((Item)ModItems.TOTEM_OF_ROOTS.get()), (Object)"charm").put((Object)((Item)ModItems.TOTEM_OF_SOULS.get()), (Object)"charm").put((Object)((Item)ModItems.FOCUS_BAG.get()), (Object)"belt").put((Object)((Item)ModItems.BREW_BAG.get()), (Object)"belt").put((Object)((Item)ModItems.WARLOCK_SASH.get()), (Object)"belt").put((Object)((Item)ModItems.WAYFARERS_BELT.get()), (Object)"belt").put((Object)((Item)ModItems.SPITEFUL_BELT.get()), (Object)"belt").build();

    @Override
    public void setup(FMLCommonSetupEvent event) {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::sendImc);
        MinecraftForge.EVENT_BUS.addGenericListener(ItemStack.class, this::onCapabilitiesAttach);
    }

    private void sendImc(InterModEnqueueEvent event) {
        TYPES.values().stream().distinct().forEach(t -> InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder(t).build()));
    }

    private void onCapabilitiesAttach(AttachCapabilitiesEvent<ItemStack> event) {
        final ItemStack stack = (ItemStack)event.getObject();
        if (TYPES.containsKey(stack.m_41720_())) {
            event.addCapability(new ResourceLocation("goety", "curios"), new ICapabilityProvider(){
                private final LazyOptional<ICurio> curio = LazyOptional.of(() -> new ICurio(){

                    public void curioTick(SlotContext slotContext) {
                        stack.m_41720_().m_6883_(stack, slotContext.entity().f_19853_, (Entity)slotContext.entity(), -1, false);
                    }

                    public ItemStack getStack() {
                        return stack;
                    }

                    public boolean canEquipFromUse(SlotContext slotContext) {
                        return true;
                    }

                    public boolean canSync(SlotContext slotContext) {
                        return true;
                    }
                });

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                    if (cap != CuriosCapability.ITEM) {
                        return LazyOptional.empty();
                    }
                    return this.curio.cast();
                }
            });
        }
    }
}

