/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.ritual;

import com.Polarice3.Goety.common.blocks.entities.RitualBlockEntity;
import com.Polarice3.Goety.init.ModTags;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.AmethystBlock;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.BlastFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.EnchantmentTableBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.FurnaceBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.LavaCauldronBlock;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.RailBlock;
import net.minecraft.world.level.block.SculkBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SmithingTableBlock;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.Tags;

public class RitualRequirements {
    public static final int RANGE = 8;

    public static boolean noConvertEntity(TagKey<EntityType<?>> entityType, BlockPos pPos, Level pLevel) {
        return RitualRequirements.getConvertEntity(entityType, pPos, pLevel) == null;
    }

    public static Mob getConvertEntity(TagKey<EntityType<?>> entityType, BlockPos pPos, Level pLevel) {
        for (Mob mob : pLevel.m_45976_(Mob.class, new AABB(pPos).m_82400_(8.0))) {
            if (!mob.m_6095_().m_204039_(entityType)) continue;
            return mob;
        }
        return null;
    }

    public static boolean getProperStructure(String craftType, RitualBlockEntity pTileEntity, BlockPos pPos, Level pLevel) {
        return switch (craftType) {
            case "animation", "forge", "magic", "sabbath" -> RitualRequirements.getStructures(craftType, pPos, pLevel);
            case "geoturgy" -> {
                if (RitualRequirements.getStructures(craftType, pPos, pLevel) && !pLevel.m_45527_(pPos) && pPos.m_123342_() <= 32) {
                    yield true;
                }
                yield false;
            }
            case "necroturgy", "lich" -> {
                if (RitualRequirements.getStructures(craftType, pPos, pLevel) && pLevel.m_46462_()) {
                    yield true;
                }
                yield false;
            }
            case "adept_nether", "expert_nether" -> {
                if (RitualRequirements.getStructures(craftType, pPos, pLevel) && pLevel.m_6042_().f_63857_()) {
                    yield true;
                }
                yield false;
            }
            case "frost" -> {
                if (RitualRequirements.getStructures(craftType, pPos, pLevel) && ((Biome)pLevel.m_204166_(pPos).get()).m_47519_((LevelReader)pLevel, pPos)) {
                    yield true;
                }
                yield false;
            }
            case "sky" -> RitualRequirements.skyRitual(pTileEntity, pPos);
            case "storm" -> {
                if (RitualRequirements.getStructures(craftType, pPos, pLevel) && RitualRequirements.skyRitual(pTileEntity, pPos) && pLevel.m_46470_() && pLevel.m_45527_(pPos)) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public static boolean skyRitual(RitualBlockEntity pTileEntity, BlockPos pPos) {
        return pPos.m_123342_() >= 128 || RitualRequirements.getStructures("sky", pPos, pTileEntity.m_58904_());
    }

    public static boolean getStructures(String craftType, BlockPos pPos, Level pLevel) {
        ArrayList first = Lists.newArrayList();
        ArrayList second = Lists.newArrayList();
        ArrayList third = Lists.newArrayList();
        int firstSize = 0;
        int secondSize = 0;
        int thirdSize = 0;
        for (int i = -8; i <= 8; ++i) {
            for (int j = -8; j <= 8; ++j) {
                block29: for (int k = -8; k <= 8; ++k) {
                    BlockPos blockpos1 = pPos.m_7918_(i, j, k);
                    BlockState blockstate = pLevel.m_8055_(blockpos1);
                    switch (craftType) {
                        case "animation": {
                            firstSize = 15;
                            secondSize = 15;
                            thirdSize = 1;
                            if (blockstate.m_60734_() instanceof LadderBlock || blockstate.m_60734_().m_7705_().contains("ladder")) {
                                first.add(blockpos1);
                            }
                            if (blockstate.m_60734_() instanceof RailBlock) {
                                second.add(blockpos1);
                            }
                            if (!(blockstate.m_60734_() instanceof CarvedPumpkinBlock)) continue block29;
                            third.add(blockpos1);
                            continue block29;
                        }
                        case "necroturgy": 
                        case "lich": {
                            FlowerPotBlock flowerPotBlock;
                            Block block;
                            firstSize = 16;
                            secondSize = 16;
                            thirdSize = 8;
                            if (blockstate.m_60734_() instanceof SculkBlock) {
                                first.add(blockpos1);
                            }
                            if (blockstate.m_60734_() instanceof SlabBlock) {
                                second.add(blockpos1);
                            }
                            if (!((block = blockstate.m_60734_()) instanceof FlowerPotBlock) || (flowerPotBlock = (FlowerPotBlock)block).m_53560_() == Blocks.f_50016_) continue block29;
                            third.add(blockpos1);
                            continue block29;
                        }
                        case "forge": {
                            firstSize = 1;
                            secondSize = 2;
                            thirdSize = 1;
                            if (blockstate.m_60734_() instanceof LavaCauldronBlock) {
                                first.add(blockpos1);
                            }
                            if (blockstate.m_60734_() instanceof FurnaceBlock || blockstate.m_60734_() instanceof BlastFurnaceBlock) {
                                second.add(blockpos1);
                            }
                            if (!(blockstate.m_60734_() instanceof AnvilBlock)) continue block29;
                            third.add(blockpos1);
                            continue block29;
                        }
                        case "geoturgy": {
                            firstSize = 8;
                            secondSize = 1;
                            thirdSize = 16;
                            if (blockstate.m_60734_() instanceof AmethystBlock) {
                                first.add(blockpos1);
                            }
                            if (blockstate.m_60734_() instanceof SmithingTableBlock) {
                                second.add(blockpos1);
                            }
                            if (!blockstate.m_60734_().m_7705_().contains("deepslate") || !blockstate.m_60804_((BlockGetter)pLevel, blockpos1)) continue block29;
                            third.add(blockpos1);
                            continue block29;
                        }
                        case "magic": {
                            LecternBlockEntity lecternTileEntity;
                            Block block;
                            firstSize = 16;
                            secondSize = 1;
                            thirdSize = 1;
                            if (blockstate.m_204336_(Tags.Blocks.BOOKSHELVES) || blockstate.m_60734_().m_7705_().contains("bookshelf")) {
                                first.add(blockpos1);
                            }
                            if (blockstate.m_60734_() instanceof LecternBlock && blockstate.m_155947_() && (block = pLevel.m_7702_(blockpos1)) instanceof LecternBlockEntity && !(lecternTileEntity = (LecternBlockEntity)block).m_59566_().m_41619_()) {
                                second.add(blockpos1);
                            }
                            if (!(blockstate.m_60734_() instanceof EnchantmentTableBlock)) continue block29;
                            third.add(blockpos1);
                            continue block29;
                        }
                        case "sabbath": {
                            firstSize = 8;
                            secondSize = 16;
                            thirdSize = 4;
                            if (blockstate.m_60734_() == Blocks.f_50723_) {
                                first.add(blockpos1);
                            }
                            if (blockstate.m_60734_() == Blocks.f_50080_) {
                                second.add(blockpos1);
                            }
                            if (blockstate.m_60734_() != Blocks.f_50084_) continue block29;
                            third.add(blockpos1);
                            continue block29;
                        }
                        case "adept_nether": {
                            firstSize = 8;
                            secondSize = 16;
                            thirdSize = 4;
                            if (blockstate.m_60734_().m_7705_().contains("basalt")) {
                                first.add(blockpos1);
                            }
                            if (blockstate.m_60734_().m_7705_().contains("blackstone")) {
                                second.add(blockpos1);
                            }
                            if (blockstate.m_60734_() != Blocks.f_50141_) continue block29;
                            third.add(blockpos1);
                            continue block29;
                        }
                        case "expert_nether": {
                            firstSize = 4;
                            secondSize = 32;
                            thirdSize = 8;
                            if (blockstate.m_60734_() == Blocks.f_50312_ || blockstate.m_60734_() == Blocks.f_50313_) {
                                first.add(blockpos1);
                            }
                            if (blockstate.m_60734_() == Blocks.f_50197_ || blockstate.m_60734_() == Blocks.f_50452_) {
                                second.add(blockpos1);
                            }
                            if (blockstate.m_60734_() != Blocks.f_50200_) continue block29;
                            third.add(blockpos1);
                            continue block29;
                        }
                        case "frost": {
                            firstSize = 16;
                            secondSize = 8;
                            thirdSize = 4;
                            if (blockstate.m_204336_(BlockTags.f_13091_)) {
                                first.add(blockpos1);
                            }
                            if (blockstate.m_204336_(BlockTags.f_144279_)) {
                                second.add(blockpos1);
                            }
                            if (!blockstate.m_204336_(BlockTags.f_13047_)) continue block29;
                            third.add(blockpos1);
                            continue block29;
                        }
                        case "sky": {
                            firstSize = 8;
                            secondSize = 16;
                            thirdSize = 4;
                            if (blockstate.m_204336_(ModTags.Blocks.MARBLE_BLOCKS) && !first.contains(blockpos1)) {
                                first.add(blockpos1);
                            }
                            if (blockstate.m_204336_(ModTags.Blocks.JADE_BLOCKS) && !second.contains(blockpos1)) {
                                second.add(blockpos1);
                            }
                            if (!blockstate.m_204336_(ModTags.Blocks.INDENTED_GOLD_BLOCKS) || third.contains(blockpos1)) continue block29;
                            third.add(blockpos1);
                            continue block29;
                        }
                        case "storm": {
                            firstSize = 12;
                            secondSize = 4;
                            thirdSize = 20;
                            if (blockstate.m_60734_().m_7705_().contains("copper")) {
                                first.add(blockpos1);
                            }
                            if (blockstate.m_60734_() instanceof LightningRodBlock) {
                                second.add(blockpos1);
                            }
                            if (!(blockstate.m_60734_() instanceof ChainBlock)) continue block29;
                            third.add(blockpos1);
                        }
                    }
                }
            }
        }
        return first.size() >= firstSize && second.size() >= secondSize && third.size() >= thirdSize;
    }
}

