/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.network.server;

import com.Polarice3.Goety.Goety;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class SLightningPacket {
    private final double x;
    private final double y;
    private final double z;
    private final double x2;
    private final double y2;
    private final double z2;
    private final int lifespan;

    public SLightningPacket(double x, double y, double z, double x2, double y2, double z2, int lifespan) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.x2 = x2;
        this.y2 = y2;
        this.z2 = z2;
        this.lifespan = lifespan;
    }

    public SLightningPacket(Vec3 start, Vec3 end, int lifespan) {
        this.x = start.f_82479_;
        this.y = start.f_82480_;
        this.z = start.f_82481_;
        this.x2 = end.f_82479_;
        this.y2 = end.f_82480_;
        this.z2 = end.f_82481_;
        this.lifespan = lifespan;
    }

    public static void encode(SLightningPacket packet, FriendlyByteBuf buffer) {
        buffer.writeFloat((float)packet.x);
        buffer.writeFloat((float)packet.y);
        buffer.writeFloat((float)packet.z);
        buffer.writeFloat((float)packet.x2);
        buffer.writeFloat((float)packet.y2);
        buffer.writeFloat((float)packet.z2);
        buffer.writeInt(packet.lifespan);
    }

    public static SLightningPacket decode(FriendlyByteBuf buffer) {
        return new SLightningPacket(buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readInt());
    }

    public static void consume(SLightningPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Vec3 start = new Vec3(packet.x, packet.y, packet.z);
            Vec3 end = new Vec3(packet.x2, packet.y2, packet.z2);
            Goety.PROXY.shock(start, end, packet.lifespan);
        });
        ctx.get().setPacketHandled(true);
    }
}

