/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.network.client;

import com.Polarice3.Goety.common.entities.projectiles.CorruptedBeam;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class CBeamPacket {
    private final int beamEntityID;
    private final double positionX;
    private final double positionY;
    private final double positionZ;
    private final float xRot;
    private final float yRot;
    private final float xRotO;
    private final float yRotO;

    public CBeamPacket(CorruptedBeam corruptedBeam) {
        this.beamEntityID = corruptedBeam.m_19879_();
        this.positionX = corruptedBeam.m_20182_().f_82479_;
        this.positionY = corruptedBeam.m_20182_().f_82480_;
        this.positionZ = corruptedBeam.m_20182_().f_82481_;
        this.xRot = corruptedBeam.m_146909_();
        this.yRot = corruptedBeam.m_146908_();
        this.xRotO = corruptedBeam.f_19860_;
        this.yRotO = corruptedBeam.f_19859_;
    }

    public CBeamPacket(int beamEntityID, double positionX, double positionY, double positionZ, float xRot, float yRot, float xRotO, float yRotO) {
        this.beamEntityID = beamEntityID;
        this.positionX = positionX;
        this.positionY = positionY;
        this.positionZ = positionZ;
        this.xRot = xRot;
        this.yRot = yRot;
        this.xRotO = xRotO;
        this.yRotO = yRotO;
    }

    public static void encode(CBeamPacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.beamEntityID);
        buf.writeDouble(packet.positionX);
        buf.writeDouble(packet.positionY);
        buf.writeDouble(packet.positionZ);
        buf.writeFloat(packet.xRot);
        buf.writeFloat(packet.yRot);
        buf.writeFloat(packet.xRotO);
        buf.writeFloat(packet.yRotO);
    }

    public static CBeamPacket decode(FriendlyByteBuf buf) {
        return new CBeamPacket(buf.readInt(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat());
    }

    public static void consume(CBeamPacket packet, Supplier<NetworkEvent.Context> ctx) {
        if (packet != null) {
            ctx.get().setPacketHandled(true);
            ctx.get().enqueueWork(() -> {
                Entity entity;
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player != null && (entity = player.f_19853_.m_6815_(packet.beamEntityID)) instanceof CorruptedBeam) {
                    CorruptedBeam corruptedBeam = (CorruptedBeam)entity;
                    if (corruptedBeam.getOwner() != player) {
                        return;
                    }
                    corruptedBeam.m_6034_(packet.positionX, packet.positionY, packet.positionZ);
                    corruptedBeam.m_146926_(packet.xRot);
                    corruptedBeam.m_146922_(packet.yRot);
                    corruptedBeam.f_19860_ = packet.xRotO;
                    corruptedBeam.f_19859_ = packet.yRotO;
                }
            });
        }
    }
}

