/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.wind;

import com.Polarice3.Goety.SpellConfig;
import com.Polarice3.Goety.api.blocks.entities.IWindPowered;
import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.projectiles.FireTornado;
import com.Polarice3.Goety.common.magic.Spells;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class WindBlastSpell
extends Spells {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.WindBlastCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.WindBlastDuration.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.PREPARE_SPELL.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.WindBlastCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.WIND;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RANGE.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity entityLiving, ItemStack staff) {
        BlockPos blockPos;
        BlockEntity blockEntity;
        int range;
        Vec3 srcVec = new Vec3(entityLiving.m_20185_(), entityLiving.m_20188_(), entityLiving.m_20189_());
        Vec3 lookVec = entityLiving.m_20252_(1.0f);
        double knock = this.rightStaff(staff) ? 2.0 : 1.0;
        int n = range = this.rightStaff(staff) ? 16 : 8;
        if (WandUtil.enchantedFocus(entityLiving)) {
            knock += (double)WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), entityLiving) / 4.0;
            range += WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), entityLiving);
        }
        for (int i = 1; i < range; ++i) {
            Vec3 vector3d2 = srcVec.m_82549_(lookVec.m_82490_((double)i));
            worldIn.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.WIND_BLAST.get()), vector3d2.f_82479_, vector3d2.f_82480_, vector3d2.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
        }
        Vec3 rangeVec = new Vec3(lookVec.f_82479_ * (double)range, lookVec.f_82480_ * (double)range, lookVec.f_82481_ * (double)range);
        BlockHitResult result = this.blockResult((Level)worldIn, entityLiving, range);
        if (result != null && (blockEntity = worldIn.m_7702_(blockPos = result.m_82425_())) instanceof IWindPowered) {
            IWindPowered windPowered = (IWindPowered)blockEntity;
            windPowered.activate(MathHelper.secondsToTicks(15));
        }
        List entities = entityLiving.f_19853_.m_45933_((Entity)entityLiving, entityLiving.m_20191_().m_82369_(rangeVec));
        for (Entity entity : entities) {
            if (!entityLiving.m_142582_(entity)) continue;
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                MobUtil.knockBack(living, (Entity)entityLiving, 2.0 * knock, 0.2 * knock, 2.0 * knock);
            }
            if (!(entity instanceof FireTornado)) continue;
            FireTornado fireTornado = (FireTornado)entity;
            fireTornado.trueRemove();
        }
        worldIn.m_6263_(null, entityLiving.m_20185_(), entityLiving.m_20186_(), entityLiving.m_20189_(), (SoundEvent)ModSounds.WIND_BLAST.get(), this.getSoundSource(), 3.0f, 1.0f);
    }
}

