/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.wild;

import com.Polarice3.Goety.SpellConfig;
import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.Wavewhisperer;
import com.Polarice3.Goety.common.entities.ally.Whisperer;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.magic.SummonSpells;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class WhisperSpell
extends SummonSpells {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.WhisperCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.WhisperDuration.get();
    }

    @Override
    @Nullable
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.WILD_PREPARE_SPELL.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.WhisperCoolDown.get();
    }

    @Override
    public int SummonDownDuration() {
        return (Integer)SpellConfig.WhisperSummonDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.WILD;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        return list;
    }

    @Override
    public void commonResult(ServerLevel worldIn, LivingEntity entityLiving) {
        if (WandUtil.enchantedFocus(entityLiving)) {
            this.enchantment = WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), entityLiving);
            this.duration = WandUtil.getLevels((Enchantment)ModEnchantments.DURATION.get(), entityLiving) + 1;
        }
        if (this.isShifting(entityLiving)) {
            for (Entity entity : worldIn.m_8583_()) {
                if (!(entity instanceof Whisperer) || ((Whisperer)entity).getTrueOwner() != entityLiving) continue;
                entity.m_20219_(entityLiving.m_20182_());
            }
            for (int i = 0; i < entityLiving.f_19853_.f_46441_.m_188503_(35) + 10; ++i) {
                worldIn.m_8767_((ParticleOptions)ParticleTypes.f_123759_, entityLiving.m_20185_(), entityLiving.m_20188_(), entityLiving.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            }
            worldIn.m_6263_((Player)null, entityLiving.m_20185_(), entityLiving.m_20186_(), entityLiving.m_20189_(), (SoundEvent)ModSounds.SUMMON_SPELL.get(), this.getSoundSource(), 1.0f, 1.0f);
        }
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity entityLiving, ItemStack staff) {
        this.commonResult(worldIn, entityLiving);
        if (!this.isShifting(entityLiving)) {
            int i = 1;
            if (this.rightStaff(staff)) {
                i = 2;
            }
            for (int i1 = 0; i1 < i; ++i1) {
                Whisperer summonedentity = new Whisperer((EntityType<? extends Owned>)((EntityType)ModEntityType.WHISPERER.get()), (Level)worldIn);
                BlockPos blockPos = BlockFinder.SummonRadius(entityLiving, (Level)worldIn);
                if (entityLiving.m_5842_()) {
                    blockPos = BlockFinder.SummonWaterRadius(entityLiving, (Level)worldIn);
                }
                if (worldIn.m_46801_(blockPos)) {
                    summonedentity = new Wavewhisperer((EntityType<? extends Owned>)((EntityType)ModEntityType.WAVEWHISPERER.get()), (Level)worldIn);
                }
                summonedentity.setTrueOwner(entityLiving);
                summonedentity.m_20035_(blockPos, 0.0f, 0.0f);
                if (summonedentity.m_6095_() != ModEntityType.WAVEWHISPERER.get()) {
                    MobUtil.moveDownToGround((Entity)summonedentity);
                }
                summonedentity.setLimitedLife(MobUtil.getSummonLifespan((Level)worldIn) * this.duration);
                summonedentity.m_21530_();
                summonedentity.m_6518_((ServerLevelAccessor)worldIn, entityLiving.f_19853_.m_6436_(entityLiving.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                if (this.enchantment > 0) {
                    int boost = Mth.m_14045_((int)(this.enchantment - 1), (int)0, (int)10);
                    summonedentity.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.BUFF.get(), Integer.MAX_VALUE, boost, false, false));
                }
                this.SummonSap(entityLiving, (LivingEntity)summonedentity);
                this.setTarget(worldIn, entityLiving, (Mob)summonedentity);
                worldIn.m_7967_((Entity)summonedentity);
                this.summonAdvancement(entityLiving, entityLiving);
            }
            this.SummonDown(entityLiving);
            worldIn.m_6263_((Player)null, entityLiving.m_20185_(), entityLiving.m_20186_(), entityLiving.m_20189_(), (SoundEvent)ModSounds.SUMMON_SPELL.get(), this.getSoundSource(), 1.0f, 1.0f);
        }
    }
}

