/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.wild;

import com.Polarice3.Goety.SpellConfig;
import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.neutral.InsectSwarm;
import com.Polarice3.Goety.common.magic.BreathingSpells;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SwarmSpell
extends BreathingSpells {
    public float damage = ((Double)SpellConfig.SwarmDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();

    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.SwarmCost.get();
    }

    @Override
    public int defaultCastUp() {
        return (Integer)SpellConfig.SwarmChargeUp.get();
    }

    @Override
    @Nullable
    public SoundEvent CastingSound() {
        return null;
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.WILD;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        list.add((Enchantment)ModEnchantments.RANGE.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity entityLiving, ItemStack staff) {
        Player player;
        int enchantment = 0;
        int duration = 1;
        int range = 0;
        if (entityLiving instanceof Player && WandUtil.enchantedFocus((LivingEntity)(player = (Player)entityLiving))) {
            enchantment = WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), (LivingEntity)player);
            duration += WandUtil.getLevels((Enchantment)ModEnchantments.DURATION.get(), (LivingEntity)player);
            range = WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), (LivingEntity)player);
        }
        float damage = this.damage + (float)enchantment;
        if (!worldIn.f_46443_) {
            for (Entity target : this.getTarget(entityLiving, range + 15)) {
                if (target == null || !target.m_6469_(ModDamageSource.swarm((Entity)entityLiving, (Entity)entityLiving), damage) || target.m_6084_()) continue;
                InsectSwarm insectSwarm = new InsectSwarm((Level)worldIn, entityLiving, target.m_20182_());
                insectSwarm.setLimitedLife(200 * duration);
                if (enchantment > 0) {
                    insectSwarm.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.BUFF.get(), -1, enchantment - 1, false, false));
                }
                worldIn.m_7967_((Entity)insectSwarm);
            }
            if (this.rightStaff(staff)) {
                ServerParticleUtil.addParticlesAroundMiddleSelf(worldIn, (ParticleOptions)ModParticleTypes.FLY.get(), (Entity)entityLiving);
                for (LivingEntity nearby : worldIn.m_6443_(LivingEntity.class, entityLiving.m_20191_().m_82400_(1.0), entity -> entityLiving != entity && !MobUtil.areAllies((Entity)entityLiving, (Entity)entity))) {
                    if (!nearby.m_6084_() || !nearby.m_6469_(ModDamageSource.swarm((Entity)entityLiving, (Entity)entityLiving), 0.5f)) continue;
                    entityLiving.m_5496_((SoundEvent)ModSounds.INSECT_SWARM_BITE.get(), 1.0f, entityLiving.m_6100_());
                    nearby.f_19802_ = 15;
                }
            }
        }
        worldIn.m_6263_(null, entityLiving.m_20185_(), entityLiving.m_20186_(), entityLiving.m_20189_(), (SoundEvent)ModSounds.INSECT_SWARM.get(), this.getSoundSource(), worldIn.f_46441_.m_188501_() * 0.5f, worldIn.f_46441_.m_188501_() * 0.5f);
    }

    @Override
    public void showWandBreath(LivingEntity entityLiving) {
        Player player;
        int range = 0;
        if (entityLiving instanceof Player && WandUtil.enchantedFocus((LivingEntity)(player = (Player)entityLiving))) {
            range = WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), (LivingEntity)player);
        }
        this.breathAttack((ParticleOptions)ModParticleTypes.FLY.get(), entityLiving, true, (double)0.3f + (double)range / 10.0, 5.0);
    }
}

