/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.wild;

import com.Polarice3.Goety.SpellConfig;
import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.neutral.AbstractMonolith;
import com.Polarice3.Goety.common.magic.Spells;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class OvergrowthSpell
extends Spells {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.OvergrowthCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.OvergrowthDuration.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.WILD;
    }

    @Override
    @Nullable
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.WILD_PREPARE_SPELL.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.OvergrowthCoolDown.get();
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RANGE.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        return list;
    }

    public Vec3 getHorizontalLeftLookAngle(LivingEntity livingEntity) {
        return MobUtil.calculateViewVector(0.0f, livingEntity.m_146908_() - 90.0f);
    }

    public Vec3 getHorizontalRightLookAngle(LivingEntity livingEntity) {
        return MobUtil.calculateViewVector(0.0f, livingEntity.m_146908_() + 90.0f);
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity entityLiving, ItemStack staff) {
        HitResult rayTraceResult;
        int range = 16;
        int potency = 0;
        int duration = 0;
        if (WandUtil.enchantedFocus(entityLiving)) {
            range += WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), entityLiving);
            potency += WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), entityLiving);
            duration += WandUtil.getLevels((Enchantment)ModEnchantments.DURATION.get(), entityLiving);
        }
        if ((rayTraceResult = this.rayTrace((Level)worldIn, entityLiving, range, 3.0)) instanceof EntityHitResult) {
            Entity target = ((EntityHitResult)rayTraceResult).m_82443_();
            if (this.isShifting(entityLiving)) {
                int x = (int)(this.getHorizontalLeftLookAngle((LivingEntity)entityLiving).f_82479_ * 2.0);
                int z = (int)(this.getHorizontalLeftLookAngle((LivingEntity)entityLiving).f_82481_ * 2.0);
                int x1 = (int)(this.getHorizontalRightLookAngle((LivingEntity)entityLiving).f_82479_ * 2.0);
                int z1 = (int)(this.getHorizontalRightLookAngle((LivingEntity)entityLiving).f_82481_ * 2.0);
                BlockPos left = new BlockPos((Vec3i)entityLiving.m_20183_().m_7918_(x, 0, z));
                BlockPos right = new BlockPos((Vec3i)entityLiving.m_20183_().m_7918_(x1, 0, z1));
                EntityType entityType = (EntityType)ModEntityType.POISON_QUILL_VINE.get();
                WandUtil.summonTurret(entityLiving, BlockFinder.SummonPosition(entityLiving, left), (EntityType<? extends AbstractMonolith>)entityType, target, duration, potency);
                if (this.rightStaff(staff)) {
                    WandUtil.summonTurret(entityLiving, BlockFinder.SummonPosition(entityLiving, right), (EntityType<? extends AbstractMonolith>)entityType, target, duration, potency);
                }
            } else {
                int random = worldIn.f_46441_.m_188503_(5);
                Direction direction = Direction.m_122364_((double)target.m_6080_());
                EntityType entityType = (EntityType)ModEntityType.QUICK_GROWING_VINE.get();
                if (random == 0) {
                    WandUtil.summonMinorSquareTrap(entityLiving, target, (EntityType<? extends AbstractMonolith>)entityType, direction, duration);
                } else if (random == 1) {
                    WandUtil.summonHallTrap(entityLiving, target, (EntityType<? extends AbstractMonolith>)entityType, duration);
                } else if (random == 2) {
                    WandUtil.summonCubeTrap(entityLiving, target, (EntityType<? extends AbstractMonolith>)entityType, duration);
                } else if (random == 3) {
                    WandUtil.summonCircleTrap(entityLiving, target, (EntityType<? extends AbstractMonolith>)entityType, direction, duration);
                } else {
                    WandUtil.summonSurroundTrap(entityLiving, target, (EntityType<? extends AbstractMonolith>)entityType, duration);
                }
            }
        } else if (rayTraceResult instanceof BlockHitResult) {
            BlockPos blockPos = ((BlockHitResult)rayTraceResult).m_82425_();
            if (this.isShifting(entityLiving)) {
                EntityType entityType = (EntityType)ModEntityType.POISON_QUILL_VINE.get();
                WandUtil.summonTurret(entityLiving, blockPos, (EntityType<? extends AbstractMonolith>)entityType, null, duration, potency);
            } else {
                EntityType entityType = (EntityType)ModEntityType.QUICK_GROWING_VINE.get();
                WandUtil.summonCubeTrap(entityLiving, blockPos, (EntityType<? extends AbstractMonolith>)entityType, duration);
            }
        }
    }
}

