/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.void_spells;

import com.Polarice3.Goety.SpellConfig;
import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.Spells;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BlinkSpell
extends Spells {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.BlinkCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.BlinkDuration.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return SoundEvents.f_11852_;
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.BlinkCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.VOID;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.RANGE.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity entityLiving, ItemStack staff) {
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            int enchantment = 0;
            if (WandUtil.enchantedFocus((LivingEntity)player)) {
                enchantment = WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), (LivingEntity)player);
            }
            Vec3 vec3 = BlinkSpell.findTeleportLocation(worldIn, (LivingEntity)player, 32 + enchantment);
            BlockPos blockPos = BlockPos.m_274446_((Position)vec3);
            BlinkSpell.enderTeleportEvent(entityLiving, (Level)worldIn, blockPos);
            worldIn.m_7605_((Entity)player, (byte)46);
        }
        worldIn.m_6263_(null, entityLiving.m_20185_(), entityLiving.m_20186_(), entityLiving.m_20189_(), this.CastingSound(), this.getSoundSource(), 2.0f, 1.0f);
    }

    public static Vec3 findTeleportLocation(ServerLevel level, LivingEntity livingEntity, float maxDistance) {
        boolean los;
        BlockHitResult blockHitResult = MobUtil.rayTrace((Entity)livingEntity, maxDistance, false);
        BlockPos pos = blockHitResult.m_82425_();
        Vec3 bbOffset = livingEntity.m_20156_().m_82541_().m_82542_((double)livingEntity.m_20205_() / 3.0, 0.0, (double)livingEntity.m_20206_() / 3.0);
        Vec3 bbImpact = blockHitResult.m_82450_().m_82546_(bbOffset);
        int ledgeY = (int)level.m_45547_((ClipContext)new ClipContext((Vec3)Vec3.m_82539_((Vec3i)pos).m_82520_((double)0.0, (double)3.0, (double)0.0), (Vec3)Vec3.m_82539_((Vec3i)pos), (ClipContext.Block)ClipContext.Block.COLLIDER, (ClipContext.Fluid)ClipContext.Fluid.NONE, null)).m_82450_().f_82480_;
        Vec3 correctedPos = new Vec3((double)pos.m_123341_(), (double)ledgeY, (double)pos.m_123343_());
        boolean isAir = level.m_8055_(BlockPos.m_274446_((Position)correctedPos)).m_60795_();
        boolean bl = los = level.m_45547_(new ClipContext(bbImpact, bbImpact.m_82520_(0.0, (double)(ledgeY - pos.m_123342_()), 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)livingEntity)).m_6662_() == HitResult.Type.MISS;
        if (isAir && los && Math.abs(ledgeY - pos.m_123342_()) <= 3) {
            return correctedPos.m_82520_(0.5, 0.076, 0.5);
        }
        return level.m_45547_(new ClipContext(bbImpact, bbImpact.m_82520_(0.0, (double)(-livingEntity.m_20192_()), 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)livingEntity)).m_82450_().m_82520_(0.0, 0.076, 0.0);
    }

    public static void enderTeleportEvent(LivingEntity player, Level world, BlockPos target) {
        player.m_6021_((double)target.m_123341_(), (double)target.m_123342_(), (double)target.m_123343_());
        player.m_183634_();
    }
}

