/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.storm;

import com.Polarice3.Goety.SpellConfig;
import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.Spells;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SThunderBoltPacket;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;

public class ThunderboltSpell
extends Spells {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.ThunderboltCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.ThunderboltDuration.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.ZAP.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.ThunderboltCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.STORM;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RANGE.get());
        list.add((Enchantment)ModEnchantments.BURNING.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity entityLiving, ItemStack staff) {
        LivingEntity livingEntity;
        Player playerEntity = (Player)entityLiving;
        int range = 16;
        float damage = ((Double)SpellConfig.ThunderboltDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();
        int burning = 0;
        if (WandUtil.enchantedFocus(entityLiving)) {
            range += WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), entityLiving);
            damage += (float)WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), entityLiving);
            burning += WandUtil.getLevels((Enchantment)ModEnchantments.BURNING.get(), entityLiving);
        }
        Vec3 vec3 = entityLiving.m_146892_();
        BlockHitResult rayTraceResult = this.blockResult((Level)worldIn, (LivingEntity)playerEntity, range);
        Entity target = MobUtil.getNearbyTarget((Level)worldIn, entityLiving, 20.0, 1.0);
        Optional<BlockPos> lightningRod = BlockFinder.findLightningRod(worldIn, BlockPos.m_274446_((Position)rayTraceResult.m_82450_()), range);
        if (lightningRod.isPresent() && !this.rightStaff(staff)) {
            BlockPos blockPos = lightningRod.get();
            ModNetwork.sendToALL(new SThunderBoltPacket(vec3, new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), 10));
            worldIn.m_6263_(null, entityLiving.m_20185_(), entityLiving.m_20186_(), entityLiving.m_20189_(), (SoundEvent)ModSounds.THUNDERBOLT.get(), this.getSoundSource(), 1.0f, 1.0f);
        } else if (target instanceof LivingEntity && !(livingEntity = (LivingEntity)target).m_21224_() && ForgeHooks.onLivingAttack((LivingEntity)livingEntity, (DamageSource)ModDamageSource.directShock(entityLiving), (float)damage)) {
            Vec3 vec31 = new Vec3(target.m_20185_(), target.m_20186_() + (double)(target.m_20206_() / 2.0f), target.m_20189_());
            ModNetwork.sendToALL(new SThunderBoltPacket(vec3, vec31, 10));
            if (target.m_6469_(ModDamageSource.directShock(entityLiving), damage)) {
                float chance;
                float f = chance = this.rightStaff(staff) ? 0.25f : 0.05f;
                if (worldIn.m_46470_() && worldIn.m_46758_(target.m_20183_()) && worldIn.f_46441_.m_188501_() <= chance) {
                    LightningBolt lightningBolt = new LightningBolt(EntityType.f_20465_, (Level)worldIn);
                    lightningBolt.m_146884_(target.m_20182_());
                    if (entityLiving instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)entityLiving;
                        lightningBolt.m_20879_(serverPlayer);
                    }
                    worldIn.m_7967_((Entity)lightningBolt);
                }
                if (worldIn.f_46441_.m_188501_() <= chance + 0.1f) {
                    livingEntity.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.TRIPPING.get(), MathHelper.secondsToTicks(5)));
                }
                if (burning > 0) {
                    target.m_20254_(5 * burning);
                }
            }
            worldIn.m_6263_(null, entityLiving.m_20185_(), entityLiving.m_20186_(), entityLiving.m_20189_(), (SoundEvent)ModSounds.THUNDERBOLT.get(), this.getSoundSource(), 1.0f, 1.0f);
        } else {
            BlockPos blockPos = rayTraceResult.m_82425_();
            ModNetwork.sendToALL(new SThunderBoltPacket(vec3, new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), 10));
            worldIn.m_6263_(null, entityLiving.m_20185_(), entityLiving.m_20186_(), entityLiving.m_20189_(), (SoundEvent)ModSounds.THUNDERBOLT.get(), this.getSoundSource(), 1.0f, 1.0f);
        }
    }
}

