/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.storm;

import com.Polarice3.Goety.SpellConfig;
import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.EverChargeSpells;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SLightningPacket;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;

public class ShockingSpell
extends EverChargeSpells {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.ShockingCost.get();
    }

    @Override
    public int defaultCastUp() {
        return (Integer)SpellConfig.ShockingChargeUp.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.ZAP.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.STORM;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RANGE.get());
        list.add((Enchantment)ModEnchantments.BURNING.get());
        return list;
    }

    public void commonResult(ServerLevel worldIn, LivingEntity entityLiving, int range, boolean staff) {
        LivingEntity livingEntity;
        Player playerEntity = (Player)entityLiving;
        float damage = ((Double)SpellConfig.ShockingDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();
        int burning = 0;
        if (WandUtil.enchantedFocus(entityLiving)) {
            range += WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), entityLiving);
            damage += (float)WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), entityLiving);
            burning += WandUtil.getLevels((Enchantment)ModEnchantments.BURNING.get(), entityLiving);
        }
        Vec3 vec3 = entityLiving.m_146892_();
        BlockHitResult rayTraceResult = this.blockResult((Level)worldIn, (LivingEntity)playerEntity, range);
        Entity target = MobUtil.getNearbyTarget((Level)worldIn, entityLiving, 20.0, 1.0);
        Optional<BlockPos> lightningRod = BlockFinder.findLightningRod(worldIn, BlockPos.m_274446_((Position)rayTraceResult.m_82450_()), range);
        if (lightningRod.isPresent() && !staff) {
            BlockPos blockPos = lightningRod.get();
            ModNetwork.sendToALL(new SLightningPacket(vec3, new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), 5));
            worldIn.m_6263_(null, entityLiving.m_20185_(), entityLiving.m_20186_(), entityLiving.m_20189_(), (SoundEvent)ModSounds.ZAP.get(), this.getSoundSource(), 1.0f, 1.0f);
        } else if (target instanceof LivingEntity && !(livingEntity = (LivingEntity)target).m_21224_() && ForgeHooks.onLivingAttack((LivingEntity)livingEntity, (DamageSource)ModDamageSource.directShock(entityLiving), (float)damage)) {
            Vec3 vec31 = new Vec3(target.m_20185_(), target.m_20186_() + (double)(target.m_20206_() / 2.0f), target.m_20189_());
            ModNetwork.sendToALL(new SLightningPacket(vec3, vec31, 5));
            if (target.m_6469_(ModDamageSource.directShock(entityLiving), damage) && burning > 0 && worldIn.f_46441_.m_188501_() < 0.05f) {
                target.m_20254_(5 * burning);
            }
            worldIn.m_6263_(null, entityLiving.m_20185_(), entityLiving.m_20186_(), entityLiving.m_20189_(), (SoundEvent)ModSounds.ZAP.get(), this.getSoundSource(), 1.0f, 1.0f);
        } else {
            BlockPos blockPos = rayTraceResult.m_82425_();
            ModNetwork.sendToALL(new SLightningPacket(vec3, new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), 5));
            worldIn.m_6263_(null, entityLiving.m_20185_(), entityLiving.m_20186_(), entityLiving.m_20189_(), (SoundEvent)ModSounds.ZAP.get(), this.getSoundSource(), 1.0f, 1.0f);
        }
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity entityLiving, ItemStack staff) {
        this.commonResult(worldIn, entityLiving, 16, this.rightStaff(staff));
    }
}

