/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.storm;

import com.Polarice3.Goety.SpellConfig;
import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.Spells;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class LightningSpell
extends Spells {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.LightningCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.LightningDuration.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.PREPARE_SPELL.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.LightningCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.STORM;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RANGE.get());
        return list;
    }

    public void commonResult(ServerLevel worldIn, LivingEntity entityLiving, int range, boolean staff) {
        HitResult rayTraceResult;
        Optional<BlockPos> lightningRod;
        double radius = 2.0;
        float damage = ((Double)SpellConfig.LightningDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();
        if (WandUtil.enchantedFocus(entityLiving)) {
            range += WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), entityLiving);
            damage += (float)WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), entityLiving);
        }
        if ((lightningRod = BlockFinder.findLightningRod(worldIn, BlockPos.m_274446_((Position)(rayTraceResult = this.rayTrace((Level)worldIn, entityLiving, range, radius)).m_82450_()))).isPresent() && !staff) {
            BlockPos blockPos = lightningRod.get();
            LightningBolt lightningBolt = new LightningBolt(EntityType.f_20465_, (Level)worldIn);
            lightningBolt.setDamage(damage);
            lightningBolt.m_20219_(Vec3.m_82539_((Vec3i)blockPos));
            if (entityLiving instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entityLiving;
                lightningBolt.m_20879_(serverPlayer);
            }
            worldIn.m_7967_((Entity)lightningBolt);
        } else if (rayTraceResult instanceof EntityHitResult) {
            Entity target = ((EntityHitResult)rayTraceResult).m_82443_();
            if (target instanceof LivingEntity) {
                LightningBolt lightningBolt = new LightningBolt(EntityType.f_20465_, (Level)worldIn);
                lightningBolt.setDamage(damage);
                lightningBolt.m_146884_(target.m_20182_());
                if (entityLiving instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entityLiving;
                    lightningBolt.m_20879_(serverPlayer);
                }
                worldIn.m_7967_((Entity)lightningBolt);
            }
        } else if (rayTraceResult instanceof BlockHitResult) {
            BlockPos blockPos = ((BlockHitResult)rayTraceResult).m_82425_();
            LightningBolt lightningBolt = new LightningBolt(EntityType.f_20465_, (Level)worldIn);
            lightningBolt.setDamage(damage);
            lightningBolt.m_20219_(Vec3.m_82539_((Vec3i)blockPos));
            if (entityLiving instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entityLiving;
                lightningBolt.m_20879_(serverPlayer);
            }
            worldIn.m_7967_((Entity)lightningBolt);
        }
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity entityLiving, ItemStack staff) {
        this.commonResult(worldIn, entityLiving, 16, this.rightStaff(staff));
    }
}

