/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.storm;

import com.Polarice3.Goety.SpellConfig;
import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.client.particles.ShockwaveParticleOption;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.Spells;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;

public class DischargeSpell
extends Spells {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.DischargeCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.DischargeDuration.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.DischargeCoolDown.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.PREPARE_SPELL.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.STORM;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RADIUS.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity entityLiving, ItemStack staff) {
        int radius = 3;
        float damage = ((Double)SpellConfig.DischargeDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();
        float maxDamage = ((Double)SpellConfig.DischargeMaxDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();
        if (WandUtil.enchantedFocus(entityLiving)) {
            radius += WandUtil.getLevels((Enchantment)ModEnchantments.RADIUS.get(), entityLiving);
            damage += (float)WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), entityLiving) / 2.0f;
            maxDamage += (float)WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), entityLiving) / 2.0f;
        }
        for (int i = -radius; i < radius; ++i) {
            for (int k = -radius; k < radius; ++k) {
                BlockPos blockPos = entityLiving.m_20183_().m_7918_(i, 0, k);
                worldIn.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.ELECTRIC.get()), (double)blockPos.m_123341_(), (double)((float)blockPos.m_123342_() + 0.5f), (double)blockPos.m_123343_(), 0, 0.0, 0.04, 0.0, 0.5);
            }
        }
        worldIn.m_8767_((ParticleOptions)new ShockwaveParticleOption(0), entityLiving.m_20185_(), entityLiving.m_20186_() + 0.5, entityLiving.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
        float trueDamage = Mth.m_14036_((float)(damage + (float)worldIn.f_46441_.m_188503_((int)(maxDamage - damage))), (float)damage, (float)maxDamage);
        MobUtil.explosionDamage((Level)worldIn, (Entity)entityLiving, ModDamageSource.indirectShock((Entity)entityLiving, (Entity)entityLiving), entityLiving.m_20183_(), radius, trueDamage);
        for (Entity entity : MobUtil.explosionRangeEntities((Level)worldIn, (Entity)entityLiving, entityLiving.m_20183_(), radius)) {
            float chance;
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity target = (LivingEntity)entity;
            float f = chance = this.rightStaff(staff) ? 0.25f : 0.05f;
            if (!worldIn.m_46470_() || !worldIn.m_46758_(target.m_20183_()) || !(worldIn.f_46441_.m_188501_() <= chance)) continue;
            LightningBolt lightningBolt = new LightningBolt(EntityType.f_20465_, (Level)worldIn);
            lightningBolt.m_146884_(target.m_20182_());
            if (entityLiving instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entityLiving;
                lightningBolt.m_20879_(serverPlayer);
            }
            worldIn.m_7967_((Entity)lightningBolt);
        }
        worldIn.m_6263_(null, entityLiving.m_20185_(), entityLiving.m_20186_(), entityLiving.m_20189_(), (SoundEvent)ModSounds.REDSTONE_EXPLODE.get(), this.getSoundSource(), 1.0f, 1.0f);
    }
}

