/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.nether;

import com.Polarice3.Goety.SpellConfig;
import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.AllyVex;
import com.Polarice3.Goety.common.entities.ally.MiniGhast;
import com.Polarice3.Goety.common.entities.hostile.servants.Malghast;
import com.Polarice3.Goety.common.magic.SummonSpells;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class GhastSpell
extends SummonSpells {
    private final TargetingConditions ghastCountTargeting = TargetingConditions.f_26872_.m_26883_(64.0).m_26893_();

    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.GhastCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.GhastDuration.get();
    }

    @Override
    public int SummonDownDuration() {
        return (Integer)SpellConfig.GhastSummonDown.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.GhastCoolDown.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.PREPARE_SUMMON.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.NETHER;
    }

    @Override
    public boolean conditionsMet(ServerLevel worldIn, LivingEntity entityLiving) {
        return this.ghastLimit(entityLiving) < (Integer)SpellConfig.GhastLimit.get();
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        return list;
    }

    @Override
    public void commonResult(ServerLevel worldIn, LivingEntity entityLiving) {
        if (WandUtil.enchantedFocus(entityLiving)) {
            this.enchantment = WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), entityLiving);
            this.duration = WandUtil.getLevels((Enchantment)ModEnchantments.DURATION.get(), entityLiving) + 1;
        }
        if (this.isShifting(entityLiving)) {
            for (Entity entity : worldIn.m_8583_()) {
                if (!(entity instanceof MiniGhast) || ((MiniGhast)entity).getTrueOwner() != entityLiving) continue;
                ((MiniGhast)entity).lifeSpanDamage();
            }
            for (int i = 0; i < entityLiving.f_19853_.f_46441_.m_188503_(35) + 10; ++i) {
                worldIn.m_8767_((ParticleOptions)ParticleTypes.f_123759_, entityLiving.m_20185_(), entityLiving.m_20188_(), entityLiving.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            }
            worldIn.m_6263_((Player)null, entityLiving.m_20185_(), entityLiving.m_20186_(), entityLiving.m_20189_(), (SoundEvent)ModSounds.SUMMON_SPELL.get(), this.getSoundSource(), 1.0f, 1.0f);
        }
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity entityLiving, ItemStack staff) {
        this.commonResult(worldIn, entityLiving);
        if (!this.isShifting(entityLiving)) {
            int i = 3;
            for (int i1 = 0; i1 < i; ++i1) {
                BlockPos blockpos = entityLiving.m_20183_().m_7918_(-2 + entityLiving.m_217043_().m_188503_(5), 1, -2 + entityLiving.m_217043_().m_188503_(5));
                MiniGhast miniGhast = new MiniGhast((EntityType<? extends Malghast>)((EntityType)ModEntityType.MINI_GHAST.get()), (Level)worldIn);
                miniGhast.setTrueOwner(entityLiving);
                miniGhast.m_20035_(blockpos, 0.0f, 0.0f);
                miniGhast.m_6518_((ServerLevelAccessor)worldIn, entityLiving.f_19853_.m_6436_(blockpos), MobSpawnType.MOB_SUMMONED, null, null);
                miniGhast.setLimitedLife(MobUtil.getSummonLifespan((Level)worldIn) * this.duration);
                if (this.enchantment > 0) {
                    int boost = Mth.m_14045_((int)this.enchantment, (int)1, (int)10);
                    miniGhast.setFireBallDamage(miniGhast.getFireBallDamage() + (float)boost);
                }
                this.SummonSap(entityLiving, (LivingEntity)miniGhast);
                this.setTarget(worldIn, entityLiving, (Mob)miniGhast);
                worldIn.m_7967_((Entity)miniGhast);
                this.summonAdvancement(entityLiving, (LivingEntity)miniGhast);
            }
            this.SummonDown(entityLiving);
            worldIn.m_6263_((Player)null, entityLiving.m_20185_(), entityLiving.m_20186_(), entityLiving.m_20189_(), (SoundEvent)ModSounds.SUMMON_SPELL.get(), this.getSoundSource(), 1.0f, 1.0f);
        }
    }

    public int ghastLimit(LivingEntity entityLiving) {
        return entityLiving.f_19853_.m_45971_(AllyVex.class, this.ghastCountTargeting, entityLiving, entityLiving.m_20191_().m_82400_(64.0)).size();
    }
}

