/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.necromancy;

import com.Polarice3.Goety.SpellConfig;
import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.ally.undead.zombie.DrownedServant;
import com.Polarice3.Goety.common.entities.ally.undead.zombie.FrozenZombieServant;
import com.Polarice3.Goety.common.entities.ally.undead.zombie.HuskServant;
import com.Polarice3.Goety.common.entities.ally.undead.zombie.JungleZombieServant;
import com.Polarice3.Goety.common.entities.ally.undead.zombie.ZombieServant;
import com.Polarice3.Goety.common.entities.ally.undead.zombie.ZombieVindicator;
import com.Polarice3.Goety.common.entities.neutral.ZPiglinBruteServant;
import com.Polarice3.Goety.common.entities.neutral.ZPiglinServant;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.magic.SummonSpells;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.common.Tags;

public class ZombieSpell
extends SummonSpells {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.ZombieCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.ZombieDuration.get();
    }

    @Override
    public int SummonDownDuration() {
        return (Integer)SpellConfig.ZombieSummonDown.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.PREPARE_SUMMON.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.ZombieCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.NECROMANCY;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        return list;
    }

    @Override
    public void commonResult(ServerLevel worldIn, LivingEntity entityLiving) {
        if (WandUtil.enchantedFocus(entityLiving)) {
            this.enchantment = WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), entityLiving);
            this.duration = WandUtil.getLevels((Enchantment)ModEnchantments.DURATION.get(), entityLiving) + 1;
        }
        if (this.isShifting(entityLiving)) {
            for (Entity entity : worldIn.m_8583_()) {
                if (!(entity instanceof ZombieServant) || ((ZombieServant)entity).getTrueOwner() != entityLiving) continue;
                entity.m_20219_(entityLiving.m_20182_());
            }
            for (int i = 0; i < entityLiving.f_19853_.f_46441_.m_188503_(35) + 10; ++i) {
                worldIn.m_8767_((ParticleOptions)ParticleTypes.f_123759_, entityLiving.m_20185_(), entityLiving.m_20188_(), entityLiving.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            }
            worldIn.m_6263_((Player)null, entityLiving.m_20185_(), entityLiving.m_20186_(), entityLiving.m_20189_(), (SoundEvent)ModSounds.SUMMON_SPELL.get(), this.getSoundSource(), 1.0f, 1.0f);
        }
    }

    public boolean specialStaffs(ItemStack stack) {
        return stack.m_150930_((Item)ModItems.FROST_STAFF.get()) || stack.m_150930_((Item)ModItems.WILD_STAFF.get());
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity entityLiving, ItemStack staff) {
        this.commonResult(worldIn, entityLiving);
        if (!this.isShifting(entityLiving)) {
            int i = 1;
            if (staff.m_150930_((Item)ModItems.NAMELESS_STAFF.get())) {
                i = 7;
            } else if (this.rightStaff(staff)) {
                i = 2 + entityLiving.f_19853_.f_46441_.m_188503_(4);
            } else if (this.specialStaffs(staff)) {
                i = 2;
            }
            for (int i1 = 0; i1 < i; ++i1) {
                Summoned summonedentity = new ZombieServant((EntityType<? extends Summoned>)((EntityType)ModEntityType.ZOMBIE_SERVANT.get()), (Level)worldIn);
                BlockPos blockPos = BlockFinder.SummonRadius(entityLiving, (Level)worldIn);
                if (entityLiving.m_5842_()) {
                    blockPos = BlockFinder.SummonWaterRadius(entityLiving, (Level)worldIn);
                }
                if (this.specialStaffs(staff)) {
                    if (staff.m_150930_((Item)ModItems.FROST_STAFF.get())) {
                        summonedentity = new FrozenZombieServant((EntityType<? extends Summoned>)((EntityType)ModEntityType.FROZEN_ZOMBIE_SERVANT.get()), (Level)worldIn);
                    } else if (staff.m_150930_((Item)ModItems.WILD_STAFF.get())) {
                        summonedentity = new JungleZombieServant((EntityType<? extends Summoned>)((EntityType)ModEntityType.JUNGLE_ZOMBIE_SERVANT.get()), (Level)worldIn);
                    }
                } else if (entityLiving.m_5842_() && worldIn.m_46801_(blockPos)) {
                    summonedentity = new DrownedServant((EntityType<? extends Summoned>)((EntityType)ModEntityType.DROWNED_SERVANT.get()), (Level)worldIn);
                } else if (worldIn.m_204166_(blockPos).m_203656_(Tags.Biomes.IS_DESERT) && worldIn.m_45527_(blockPos)) {
                    summonedentity = new HuskServant((EntityType<? extends Summoned>)((EntityType)ModEntityType.HUSK_SERVANT.get()), (Level)worldIn);
                } else if (worldIn.m_46472_() == Level.f_46429_) {
                    ZPiglinServant summoned = new ZPiglinServant((EntityType<? extends Summoned>)((EntityType)ModEntityType.ZPIGLIN_SERVANT.get()), (Level)worldIn);
                    if (worldIn.f_46441_.m_188501_() <= 0.25f && BlockFinder.findStructure(worldIn, entityLiving, (ResourceKey<Structure>)BuiltinStructures.f_209863_)) {
                        summoned = new ZPiglinBruteServant((EntityType<? extends ZPiglinServant>)((EntityType)ModEntityType.ZPIGLIN_BRUTE_SERVANT.get()), (Level)worldIn);
                    }
                    summonedentity = summoned;
                } else if (BlockFinder.findStructure(worldIn, blockPos, (TagKey<Structure>)StructureTags.f_215884_)) {
                    summonedentity = new ZombieVindicator((EntityType<? extends ZombieServant>)((EntityType)ModEntityType.ZOMBIE_VINDICATOR.get()), (Level)worldIn);
                } else if (((Biome)worldIn.m_204166_(blockPos).get()).m_198904_(blockPos)) {
                    summonedentity = new FrozenZombieServant((EntityType<? extends Summoned>)((EntityType)ModEntityType.FROZEN_ZOMBIE_SERVANT.get()), (Level)worldIn);
                } else if (worldIn.m_204166_(blockPos).m_203656_(BiomeTags.f_207610_) && worldIn.f_46441_.m_188499_()) {
                    summonedentity = new JungleZombieServant((EntityType<? extends Summoned>)((EntityType)ModEntityType.JUNGLE_ZOMBIE_SERVANT.get()), (Level)worldIn);
                }
                summonedentity.setTrueOwner(entityLiving);
                summonedentity.m_20035_(blockPos, 0.0f, 0.0f);
                if (summonedentity.m_6095_() != ModEntityType.DROWNED_SERVANT.get()) {
                    MobUtil.moveDownToGround((Entity)summonedentity);
                }
                summonedentity.setLimitedLife(MobUtil.getSummonLifespan((Level)worldIn) * this.duration);
                summonedentity.m_21530_();
                summonedentity.setUpgraded(this.NecroPower(entityLiving));
                summonedentity.m_6518_((ServerLevelAccessor)worldIn, entityLiving.f_19853_.m_6436_(entityLiving.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                if (this.enchantment > 0) {
                    int boost = Mth.m_14045_((int)(this.enchantment - 1), (int)0, (int)10);
                    summonedentity.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.BUFF.get(), Integer.MAX_VALUE, boost, false, false));
                }
                this.SummonSap(entityLiving, (LivingEntity)summonedentity);
                this.setTarget(worldIn, entityLiving, (Mob)summonedentity);
                worldIn.m_7967_((Entity)summonedentity);
                this.summonAdvancement(entityLiving, entityLiving);
            }
            this.SummonDown(entityLiving);
            worldIn.m_6263_((Player)null, entityLiving.m_20185_(), entityLiving.m_20186_(), entityLiving.m_20189_(), (SoundEvent)ModSounds.SUMMON_SPELL.get(), this.getSoundSource(), 1.0f, 1.0f);
        }
    }
}

