/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.necromancy;

import com.Polarice3.Goety.SpellConfig;
import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.ally.undead.skeleton.AbstractSkeletonServant;
import com.Polarice3.Goety.common.entities.ally.undead.skeleton.MossySkeletonServant;
import com.Polarice3.Goety.common.entities.ally.undead.skeleton.SkeletonPillager;
import com.Polarice3.Goety.common.entities.ally.undead.skeleton.SkeletonServant;
import com.Polarice3.Goety.common.entities.ally.undead.skeleton.StrayServant;
import com.Polarice3.Goety.common.entities.ally.undead.skeleton.SunkenSkeletonServant;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.magic.SummonSpells;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.common.Tags;

public class SkeletonSpell
extends SummonSpells {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.SkeletonCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.SkeletonDuration.get();
    }

    @Override
    public int SummonDownDuration() {
        return (Integer)SpellConfig.SkeletonSummonDown.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.PREPARE_SUMMON.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.SkeletonCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.NECROMANCY;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        return list;
    }

    @Override
    public void commonResult(ServerLevel worldIn, LivingEntity entityLiving) {
        if (WandUtil.enchantedFocus(entityLiving)) {
            this.enchantment = WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), entityLiving);
            this.duration = WandUtil.getLevels((Enchantment)ModEnchantments.DURATION.get(), entityLiving) + 1;
        }
        if (this.isShifting(entityLiving)) {
            for (Entity entity : worldIn.m_8583_()) {
                AbstractSkeletonServant skeletonServant;
                if (!(entity instanceof AbstractSkeletonServant) || (skeletonServant = (AbstractSkeletonServant)entity).getTrueOwner() != entityLiving) continue;
                entity.m_20219_(entityLiving.m_20182_());
            }
            for (int i = 0; i < entityLiving.f_19853_.f_46441_.m_188503_(35) + 10; ++i) {
                worldIn.m_8767_((ParticleOptions)ParticleTypes.f_123759_, entityLiving.m_20185_(), entityLiving.m_20188_(), entityLiving.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            }
            worldIn.m_6263_((Player)null, entityLiving.m_20185_(), entityLiving.m_20186_(), entityLiving.m_20189_(), SoundEvents.f_11862_, this.getSoundSource(), 1.0f, 1.0f);
        }
    }

    public boolean specialStaffs(ItemStack stack) {
        return stack.m_150930_((Item)ModItems.FROST_STAFF.get()) || stack.m_150930_((Item)ModItems.WILD_STAFF.get());
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity entityLiving, ItemStack staff) {
        this.commonResult(worldIn, entityLiving);
        int i = 1;
        if (staff.m_150930_((Item)ModItems.NAMELESS_STAFF.get())) {
            i = 7;
        } else if (this.rightStaff(staff)) {
            i = 2 + entityLiving.f_19853_.f_46441_.m_188503_(4);
        } else if (this.specialStaffs(staff)) {
            i = 2;
        }
        if (!this.isShifting(entityLiving)) {
            for (int i1 = 0; i1 < i; ++i1) {
                BlockPos blockPos = BlockFinder.SummonRadius(entityLiving, (Level)worldIn);
                if (entityLiving.m_5842_()) {
                    blockPos = BlockFinder.SummonWaterRadius(entityLiving, (Level)worldIn);
                }
                AbstractSkeletonServant summonedentity = new SkeletonServant((EntityType<? extends AbstractSkeletonServant>)((EntityType)ModEntityType.SKELETON_SERVANT.get()), (Level)worldIn);
                if (this.specialStaffs(staff)) {
                    if (staff.m_150930_((Item)ModItems.FROST_STAFF.get())) {
                        summonedentity = new StrayServant((EntityType<? extends AbstractSkeletonServant>)((EntityType)ModEntityType.STRAY_SERVANT.get()), (Level)worldIn);
                    } else if (staff.m_150930_((Item)ModItems.WILD_STAFF.get())) {
                        summonedentity = new MossySkeletonServant((EntityType<? extends AbstractSkeletonServant>)((EntityType)ModEntityType.MOSSY_SKELETON_SERVANT.get()), (Level)worldIn);
                    }
                } else if (worldIn.m_204166_(blockPos).m_203656_(Tags.Biomes.IS_COLD_OVERWORLD) && worldIn.m_45527_(blockPos)) {
                    summonedentity = new StrayServant((EntityType<? extends AbstractSkeletonServant>)((EntityType)ModEntityType.STRAY_SERVANT.get()), (Level)worldIn);
                } else if (BlockFinder.findStructure(worldIn, entityLiving, (ResourceKey<Structure>)BuiltinStructures.f_209845_)) {
                    summonedentity = new SkeletonPillager((EntityType<? extends AbstractSkeletonServant>)((EntityType)ModEntityType.SKELETON_PILLAGER.get()), (Level)worldIn);
                } else if (worldIn.m_204166_(blockPos).m_203656_(BiomeTags.f_207610_) && worldIn.f_46441_.m_188499_()) {
                    summonedentity = new MossySkeletonServant((EntityType<? extends AbstractSkeletonServant>)((EntityType)ModEntityType.MOSSY_SKELETON_SERVANT.get()), (Level)worldIn);
                } else if (entityLiving.m_5842_() && worldIn.m_46801_(blockPos)) {
                    summonedentity = new SunkenSkeletonServant((EntityType<? extends Summoned>)((EntityType)ModEntityType.SUNKEN_SKELETON_SERVANT.get()), (Level)worldIn);
                }
                summonedentity.setTrueOwner(entityLiving);
                summonedentity.m_20035_(blockPos, 0.0f, 0.0f);
                if (summonedentity.m_6095_() != ModEntityType.SUNKEN_SKELETON_SERVANT.get()) {
                    MobUtil.moveDownToGround((Entity)summonedentity);
                }
                summonedentity.m_21530_();
                summonedentity.setUpgraded(this.NecroPower(entityLiving));
                summonedentity.setLimitedLife(MobUtil.getSummonLifespan((Level)worldIn) * this.duration);
                summonedentity.setArrowPower(this.enchantment);
                summonedentity.m_6518_((ServerLevelAccessor)worldIn, entityLiving.f_19853_.m_6436_(entityLiving.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                this.SummonSap(entityLiving, (LivingEntity)summonedentity);
                this.setTarget(worldIn, entityLiving, (Mob)summonedentity);
                worldIn.m_7967_((Entity)summonedentity);
                this.summonAdvancement(entityLiving, (LivingEntity)summonedentity);
            }
            this.SummonDown(entityLiving);
            worldIn.m_6263_((Player)null, entityLiving.m_20185_(), entityLiving.m_20186_(), entityLiving.m_20189_(), (SoundEvent)ModSounds.SUMMON_SPELL.get(), this.getSoundSource(), 1.0f, 1.0f);
        }
    }
}

