/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.necromancy;

import com.Polarice3.Goety.SpellConfig;
import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.undead.HauntedSkull;
import com.Polarice3.Goety.common.entities.neutral.Minion;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.magic.SummonSpells;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class HauntedSkullSpell
extends SummonSpells {
    public int burning = 0;
    public int radius = 0;

    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.HauntedSkullCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.HauntedSkullDuration.get();
    }

    @Override
    public int SummonDownDuration() {
        return (Integer)SpellConfig.HauntedSkullSummonDown.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.PREPARE_SUMMON.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.HauntedSkullCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.NECROMANCY;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        list.add((Enchantment)ModEnchantments.BURNING.get());
        list.add((Enchantment)ModEnchantments.RADIUS.get());
        return list;
    }

    @Override
    public void commonResult(ServerLevel worldIn, LivingEntity entityLiving) {
        if (WandUtil.enchantedFocus(entityLiving)) {
            this.enchantment = WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), entityLiving);
            this.duration = WandUtil.getLevels((Enchantment)ModEnchantments.DURATION.get(), entityLiving) + 1;
            this.burning = WandUtil.getLevels((Enchantment)ModEnchantments.BURNING.get(), entityLiving);
            this.radius = WandUtil.getLevels((Enchantment)ModEnchantments.RADIUS.get(), entityLiving);
        }
        if (this.isShifting(entityLiving)) {
            for (Entity entity : worldIn.m_8583_()) {
                if (!(entity instanceof HauntedSkull) || ((HauntedSkull)entity).getTrueOwner() != entityLiving) continue;
                entity.m_20219_(entityLiving.m_20182_());
            }
            for (int i = 0; i < entityLiving.f_19853_.f_46441_.m_188503_(35) + 10; ++i) {
                worldIn.m_8767_((ParticleOptions)ParticleTypes.f_123759_, entityLiving.m_20185_(), entityLiving.m_20188_(), entityLiving.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            }
            worldIn.m_6263_((Player)null, entityLiving.m_20185_(), entityLiving.m_20186_(), entityLiving.m_20189_(), SoundEvents.f_11862_, this.getSoundSource(), 1.0f, 1.0f);
        }
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity entityLiving, ItemStack staff) {
        this.commonResult(worldIn, entityLiving);
        if (!this.isShifting(entityLiving)) {
            int i = 1;
            if (this.rightStaff(staff) || staff.m_150930_((Item)ModItems.NAMELESS_STAFF.get())) {
                i = 3;
            }
            for (int i1 = 0; i1 < i; ++i1) {
                BlockPos blockpos = entityLiving.m_20183_().m_7918_(-2 + entityLiving.m_217043_().m_188503_(5), 1, -2 + entityLiving.m_217043_().m_188503_(5));
                HauntedSkull summonedentity = new HauntedSkull((EntityType<? extends Minion>)((EntityType)ModEntityType.HAUNTED_SKULL.get()), (Level)worldIn);
                summonedentity.setTrueOwner(entityLiving);
                summonedentity.m_20035_(blockpos, 0.0f, 0.0f);
                summonedentity.m_6518_((ServerLevelAccessor)worldIn, entityLiving.f_19853_.m_6436_(blockpos), MobSpawnType.MOB_SUMMONED, null, null);
                summonedentity.setBoundOrigin(blockpos);
                summonedentity.setLimitedLife(MathHelper.minutesToTicks(1) * this.duration);
                if (this.enchantment > 0) {
                    int boost = Mth.m_14045_((int)(this.enchantment - 1), (int)0, (int)10);
                    summonedentity.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.BUFF.get(), Integer.MAX_VALUE, boost));
                }
                if (this.radius > 0) {
                    summonedentity.setExplosionPower(1.0f + (float)this.radius / 4.0f);
                }
                if (this.burning > 0) {
                    summonedentity.setBurning(this.burning);
                }
                this.setTarget(worldIn, entityLiving, (Mob)summonedentity);
                summonedentity.setUpgraded(this.NecroPower(entityLiving));
                worldIn.m_7967_((Entity)summonedentity);
                this.summonAdvancement(entityLiving, (LivingEntity)summonedentity);
            }
            worldIn.m_6263_((Player)null, entityLiving.m_20185_(), entityLiving.m_20186_(), entityLiving.m_20189_(), SoundEvents.f_11862_, this.getSoundSource(), 1.0f, 1.0f);
        }
    }
}

