/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.geomancy;

import com.Polarice3.Goety.SpellConfig;
import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.neutral.Volcano;
import com.Polarice3.Goety.common.magic.Spells;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class EruptionSpell
extends Spells {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.EruptionCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.EruptionDuration.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.GEOMANCY;
    }

    @Override
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.PREPARE_SPELL.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.EruptionCoolDown.get();
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RANGE.get());
        list.add((Enchantment)ModEnchantments.RADIUS.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        list.add((Enchantment)ModEnchantments.BURNING.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity entityLiving, ItemStack staff) {
        int range = 16;
        int radius = 0;
        int potency = 0;
        int duration = 1;
        int burning = 0;
        if (WandUtil.enchantedFocus(entityLiving)) {
            range += WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), entityLiving);
            radius += WandUtil.getLevels((Enchantment)ModEnchantments.RADIUS.get(), entityLiving);
            potency += WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), entityLiving);
            duration += WandUtil.getLevels((Enchantment)ModEnchantments.DURATION.get(), entityLiving);
            burning += WandUtil.getLevels((Enchantment)ModEnchantments.BURNING.get(), entityLiving);
        }
        HitResult rayTraceResult = this.rayTrace((Level)worldIn, entityLiving, range, 3.0);
        BlockPos blockPos = entityLiving.m_20183_();
        if (rayTraceResult instanceof EntityHitResult) {
            EntityHitResult hitResult = (EntityHitResult)rayTraceResult;
            Entity target = hitResult.m_82443_();
            blockPos = target.m_20183_();
        } else if (rayTraceResult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)rayTraceResult;
            blockPos = blockHitResult.m_82425_().m_7494_();
        }
        Volcano volcano = (Volcano)((EntityType)ModEntityType.VOLCANO.get()).m_20615_((Level)worldIn);
        if (volcano != null) {
            volcano.setTrueOwner(entityLiving);
            volcano.m_6034_((double)blockPos.m_123341_() + 0.5, blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5);
            volcano.m_6518_((ServerLevelAccessor)worldIn, worldIn.m_6436_(blockPos), MobSpawnType.MOB_SUMMONED, null, null);
            volcano.setExplosionPower(volcano.getExplosionPower() + (float)radius / 2.0f);
            volcano.setLifeSpan(6 * duration);
            volcano.setPotency(potency);
            volcano.setFlaming(burning);
            worldIn.m_7967_((Entity)volcano);
        }
    }
}

