/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.frost;

import com.Polarice3.Goety.SpellConfig;
import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.projectiles.IceSpike;
import com.Polarice3.Goety.common.magic.Spells;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;

public class IceSpikeSpell
extends Spells {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.IceSpikeCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.IceSpikeDuration.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.ICE_SPIKE_CAST.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.IceSpikeCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.FROST;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity entityLiving, ItemStack staff) {
        float enchantment = 0.0f;
        if (WandUtil.enchantedFocus(entityLiving)) {
            enchantment = (float)WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), entityLiving) / 3.0f;
        }
        IceSpike iceSpike = new IceSpike(entityLiving, (Level)worldIn);
        iceSpike.m_37251_((Entity)entityLiving, entityLiving.m_146909_(), entityLiving.m_146908_(), 0.0f, 1.6f + enchantment, 1.0f);
        iceSpike.m_5602_((Entity)entityLiving);
        worldIn.m_7967_((Entity)iceSpike);
        worldIn.m_6263_(null, entityLiving.m_20185_(), entityLiving.m_20186_(), entityLiving.m_20189_(), (SoundEvent)ModSounds.CAST_SPELL.get(), this.getSoundSource(), 1.0f, 1.0f);
    }
}

