/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.frost;

import com.Polarice3.Goety.SpellConfig;
import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.projectiles.HailCloud;
import com.Polarice3.Goety.common.magic.Spells;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class HailSpell
extends Spells {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.HailCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.HailDuration.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.PREPARE_SPELL.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.HailCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.FROST;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RANGE.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        list.add((Enchantment)ModEnchantments.RADIUS.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity entityLiving, ItemStack staff) {
        HitResult rayTraceResult;
        int range = 16;
        int duration = 100;
        double radius = 2.0;
        float damage = 0.0f;
        if (WandUtil.enchantedFocus(entityLiving)) {
            range += WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), entityLiving);
            duration *= WandUtil.getLevels((Enchantment)ModEnchantments.DURATION.get(), entityLiving) + 1;
            damage += (float)WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), entityLiving);
            radius += (double)WandUtil.getLevels((Enchantment)ModEnchantments.RADIUS.get(), entityLiving);
        }
        if ((rayTraceResult = this.rayTrace((Level)worldIn, entityLiving, range, radius)) instanceof EntityHitResult) {
            Entity target = ((EntityHitResult)rayTraceResult).m_82443_();
            if (target instanceof LivingEntity) {
                HailCloud hailCloud = new HailCloud((Level)worldIn, entityLiving, (LivingEntity)target);
                hailCloud.setExtraDamage(damage);
                hailCloud.setRadius((float)radius);
                hailCloud.setLifeSpan(duration);
                worldIn.m_7967_((Entity)hailCloud);
            }
            worldIn.m_6263_(null, entityLiving.m_20185_(), entityLiving.m_20186_(), entityLiving.m_20189_(), SoundEvents.f_144205_, this.getSoundSource(), 1.0f, 1.0f);
        } else if (rayTraceResult instanceof BlockHitResult) {
            BlockPos blockPos = ((BlockHitResult)rayTraceResult).m_82425_();
            HailCloud hailCloud = new HailCloud((Level)worldIn, entityLiving, null);
            hailCloud.setExtraDamage(damage);
            hailCloud.setRadius((float)radius);
            hailCloud.setLifeSpan(duration);
            hailCloud.m_6034_((float)blockPos.m_123341_() + 0.5f, blockPos.m_123342_() + 4, (float)blockPos.m_123343_() + 0.5f);
            worldIn.m_7967_((Entity)hailCloud);
            worldIn.m_6263_(null, entityLiving.m_20185_(), entityLiving.m_20186_(), entityLiving.m_20189_(), SoundEvents.f_144205_, this.getSoundSource(), 1.0f, 1.0f);
        }
    }
}

