/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.frost;

import com.Polarice3.Goety.SpellConfig;
import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.magic.BreathingSpells;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FrostedIceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;

public class FrostBreathSpell
extends BreathingSpells {
    public float damage = ((Double)SpellConfig.FrostBreathDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();

    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.FrostBreathCost.get();
    }

    @Override
    public int defaultCastUp() {
        return (Integer)SpellConfig.FrostBreathChargeUp.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return null;
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.FROST;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RANGE.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity entityLiving, ItemStack staff) {
        Player player;
        float enchantment = 0.0f;
        int duration = 1;
        int range = 0;
        if (entityLiving instanceof Player && WandUtil.enchantedFocus((LivingEntity)(player = (Player)entityLiving))) {
            enchantment = WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), (LivingEntity)player);
            duration += WandUtil.getLevels((Enchantment)ModEnchantments.DURATION.get(), (LivingEntity)player);
            range = WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), (LivingEntity)player);
        }
        float damage = this.damage + enchantment;
        if (!worldIn.f_46443_) {
            if (CuriosFinder.hasCurio(entityLiving, (Item)ModItems.RING_OF_THE_DRAGON.get())) {
                damage *= 2.0f;
                if (((Boolean)SpellConfig.DragonFrostGriefing.get()).booleanValue()) {
                    float flameRange = 0.2617994f;
                    for (int i = 0; i < 3; ++i) {
                        Vec3 cast = entityLiving.m_20154_().m_82541_().m_82496_(worldIn.f_46441_.m_188501_() * flameRange * 2.0f - flameRange).m_82524_(worldIn.f_46441_.m_188501_() * flameRange * 2.0f - flameRange);
                        BlockHitResult hitResult = worldIn.m_45547_(new ClipContext(entityLiving.m_146892_(), entityLiving.m_146892_().m_82549_(cast.m_82490_(10.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entityLiving));
                        if (hitResult.m_6662_() != HitResult.Type.BLOCK) continue;
                        Vec3 pos = hitResult.m_82450_().m_82546_(cast.m_82490_(0.5));
                        BlockPos blockPos = BlockPos.m_274561_((double)pos.f_82479_, (double)pos.f_82480_, (double)pos.f_82481_);
                        if ((worldIn.m_8055_(blockPos).m_60795_() || BlockFinder.canBeReplaced((Level)worldIn, blockPos) && worldIn.m_6425_(blockPos).m_76178_()) && worldIn.m_8055_(blockPos.m_7495_()).m_60804_((BlockGetter)worldIn, blockPos.m_7495_())) {
                            worldIn.m_46597_(blockPos, Blocks.f_50125_.m_49966_());
                        }
                        BlockState blockstate = Blocks.f_50449_.m_49966_();
                        if (worldIn.m_8055_(blockPos) != FrostedIceBlock.m_278844_() || !blockstate.m_60710_((LevelReader)worldIn, blockPos) || !worldIn.m_45752_(blockstate, blockPos, CollisionContext.m_82749_()) || ForgeEventFactory.onBlockPlace((Entity)entityLiving, (BlockSnapshot)BlockSnapshot.create((ResourceKey)worldIn.m_46472_(), (LevelAccessor)worldIn, (BlockPos)blockPos), (Direction)Direction.UP)) continue;
                        worldIn.m_46597_(blockPos, blockstate);
                        worldIn.m_186460_(blockPos, Blocks.f_50449_, Mth.m_216271_((RandomSource)entityLiving.m_217043_(), (int)60, (int)120));
                    }
                }
            }
            for (Entity target : this.getTarget(entityLiving, range + 15)) {
                if (target == null || !(target instanceof LivingEntity)) continue;
                LivingEntity livingTarget = (LivingEntity)target;
                if (target.m_6095_().m_204039_(EntityTypeTags.f_144295_)) {
                    damage *= 2.0f;
                }
                if (!livingTarget.m_6469_(ModDamageSource.frostBreath((Entity)entityLiving, (Entity)entityLiving), damage)) continue;
                livingTarget.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.FREEZING.get(), MathHelper.secondsToTicks(1) * duration));
            }
        }
        worldIn.m_6263_(null, entityLiving.m_20185_(), entityLiving.m_20186_(), entityLiving.m_20189_(), SoundEvents.f_12320_, this.getSoundSource(), worldIn.f_46441_.m_188501_() * 0.5f, worldIn.f_46441_.m_188501_() * 0.5f);
    }

    @Override
    public void showWandBreath(LivingEntity entityLiving) {
        Player player;
        int range = 0;
        if (entityLiving instanceof Player && WandUtil.enchantedFocus((LivingEntity)(player = (Player)entityLiving))) {
            range = WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), (LivingEntity)player);
        }
        if (!CuriosFinder.hasCurio(entityLiving, (Item)ModItems.RING_OF_THE_DRAGON.get())) {
            this.breathAttack((ParticleOptions)ParticleTypes.f_123759_, entityLiving, (double)0.3f + (double)range / 10.0, 5.0);
        } else {
            this.dragonBreathAttack((ParticleOptions)ModParticleTypes.FROST.get(), entityLiving, (double)0.3f + (double)range / 10.0);
        }
    }
}

