/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells;

import com.Polarice3.Goety.SpellConfig;
import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.AllyIrk;
import com.Polarice3.Goety.common.entities.ally.AllyVex;
import com.Polarice3.Goety.common.entities.neutral.Minion;
import com.Polarice3.Goety.common.magic.SummonSpells;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class VexSpell
extends SummonSpells {
    private final TargetingConditions vexCountTargeting = TargetingConditions.f_26872_.m_26883_(16.0).m_26893_();

    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.VexCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.VexDuration.get();
    }

    @Override
    public int SummonDownDuration() {
        return (Integer)SpellConfig.VexSummonDown.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return SoundEvents.f_11868_;
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.VexCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.ILL;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        return list;
    }

    @Override
    public ColorUtil particleColors(LivingEntity entityLiving) {
        return new ColorUtil(0.7f, 0.7f, 0.8f);
    }

    @Override
    public void commonResult(ServerLevel worldIn, LivingEntity entityLiving) {
        if (WandUtil.enchantedFocus(entityLiving)) {
            this.enchantment = WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), entityLiving);
            this.duration = WandUtil.getLevels((Enchantment)ModEnchantments.DURATION.get(), entityLiving) + 1;
        }
        if (this.isShifting(entityLiving)) {
            for (Entity entity : worldIn.m_8583_()) {
                Minion minion;
                if (!(entity instanceof Minion) || !((minion = (Minion)entity) instanceof AllyVex) && !(minion instanceof AllyIrk) || minion.getTrueOwner() != entityLiving) continue;
                if (minion instanceof AllyIrk) {
                    entityLiving.m_5634_(2.0f);
                }
                entity.m_6074_();
            }
            for (int i = 0; i < entityLiving.f_19853_.f_46441_.m_188503_(35) + 10; ++i) {
                worldIn.m_8767_((ParticleOptions)ParticleTypes.f_123759_, entityLiving.m_20185_(), entityLiving.m_20188_(), entityLiving.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            }
            worldIn.m_6263_((Player)null, entityLiving.m_20185_(), entityLiving.m_20186_(), entityLiving.m_20189_(), SoundEvents.f_11862_, this.getSoundSource(), 1.0f, 1.0f);
        }
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity entityLiving, ItemStack staff) {
        this.commonResult(worldIn, entityLiving);
        if (!this.isShifting(entityLiving)) {
            int i = 3;
            if (this.rightStaff(staff)) {
                i = 3 + worldIn.f_46441_.m_188503_(3);
            }
            for (int i1 = 0; i1 < i; ++i1) {
                BlockPos blockpos = entityLiving.m_20183_().m_7918_(-2 + entityLiving.m_217043_().m_188503_(5), 1, -2 + entityLiving.m_217043_().m_188503_(5));
                AllyVex vexentity = new AllyVex((EntityType<? extends Minion>)((EntityType)ModEntityType.ALLY_VEX.get()), (Level)worldIn);
                vexentity.setTrueOwner(entityLiving);
                vexentity.m_20035_(blockpos, 0.0f, 0.0f);
                vexentity.m_6518_((ServerLevelAccessor)worldIn, entityLiving.f_19853_.m_6436_(blockpos), MobSpawnType.MOB_SUMMONED, null, null);
                vexentity.setBoundOrigin(blockpos);
                int limit = this.rightStaff(staff) ? (Integer)SpellConfig.StaffVexLimit.get() : (Integer)SpellConfig.WandVexLimit.get();
                if (limit > this.VexLimit(entityLiving)) {
                    vexentity.setLimitedLife(MobUtil.getSummonLifespan((Level)worldIn) * this.duration);
                } else {
                    vexentity.setLimitedLife(1);
                    vexentity.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 800, 1));
                }
                if (this.enchantment > 0) {
                    Map map = EnchantmentHelper.m_44831_((ItemStack)vexentity.m_21205_());
                    map.putIfAbsent(Enchantments.f_44977_, this.enchantment);
                    EnchantmentHelper.m_44865_((Map)map, (ItemStack)vexentity.m_21205_());
                    vexentity.m_8061_(EquipmentSlot.MAINHAND, vexentity.m_21205_());
                }
                this.SummonSap(entityLiving, (LivingEntity)vexentity);
                this.setTarget(worldIn, entityLiving, (Mob)vexentity);
                worldIn.m_7967_((Entity)vexentity);
                this.summonAdvancement(entityLiving, (LivingEntity)vexentity);
            }
            worldIn.m_6263_((Player)null, entityLiving.m_20185_(), entityLiving.m_20186_(), entityLiving.m_20189_(), SoundEvents.f_11862_, this.getSoundSource(), 1.0f, 1.0f);
            this.SummonDown(entityLiving);
        }
    }

    public int VexLimit(LivingEntity entityLiving) {
        return entityLiving.f_19853_.m_45971_(AllyVex.class, this.vexCountTargeting, entityLiving, entityLiving.m_20191_().m_82400_(16.0)).size();
    }
}

