/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells;

import com.Polarice3.Goety.SpellConfig;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.magic.EverChargeSpells;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.SEHelper;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class TelekinesisSpell
extends EverChargeSpells {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.TelekinesisCost.get();
    }

    @Override
    public int defaultCastUp() {
        return (Integer)SpellConfig.TelekinesisChargeUp.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.PREPARE_SPELL.get();
    }

    @Override
    public boolean conditionsMet(ServerLevel worldIn, LivingEntity entityLiving) {
        if (entityLiving.f_20916_ > 0) {
            if (entityLiving instanceof Player) {
                Player player = (Player)entityLiving;
                player.m_5810_();
                SEHelper.addCooldown(player, (Item)ModItems.TELEKINESIS_FOCUS.get(), MathHelper.secondsToTicks(5));
                SEHelper.sendSEUpdatePacket(player);
            }
            return false;
        }
        return true;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RANGE.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity entityLiving, ItemStack staff) {
        Entity target;
        double potency = 1.0;
        int range = 16;
        if (WandUtil.enchantedFocus(entityLiving)) {
            potency += (double)WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), entityLiving) / 2.0;
            range += WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), entityLiving);
        }
        if ((target = MobUtil.getSingleTarget((Level)worldIn, entityLiving, range, 3.0, EntitySelector.f_20406_)) != null && entityLiving.m_20191_().m_82400_(0.5).m_82309_() * potency >= target.m_20191_().m_82309_()) {
            LivingEntity livingTarget;
            boolean flag = true;
            if (target instanceof LivingEntity && ((livingTarget = (LivingEntity)target).m_21233_() >= (float)((Integer)SpellConfig.TelekinesisMaxHealth.get()).intValue() || MobUtil.hasEntityTypesConfig((List)SpellConfig.TelekinesisBlackList.get(), livingTarget.m_6095_()))) {
                flag = false;
            }
            if (flag) {
                Vec3 lookVec = entityLiving.m_20154_();
                double x = entityLiving.m_20185_() + lookVec.f_82479_ * 1.6 - target.m_20185_();
                double y = entityLiving.m_20188_() + lookVec.f_82480_ * 1.6 - target.m_20186_();
                double z = entityLiving.m_20189_() + lookVec.f_82481_ * 1.6 - target.m_20189_();
                double offset = 0.1;
                target.m_20334_(x * offset, y * offset, z * offset);
                target.m_6478_(MoverType.SELF, target.m_20184_());
                if (CuriosFinder.hasCurio(entityLiving, (Item)ModItems.RING_OF_FORCE.get())) {
                    target.m_20301_(Math.max(-20, target.m_20146_() - 10));
                    if (target.m_20146_() <= -20) {
                        target.m_20301_(0);
                        target.m_6469_(ModDamageSource.choke((Entity)entityLiving, (Entity)entityLiving), 2.0f);
                    }
                }
                ServerParticleUtil.addParticlesAroundSelf(worldIn, (ParticleOptions)ParticleTypes.f_123760_, target);
            }
        }
    }
}

