/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells;

import com.Polarice3.Goety.SpellConfig;
import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.projectiles.SwordProjectile;
import com.Polarice3.Goety.common.magic.Spells;
import com.Polarice3.Goety.utils.ItemHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;

public class SwordSpell
extends Spells {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.SwordCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.SwordDuration.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return SoundEvents.f_11821_;
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.SwordCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.ILL;
    }

    @Override
    public boolean conditionsMet(ServerLevel worldIn, LivingEntity entityLiving) {
        return entityLiving.m_21205_().m_41720_() instanceof SwordItem || entityLiving.m_21206_().m_41720_() instanceof SwordItem;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity entityLiving, ItemStack staff) {
        float enchantment = 0.0f;
        if (WandUtil.enchantedFocus(entityLiving)) {
            enchantment = (float)WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), entityLiving) / 3.0f;
        }
        if (entityLiving.m_21205_().m_41720_() instanceof SwordItem || entityLiving.m_21206_().m_41720_() instanceof SwordItem) {
            ItemStack sword = entityLiving.m_21205_().m_41720_() instanceof SwordItem ? entityLiving.m_21205_() : entityLiving.m_21206_();
            SwordProjectile swordProjectile = new SwordProjectile(entityLiving, (Level)worldIn, sword);
            swordProjectile.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
            swordProjectile.m_37251_((Entity)entityLiving, entityLiving.m_146909_(), entityLiving.m_146908_(), 0.0f, 1.6f + enchantment, 1.0f);
            swordProjectile.m_5602_((Entity)entityLiving);
            if (worldIn.m_7967_((Entity)swordProjectile) && MobUtil.validEntity((Entity)entityLiving)) {
                ItemHelper.hurtAndBreak(sword, 10, entityLiving);
            }
            worldIn.m_6263_(null, entityLiving.m_20185_(), entityLiving.m_20186_(), entityLiving.m_20189_(), this.CastingSound(), this.getSoundSource(), 1.0f, 1.0f);
        } else {
            worldIn.m_6263_(null, entityLiving.m_20185_(), entityLiving.m_20186_(), entityLiving.m_20189_(), SoundEvents.f_11937_, this.getSoundSource(), 1.0f, 1.0f);
        }
    }
}

