/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells;

import com.Polarice3.Goety.SpellConfig;
import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.Spells;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class FangSpell
extends Spells {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.FangCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.FangDuration.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return SoundEvents.f_11867_;
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.FangCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.ILL;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RANGE.get());
        list.add((Enchantment)ModEnchantments.BURNING.get());
        list.add((Enchantment)ModEnchantments.ABSORB.get());
        if ((Integer)SpellConfig.FangGainSouls.get() > 0) {
            list.add((Enchantment)ModEnchantments.SOUL_EATER.get());
        }
        return list;
    }

    @Override
    public ColorUtil particleColors(LivingEntity entityLiving) {
        return new ColorUtil(0.4f, 0.3f, 0.35f);
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity entityLiving, ItemStack staff) {
        Player playerEntity = (Player)entityLiving;
        int range = 16;
        double radius = 2.0;
        if (WandUtil.enchantedFocus(entityLiving)) {
            range += WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), entityLiving);
        }
        HitResult rayTraceResult = this.rayTrace((Level)worldIn, (LivingEntity)playerEntity, range, radius);
        Vec3 vector3d = rayTraceResult.m_82450_();
        double d0 = Math.min(vector3d.f_82480_, entityLiving.m_20186_());
        double d1 = Math.max(vector3d.f_82480_, entityLiving.m_20186_()) + 1.0;
        float f = (float)Mth.m_14136_((double)(vector3d.f_82481_ - entityLiving.m_20189_()), (double)(vector3d.f_82479_ - entityLiving.m_20185_()));
        if (rayTraceResult instanceof EntityHitResult) {
            Entity target = ((EntityHitResult)rayTraceResult).m_82443_();
            d0 = Math.min(target.m_20186_(), entityLiving.m_20186_());
            d1 = Math.max(target.m_20186_(), entityLiving.m_20186_()) + 1.0;
            f = (float)Mth.m_14136_((double)(target.m_20189_() - entityLiving.m_20189_()), (double)(target.m_20185_() - entityLiving.m_20185_()));
        }
        if (!this.isShifting(entityLiving)) {
            for (int l = 0; l < range; ++l) {
                double d2 = 1.25 * (double)(l + 1);
                WandUtil.spawnFangs(entityLiving, entityLiving.m_20185_() + (double)Mth.m_14089_((float)f) * d2, entityLiving.m_20189_() + (double)Mth.m_14031_((float)f) * d2, d0, d1, f, l);
                if (!this.rightStaff(staff)) continue;
                float fleft = f + 0.2f;
                float fright = f - 0.2f;
                WandUtil.spawnFangs(entityLiving, entityLiving.m_20185_() + (double)Mth.m_14089_((float)fleft) * d2, entityLiving.m_20189_() + (double)Mth.m_14031_((float)fleft) * d2, d0, d1, fleft, l);
                WandUtil.spawnFangs(entityLiving, entityLiving.m_20185_() + (double)Mth.m_14089_((float)fright) * d2, entityLiving.m_20189_() + (double)Mth.m_14031_((float)fright) * d2, d0, d1, fright, l);
            }
        } else {
            float f2;
            int k;
            for (int i = 0; i < 5; ++i) {
                float f1 = f + (float)i * (float)Math.PI * 0.4f;
                WandUtil.spawnFangs(entityLiving, entityLiving.m_20185_() + (double)Mth.m_14089_((float)f1) * 1.5, entityLiving.m_20189_() + (double)Mth.m_14031_((float)f1) * 1.5, d0, d1, f1, 0);
            }
            for (k = 0; k < 8; ++k) {
                f2 = f + (float)k * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                WandUtil.spawnFangs(entityLiving, entityLiving.m_20185_() + (double)Mth.m_14089_((float)f2) * 2.5, entityLiving.m_20189_() + (double)Mth.m_14031_((float)f2) * 2.5, d0, d1, f2, 3);
            }
            if (this.rightStaff(staff)) {
                for (k = 0; k < 11; ++k) {
                    f2 = f + (float)k * (float)Math.PI * 4.0f / 16.0f + 2.5133462f;
                    WandUtil.spawnFangs(entityLiving, entityLiving.m_20185_() + (double)Mth.m_14089_((float)f2) * 3.5, entityLiving.m_20189_() + (double)Mth.m_14031_((float)f2) * 3.5, d0, d1, f2, 6);
                }
                for (k = 0; k < 14; ++k) {
                    f2 = f + (float)k * (float)Math.PI * 8.0f / 32.0f + 5.0266924f;
                    WandUtil.spawnFangs(entityLiving, entityLiving.m_20185_() + (double)Mth.m_14089_((float)f2) * 4.5, entityLiving.m_20189_() + (double)Mth.m_14031_((float)f2) * 4.5, d0, d1, f2, 9);
                }
            }
        }
        worldIn.m_6263_((Player)null, entityLiving.m_20185_(), entityLiving.m_20186_(), entityLiving.m_20189_(), SoundEvents.f_11862_, this.getSoundSource(), 1.0f, 1.0f);
    }
}

