/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells;

import com.Polarice3.Goety.SpellConfig;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.Spells;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.SEHelper;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;

public class BulwarkSpell
extends Spells {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.BulwarkCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.BulwarkDuration.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.PREPARE_SPELL.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.BulwarkCoolDown.get();
    }

    @Override
    public boolean conditionsMet(ServerLevel worldIn, LivingEntity entityLiving) {
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            return SEHelper.getShields(player) <= 0;
        }
        return false;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity entityLiving, ItemStack staff) {
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            int amount = (Integer)SpellConfig.BulwarkShieldAmount.get();
            int duration = (Integer)SpellConfig.BulwarkShieldTime.get();
            if (WandUtil.enchantedFocus(entityLiving)) {
                amount += WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), entityLiving);
                duration *= Math.min(4, WandUtil.getLevels((Enchantment)ModEnchantments.DURATION.get(), entityLiving) + 1);
            }
            SEHelper.setShields(player, amount);
            SEHelper.setShieldTime(player, duration);
            worldIn.m_6263_(null, entityLiving.m_20185_(), entityLiving.m_20186_(), entityLiving.m_20189_(), (SoundEvent)ModSounds.SHIELD_UP.get(), this.getSoundSource(), 3.0f, entityLiving.m_6100_());
        }
    }
}

