/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.construct;

import com.Polarice3.Goety.SpellConfig;
import com.Polarice3.Goety.api.magic.IMold;
import com.Polarice3.Goety.common.blocks.ModBlocks;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.undead.GraveGolem;
import com.Polarice3.Goety.common.research.ResearchList;
import com.Polarice3.Goety.init.ModTags;
import com.Polarice3.Goety.utils.SEHelper;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class GraveGolemMold
implements IMold {
    private static final List<BlockPos> SOUL_SAND_LOCATIONS = ImmutableList.of((Object)new BlockPos(1, -1, 1), (Object)new BlockPos(1, -1, -1), (Object)new BlockPos(-1, -1, 1), (Object)new BlockPos(-1, -1, -1));
    private static final List<BlockPos> COARSE_DIRT_LOCATIONS = ImmutableList.of((Object)new BlockPos(0, -1, 2), (Object)new BlockPos(1, -1, 2), (Object)new BlockPos(-1, -1, 2), (Object)new BlockPos(2, -1, -2), (Object)new BlockPos(2, -1, -1), (Object)new BlockPos(2, -1, 0), (Object)new BlockPos(2, -1, 1), (Object)new BlockPos(2, -1, 2), (Object)new BlockPos(-2, -1, -2), (Object)new BlockPos(-2, -1, -1), (Object)new BlockPos(-2, -1, 0), (Object)new BlockPos(-2, -1, 1), (Object[])new BlockPos[]{new BlockPos(-2, -1, 2), new BlockPos(0, -1, -2), new BlockPos(1, -1, -2), new BlockPos(-1, -1, -2)});
    private static final List<BlockPos> DARK_METAL_LOCATIONS = ImmutableList.of((Object)new BlockPos(-3, 0, 3), (Object)new BlockPos(3, 0, 3), (Object)new BlockPos(3, 0, -3), (Object)new BlockPos(-3, 0, -3));
    private static final List<BlockPos> SHADE_STONE_LOCATIONS = ImmutableList.of((Object)new BlockPos(0, -1, 0), (Object)new BlockPos(0, -1, 1), (Object)new BlockPos(0, -1, -1), (Object)new BlockPos(1, -1, 0), (Object)new BlockPos(-1, -1, 0), (Object)new BlockPos(0, 0, 2), (Object)new BlockPos(1, 0, 2), (Object)new BlockPos(-1, 0, 2), (Object)new BlockPos(2, 0, -2), (Object)new BlockPos(2, 0, -1), (Object)new BlockPos(2, 0, 0), (Object)new BlockPos(2, 0, 1), (Object[])new BlockPos[]{new BlockPos(2, 0, 2), new BlockPos(-2, 0, -2), new BlockPos(-2, 0, -1), new BlockPos(-2, 0, 0), new BlockPos(-2, 0, 1), new BlockPos(-2, 0, 2), new BlockPos(0, 0, -2), new BlockPos(1, 0, -2), new BlockPos(-1, 0, -2)});
    private static final List<BlockPos> STONE_BRICKS_LOCATIONS = ImmutableList.of((Object)new BlockPos(0, 0, 3), (Object)new BlockPos(1, 0, 3), (Object)new BlockPos(-1, 0, 3), (Object)new BlockPos(3, 0, -2), (Object)new BlockPos(3, 0, -1), (Object)new BlockPos(3, 0, 0), (Object)new BlockPos(3, 0, 1), (Object)new BlockPos(3, 0, 2), (Object)new BlockPos(-3, 0, -2), (Object)new BlockPos(-3, 0, -1), (Object)new BlockPos(-3, 0, 0), (Object)new BlockPos(-3, 0, 1), (Object[])new BlockPos[]{new BlockPos(-3, 0, 2), new BlockPos(0, 0, -3), new BlockPos(1, 0, -3), new BlockPos(-1, 0, -3)});
    private static final List<BlockPos> SKULL_PILE_LOCATIONS = ImmutableList.of((Object)new BlockPos(-1, 0, 0), (Object)new BlockPos(0, 0, -1), (Object)new BlockPos(0, 0, 0), (Object)new BlockPos(0, 0, 1), (Object)new BlockPos(1, 0, 0));
    private static final List<BlockPos> BONE_LOCATIONS = ImmutableList.of((Object)new BlockPos(1, 0, 1), (Object)new BlockPos(-1, 0, 1), (Object)new BlockPos(1, 0, -1), (Object)new BlockPos(-1, 0, -1));

    private static List<BlockPos> checkSoulSand(Level level, BlockPos blockPos) {
        ArrayList<BlockPos> invalid = new ArrayList<BlockPos>();
        for (BlockPos blockPos1 : SOUL_SAND_LOCATIONS) {
            BlockPos blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
            if (level.m_8055_(blockPos2).m_204336_(BlockTags.f_13085_)) continue;
            invalid.add(blockPos1);
        }
        return invalid;
    }

    private static List<BlockPos> checkBones(Level level, BlockPos blockPos) {
        ArrayList<BlockPos> invalid = new ArrayList<BlockPos>();
        for (BlockPos blockPos1 : BONE_LOCATIONS) {
            BlockPos blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
            if (level.m_8055_(blockPos2).m_60713_(Blocks.f_50453_)) continue;
            invalid.add(blockPos1);
        }
        return invalid;
    }

    private static List<BlockPos> checkCoarseDirt(Level level, BlockPos blockPos) {
        ArrayList<BlockPos> invalid = new ArrayList<BlockPos>();
        for (BlockPos blockPos1 : COARSE_DIRT_LOCATIONS) {
            BlockPos blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
            if (level.m_8055_(blockPos2).m_60713_(Blocks.f_50546_)) continue;
            invalid.add(blockPos1);
        }
        return invalid;
    }

    private static List<BlockPos> checkDarkMetals(Level level, BlockPos blockPos) {
        ArrayList<BlockPos> invalid = new ArrayList<BlockPos>();
        for (BlockPos blockPos1 : DARK_METAL_LOCATIONS) {
            BlockPos blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
            if (level.m_8055_(blockPos2).m_60713_((Block)ModBlocks.DARK_METAL_BLOCK.get())) continue;
            invalid.add(blockPos1);
        }
        return invalid;
    }

    private static List<BlockPos> checkStones(Level level, BlockPos blockPos) {
        ArrayList<BlockPos> invalid = new ArrayList<BlockPos>();
        for (BlockPos blockPos1 : STONE_BRICKS_LOCATIONS) {
            BlockPos blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
            BlockState blockState = level.m_8055_(blockPos2);
            if (!blockState.m_60734_().m_7705_().contains("bricks")) {
                invalid.add(blockPos1);
            }
            if (blockState.m_60838_((BlockGetter)level, blockPos2)) continue;
            invalid.add(blockPos1);
        }
        return invalid;
    }

    private static List<BlockPos> checkShadeStone(Level level, BlockPos blockPos) {
        ArrayList<BlockPos> invalid = new ArrayList<BlockPos>();
        for (BlockPos blockPos1 : SHADE_STONE_LOCATIONS) {
            BlockPos blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
            if (level.m_8055_(blockPos2).m_204336_(ModTags.Blocks.SHADE_STONE)) continue;
            invalid.add(blockPos1);
        }
        return invalid;
    }

    private static List<BlockPos> checkSkullPiles(Level level, BlockPos blockPos) {
        ArrayList<BlockPos> invalid = new ArrayList<BlockPos>();
        for (BlockPos blockPos1 : SKULL_PILE_LOCATIONS) {
            BlockPos blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
            if (level.m_8055_(blockPos2).m_60713_((Block)ModBlocks.SKULL_PILE.get())) continue;
            invalid.add(blockPos1);
        }
        return invalid;
    }

    public static boolean checkBlocks(Level level, BlockPos blockPos) {
        return GraveGolemMold.checkSoulSand(level, blockPos).isEmpty() && GraveGolemMold.checkBones(level, blockPos).isEmpty() && GraveGolemMold.checkCoarseDirt(level, blockPos).isEmpty() && GraveGolemMold.checkDarkMetals(level, blockPos).isEmpty() && GraveGolemMold.checkShadeStone(level, blockPos).isEmpty() && GraveGolemMold.checkSkullPiles(level, blockPos).isEmpty() && GraveGolemMold.checkStones(level, blockPos).isEmpty();
    }

    @Override
    public boolean spawnServant(Player player, ItemStack stack, Level level, BlockPos blockPos) {
        if (!level.f_46443_ && level.m_8055_(blockPos).m_60713_((Block)ModBlocks.SKULL_PILE.get())) {
            if (GraveGolemMold.checkBlocks(level, blockPos)) {
                if (SEHelper.hasResearch(player, ResearchList.WARRED) && SEHelper.hasResearch(player, ResearchList.HAUNTING)) {
                    if (SEHelper.getSpecificSummons(player, (EntityType)ModEntityType.GRAVE_GOLEM.get()).size() < (Integer)SpellConfig.GraveGolemLimit.get()) {
                        GraveGolem graveGolem = (GraveGolem)((EntityType)ModEntityType.GRAVE_GOLEM.get()).m_20615_(level);
                        if (graveGolem != null) {
                            graveGolem.m_6518_((ServerLevelAccessor)level, level.m_6436_(graveGolem.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                            graveGolem.setTrueOwner((LivingEntity)player);
                            graveGolem.m_7678_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.05, (double)blockPos.m_123343_() + 0.5, 0.0f, 0.0f);
                            if (level.m_7967_((Entity)graveGolem)) {
                                GraveGolemMold.removeBlocks(level, blockPos);
                                stack.m_41774_(1);
                                SEHelper.addSummon(player, (LivingEntity)graveGolem);
                                if (player instanceof ServerPlayer) {
                                    ServerPlayer serverPlayer = (ServerPlayer)player;
                                    CriteriaTriggers.f_10580_.m_68256_(serverPlayer, (Entity)graveGolem);
                                }
                                return true;
                            }
                        }
                    } else {
                        player.m_5661_((Component)Component.m_237115_((String)"info.goety.summon.limit"), true);
                    }
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"info.goety.research.fail"), true);
                }
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"info.goety.block.fail"), true);
            }
        }
        return false;
    }

    public static void removeBlocks(Level level, BlockPos blockPos) {
        if (!level.f_46443_) {
            BlockPos blockPos2;
            for (BlockPos blockPos1 : COARSE_DIRT_LOCATIONS) {
                blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
                if (!level.m_8055_(blockPos2).m_60713_(Blocks.f_50546_)) continue;
                level.m_46796_(2001, blockPos2, Block.m_49956_((BlockState)level.m_8055_(blockPos2)));
                level.m_46597_(blockPos2, Blocks.f_50493_.m_49966_());
            }
            for (BlockPos blockPos1 : SOUL_SAND_LOCATIONS) {
                blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
                if (!level.m_8055_(blockPos2).m_204336_(BlockTags.f_13085_)) continue;
                level.m_46796_(2001, blockPos2, Block.m_49956_((BlockState)level.m_8055_(blockPos2)));
                level.m_46597_(blockPos2, Blocks.f_49992_.m_49966_());
            }
            for (BlockPos blockPos1 : SHADE_STONE_LOCATIONS) {
                blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
                if (!level.m_8055_(blockPos2).m_204336_(ModTags.Blocks.SHADE_STONE)) continue;
                level.m_46796_(2001, blockPos2, Block.m_49956_((BlockState)level.m_8055_(blockPos2)));
                level.m_46597_(blockPos2, Blocks.f_50016_.m_49966_());
            }
            for (BlockPos blockPos1 : BONE_LOCATIONS) {
                blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
                if (!level.m_8055_(blockPos2).m_60713_(Blocks.f_50453_)) continue;
                level.m_46796_(2001, blockPos2, Block.m_49956_((BlockState)level.m_8055_(blockPos2)));
                level.m_46597_(blockPos2, Blocks.f_50016_.m_49966_());
            }
            for (BlockPos blockPos1 : SKULL_PILE_LOCATIONS) {
                blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
                if (!level.m_8055_(blockPos2).m_60713_((Block)ModBlocks.SKULL_PILE.get())) continue;
                level.m_46796_(2001, blockPos2, Block.m_49956_((BlockState)level.m_8055_(blockPos2)));
                level.m_46597_(blockPos2, Blocks.f_50016_.m_49966_());
            }
        }
    }
}

