/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.items.magic;

import com.Polarice3.Goety.api.items.magic.IFocus;
import com.Polarice3.Goety.api.magic.ISpell;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;

public class MagicFocus
extends Item
implements IFocus {
    public ISpell spell;
    public int soulCost;

    public MagicFocus(ISpell spell) {
        super(new Item.Properties().m_41497_(Rarity.UNCOMMON).setNoRepair().m_41487_(1));
        this.spell = spell;
        this.soulCost = spell.defaultSoulCost();
    }

    public boolean m_8120_(ItemStack pStack) {
        return pStack.m_41613_() == 1;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 1;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        MagicFocus magicFocus;
        Item item = stack.m_41720_();
        if (item instanceof MagicFocus && (magicFocus = (MagicFocus)item).getSpell() != null && !magicFocus.getSpell().acceptedEnchantments().isEmpty()) {
            return magicFocus.getSpell().acceptedEnchantments().contains(enchantment);
        }
        return false;
    }

    @Override
    public ISpell getSpell() {
        return this.spell;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (this.soulCost != 0) {
            tooltip.add((Component)Component.m_237110_((String)"info.goety.focus.cost", (Object[])new Object[]{this.soulCost}));
        } else {
            tooltip.add((Component)Component.m_237110_((String)"info.goety.focus.cost", (Object[])new Object[]{0}));
        }
        tooltip.add((Component)Component.m_237110_((String)"info.goety.focus.spellType", (Object[])new Object[]{this.spell.getSpellType().getName()}));
        tooltip.add((Component)Component.m_237115_((String)"item.goety.focus.info").m_130940_(ChatFormatting.BLUE).m_130940_(ChatFormatting.UNDERLINE));
        tooltip.add((Component)Component.m_237115_((String)(this.m_5524_() + ".info")).m_130940_(ChatFormatting.GRAY));
    }
}

