/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.items.magic;

import com.Polarice3.Goety.MobsConfig;
import com.Polarice3.Goety.SpellConfig;
import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.api.entities.ally.IServant;
import com.Polarice3.Goety.api.items.magic.IFocus;
import com.Polarice3.Goety.api.magic.IBlockSpell;
import com.Polarice3.Goety.api.magic.IBreathingSpell;
import com.Polarice3.Goety.api.magic.IChargingSpell;
import com.Polarice3.Goety.api.magic.ISpell;
import com.Polarice3.Goety.api.magic.ITouchSpell;
import com.Polarice3.Goety.common.blocks.entities.ArcaBlockEntity;
import com.Polarice3.Goety.common.blocks.entities.BrewCauldronBlockEntity;
import com.Polarice3.Goety.common.entities.neutral.AbstractVine;
import com.Polarice3.Goety.common.events.GoetyEventFactory;
import com.Polarice3.Goety.common.items.capability.SoulUsingItemCapability;
import com.Polarice3.Goety.common.items.handler.SoulUsingItemHandler;
import com.Polarice3.Goety.common.items.magic.CallFocus;
import com.Polarice3.Goety.common.items.magic.CommandFocus;
import com.Polarice3.Goety.common.items.magic.RecallFocus;
import com.Polarice3.Goety.common.magic.spells.void_spells.RecallSpell;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SPlayEntitySoundPacket;
import com.Polarice3.Goety.common.network.server.SPlayPlayerSoundPacket;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.init.ModTags;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.SEHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.gossip.GossipType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class DarkWand
extends Item {
    private static final String SOULUSE = "Soul Use";
    private static final String CASTTIME = "Cast Time";
    private static final String SOULCOST = "Soul Cost";
    private static final String DURATION = "Duration";
    private static final String COOLDOWN = "Cooldown";
    private static final String COOL = "Cool";
    private static final String SECONDS = "Seconds";

    public DarkWand() {
        super(new Item.Properties().m_41487_(1).setNoRepair().m_41497_(Rarity.RARE));
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entityIn;
            CompoundTag compound = stack.m_41784_();
            if (stack.m_41783_() == null) {
                compound.m_128405_(SOULUSE, this.SoulUse(livingEntity, stack));
                compound.m_128405_(SOULCOST, 0);
                compound.m_128405_(CASTTIME, this.CastDuration(stack));
                compound.m_128405_(COOL, 0);
                compound.m_128405_(SECONDS, 0);
            }
            if (this.getSpell(stack) != null) {
                this.setSpellConditions(this.getSpell(stack), stack, livingEntity);
            } else {
                this.setSpellConditions(null, stack, livingEntity);
            }
            compound.m_128405_(SOULUSE, this.SoulUse(livingEntity, stack));
            compound.m_128405_(CASTTIME, this.CastDuration(stack));
            if (DarkWand.getFocus(stack) != null) {
                DarkWand.getFocus(stack).m_41666_(worldIn, entityIn, itemSlot, isSelected);
            }
        }
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public void m_7836_(ItemStack pStack, Level pLevel, Player pPlayer) {
        CompoundTag compound = pStack.m_41784_();
        compound.m_128405_(SOULUSE, this.SoulUse((LivingEntity)pPlayer, pStack));
        compound.m_128405_(SOULCOST, 0);
        compound.m_128405_(CASTTIME, this.CastDuration(pStack));
        compound.m_128405_(COOL, 0);
        compound.m_128405_(SECONDS, 0);
        this.setSpellConditions(null, pStack, (LivingEntity)pPlayer);
    }

    public int SoulUse(LivingEntity entityLiving, ItemStack stack) {
        if (DarkWand.getFocus(stack).m_41793_()) {
            return (int)((float)(this.SoulCost(stack) * 2) * SEHelper.soulDiscount(entityLiving));
        }
        return (int)((float)this.SoulCost(stack) * SEHelper.soulDiscount(entityLiving));
    }

    public boolean cannotCast(LivingEntity livingEntity, ItemStack stack) {
        boolean flag = false;
        Level level = livingEntity.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.getSpell(stack) != null && !this.getSpell(stack).conditionsMet(serverLevel, livingEntity)) {
                flag = true;
            }
        }
        return this.isOnCooldown(livingEntity, stack) || flag;
    }

    public boolean isOnCooldown(LivingEntity livingEntity, ItemStack stack) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (DarkWand.getFocus(stack) != null) {
                Item item = DarkWand.getFocus(stack).m_41720_();
                return SEHelper.getFocusCoolDown(player).isOnCooldown(item);
            }
        }
        return false;
    }

    public boolean isNotInstant(ISpell spells) {
        return spells != null && spells.defaultCastDuration() > 0;
    }

    public boolean notTouch(ISpell spells) {
        return !(spells instanceof ITouchSpell) && !(spells instanceof IBlockSpell);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        IOwned owned1;
        LivingEntity livingEntity;
        IOwned owned;
        LivingEntity target;
        if (!player.f_19853_.f_46443_ && entity instanceof LivingEntity && (target = (LivingEntity)entity) instanceof IOwned && ((owned = (IOwned)target).getTrueOwner() == player || (livingEntity = owned.getTrueOwner()) instanceof IOwned && (owned1 = (IOwned)livingEntity).getTrueOwner() == player)) {
            CompoundTag compoundTag;
            if (DarkWand.getFocus(stack).m_41720_() instanceof CallFocus && !CallFocus.hasSummon(DarkWand.getFocus(stack))) {
                compoundTag = new CompoundTag();
                if (DarkWand.getFocus(stack).m_41782_()) {
                    compoundTag = DarkWand.getFocus(stack).m_41783_();
                }
                CallFocus.setSummon(compoundTag, target);
                DarkWand.getFocus(stack).m_41751_(compoundTag);
                player.m_5496_(SoundEvents.f_11686_, 1.0f, 0.45f);
                ModNetwork.sendTo(player, new SPlayPlayerSoundPacket(SoundEvents.f_11686_, 1.0f, 0.45f));
                return true;
            }
            if (DarkWand.getFocus(stack).m_41720_() instanceof CommandFocus && owned instanceof IServant && !CommandFocus.hasServant(DarkWand.getFocus(stack))) {
                compoundTag = new CompoundTag();
                if (DarkWand.getFocus(stack).m_41782_()) {
                    compoundTag = DarkWand.getFocus(stack).m_41783_();
                }
                CommandFocus.setServant(compoundTag, target);
                DarkWand.getFocus(stack).m_41751_(compoundTag);
                player.m_5496_(SoundEvents.f_11686_, 1.0f, 0.45f);
                ModNetwork.sendTo(player, new SPlayPlayerSoundPacket(SoundEvents.f_11686_, 1.0f, 0.45f));
                return true;
            }
            if (((Boolean)SpellConfig.OwnerHitCommand.get()).booleanValue()) {
                if (owned instanceof IServant) {
                    IServant summonedEntity = (IServant)owned;
                    if (player.m_6144_() || player.m_6047_()) {
                        entity.m_6074_();
                        return true;
                    }
                    if (summonedEntity.canUpdateMove()) {
                        summonedEntity.updateMoveMode(player);
                        return true;
                    }
                } else if (owned instanceof AbstractVine) {
                    AbstractVine vine = (AbstractVine)owned;
                    if (player.m_6144_() || player.m_6047_()) {
                        vine.m_6074_();
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Nonnull
    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        Object owned;
        LivingEntity livingEntity;
        IServant summonedEntity;
        IServant summoned;
        LivingEntity livingEntity2;
        if (DarkWand.getFocus(stack).m_41720_() instanceof CommandFocus && (livingEntity2 = CommandFocus.getServant(DarkWand.getFocus(stack))) instanceof IServant && (summoned = (IServant)livingEntity2) != target && summoned.getTrueOwner() == player && target.m_20270_((Entity)player) <= 64.0f) {
            summoned.setCommandPosEntity(target);
            player.m_5496_((SoundEvent)ModSounds.COMMAND.get(), 1.0f, 0.45f);
            if (!player.f_19853_.f_46443_) {
                ModNetwork.sendTo(player, new SPlayPlayerSoundPacket((SoundEvent)ModSounds.COMMAND.get(), 1.0f, 0.45f));
            }
            return InteractionResult.SUCCESS;
        }
        if (!((Boolean)SpellConfig.OwnerHitCommand.get()).booleanValue() && target instanceof IServant && ((summonedEntity = (IServant)target).getTrueOwner() == player || (livingEntity = summonedEntity.getTrueOwner()) instanceof IOwned && (owned = (IOwned)livingEntity).getTrueOwner() == player)) {
            if (player.m_6144_() || player.m_6047_()) {
                target.m_6074_();
            } else if (summonedEntity.canUpdateMove()) {
                summonedEntity.updateMoveMode(player);
            }
            return InteractionResult.SUCCESS;
        }
        owned = this.getSpell(stack);
        if (owned instanceof ITouchSpell) {
            ITouchSpell touchSpells = (ITouchSpell)owned;
            if (this.canCastTouch(stack, player.f_19853_, (LivingEntity)player) && (livingEntity = player.f_19853_) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)livingEntity;
                touchSpells.touchResult(serverLevel, (LivingEntity)player, target);
            }
        }
        return super.m_6880_(stack, player, target, hand);
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        Level level = pContext.m_43725_();
        BlockPos blockpos = pContext.m_8083_();
        Player player = pContext.m_43723_();
        ItemStack stack = pContext.m_43722_();
        if (player != null) {
            BlockEntity blockEntity;
            Item item = DarkWand.getFocus(stack).m_41720_();
            if (item instanceof RecallFocus) {
                RecallFocus recallFocus = (RecallFocus)item;
                CompoundTag compoundTag = DarkWand.getFocus(stack).m_41784_();
                if (!RecallFocus.hasRecall(DarkWand.getFocus(stack))) {
                    BlockState blockstate;
                    BlockEntity tileEntity = level.m_7702_(blockpos);
                    if (tileEntity instanceof ArcaBlockEntity) {
                        ArcaBlockEntity arcaTile = (ArcaBlockEntity)tileEntity;
                        if (pContext.m_43723_() == arcaTile.getPlayer() && arcaTile.m_58904_() != null) {
                            recallFocus.addRecallTags((ResourceKey<Level>)arcaTile.m_58904_().m_46472_(), arcaTile.m_58899_(), compoundTag);
                            DarkWand.getFocus(stack).m_41751_(compoundTag);
                            player.m_5496_(SoundEvents.f_11686_, 1.0f, 0.45f);
                            if (!level.f_46443_) {
                                ModNetwork.sendTo(player, new SPlayPlayerSoundPacket(SoundEvents.f_11686_, 1.0f, 0.45f));
                            }
                            return InteractionResult.m_19078_((boolean)level.f_46443_);
                        }
                    }
                    if ((blockstate = level.m_8055_(blockpos)).m_204336_(ModTags.Blocks.RECALL_BLOCKS)) {
                        recallFocus.addRecallTags((ResourceKey<Level>)level.m_46472_(), blockpos, compoundTag);
                        DarkWand.getFocus(stack).m_41751_(compoundTag);
                        player.m_5496_(SoundEvents.f_11686_, 1.0f, 0.45f);
                        if (!level.f_46443_) {
                            ModNetwork.sendTo(player, new SPlayPlayerSoundPacket(SoundEvents.f_11686_, 1.0f, 0.45f));
                        }
                        return InteractionResult.m_19078_((boolean)level.f_46443_);
                    }
                }
            } else if (DarkWand.getFocus(stack).m_41720_() instanceof CommandFocus) {
                LivingEntity tileEntity;
                if (CommandFocus.hasServant(DarkWand.getFocus(stack)) && (tileEntity = CommandFocus.getServant(DarkWand.getFocus(stack))) instanceof IServant) {
                    summoned = (IServant)tileEntity;
                    LivingEntity livingEntity = CommandFocus.getServant(DarkWand.getFocus(stack));
                    if (livingEntity != null && summoned.getTrueOwner() == player && livingEntity.m_20270_((Entity)player) <= 64.0f) {
                        BlockPos above = blockpos.m_7494_();
                        boolean flag = false;
                        if (!level.m_8055_(blockpos).m_60804_((BlockGetter)level, blockpos)) {
                            summoned.setCommandPos(blockpos);
                            flag = true;
                        } else if (!level.m_8055_(above).m_60804_((BlockGetter)level, above)) {
                            summoned.setCommandPos(above);
                            flag = true;
                        }
                        if (flag) {
                            player.m_5496_((SoundEvent)ModSounds.COMMAND.get(), 1.0f, 0.45f);
                            if (!level.f_46443_) {
                                ModNetwork.sendTo(player, new SPlayPlayerSoundPacket((SoundEvent)ModSounds.COMMAND.get(), 1.0f, 0.45f));
                            }
                            return InteractionResult.m_19078_((boolean)level.f_46443_);
                        }
                    }
                }
            } else {
                summoned = this.getSpell(stack);
                if (summoned instanceof IBlockSpell) {
                    ServerLevel serverLevel;
                    IBlockSpell blockSpells = (IBlockSpell)summoned;
                    Level level2 = player.f_19853_;
                    if (level2 instanceof ServerLevel && blockSpells.rightBlock(serverLevel = (ServerLevel)level2, (LivingEntity)player, blockpos)) {
                        if (this.canCastTouch(stack, level, (LivingEntity)player)) {
                            blockSpells.blockResult(serverLevel, (LivingEntity)player, blockpos);
                        }
                        return InteractionResult.SUCCESS;
                    }
                }
            }
            if (!level.f_46443_ && (blockEntity = level.m_7702_(blockpos)) instanceof BrewCauldronBlockEntity) {
                BrewCauldronBlockEntity cauldronBlock = (BrewCauldronBlockEntity)blockEntity;
                if (MobUtil.isShifting((Entity)player) && stack.m_41720_() instanceof DarkWand) {
                    cauldronBlock.fullReset();
                    level.m_5594_(null, blockpos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.m_5594_(null, blockpos, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return super.m_6225_(pContext);
    }

    public void m_5929_(Level worldIn, LivingEntity livingEntityIn, ItemStack stack, int count) {
        if (this.cannotCast(livingEntityIn, stack)) {
            return;
        }
        int CastTime = stack.m_41779_() - count;
        if (this.getSpell(stack) != null && this.isNotInstant(this.getSpell(stack))) {
            ISpell iSpell;
            SoundEvent soundevent = this.CastingSound(stack);
            if (CastTime == 1 && soundevent != null) {
                worldIn.m_6263_(null, livingEntityIn.m_20185_(), livingEntityIn.m_20186_(), livingEntityIn.m_20189_(), soundevent, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
            if (this.getSpell(stack) instanceof RecallSpell) {
                for (int i = 0; i < 2; ++i) {
                    worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123760_, livingEntityIn.m_20208_(0.5), livingEntityIn.m_20187_() - 0.25, livingEntityIn.m_20262_(0.5), (worldIn.f_46441_.m_188500_() - 0.5) * 2.0, -worldIn.f_46441_.m_188500_(), (worldIn.f_46441_.m_188500_() - 0.5) * 2.0);
                }
            } else {
                IChargingSpell spell;
                iSpell = this.getSpell(stack);
                if (iSpell instanceof IChargingSpell && (spell = (IChargingSpell)iSpell).defaultCastUp() > 0) {
                    this.useParticles(worldIn, livingEntityIn, this.getSpell(stack));
                } else if (!(this.getSpell(stack) instanceof IChargingSpell)) {
                    this.useParticles(worldIn, livingEntityIn, this.getSpell(stack));
                }
            }
            iSpell = this.getSpell(stack);
            if (iSpell instanceof IChargingSpell) {
                Player player;
                IChargingSpell spell = (IChargingSpell)iSpell;
                if (stack.m_41783_() != null && (CastTime == spell.defaultCastUp() || spell.defaultCastUp() <= 0)) {
                    stack.m_41783_().m_128405_(COOL, stack.m_41783_().m_128451_(COOL) + 1);
                    if (stack.m_41783_().m_128451_(COOL) > this.Cooldown(stack)) {
                        stack.m_41783_().m_128405_(COOL, 0);
                        this.MagicResults(stack, worldIn, livingEntityIn);
                    }
                }
                if (livingEntityIn instanceof Player && !SEHelper.getSoulsAmount(player = (Player)livingEntityIn, this.getSpell(stack).soulCost((LivingEntity)player)) && !player.m_7500_()) {
                    player.m_5810_();
                }
            }
        }
    }

    public int m_8105_(ItemStack stack) {
        if (stack.m_41783_() != null) {
            return stack.m_41783_().m_128451_(CASTTIME);
        }
        return this.CastDuration(stack);
    }

    @Nonnull
    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.CUSTOM;
    }

    @Nonnull
    public ItemStack m_5922_(ItemStack stack, Level worldIn, LivingEntity entityLiving) {
        super.m_5922_(stack, worldIn, entityLiving);
        if (this.getSpell(stack) != null && (!(this.getSpell(stack) instanceof IChargingSpell) || this.isNotInstant(this.getSpell(stack)) || this.notTouch(this.getSpell(stack)))) {
            this.MagicResults(stack, worldIn, entityLiving);
        }
        if (stack.m_41783_() != null && stack.m_41783_().m_128451_(COOL) > 0) {
            stack.m_41783_().m_128405_(COOL, 0);
        }
        return stack;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        if (DarkWand.getFocus(itemstack).m_41720_() instanceof CommandFocus && playerIn.m_6047_()) {
            if (CommandFocus.hasServant(DarkWand.getFocus(itemstack)) && DarkWand.getFocus(itemstack).m_41783_() != null) {
                DarkWand.getFocus(itemstack).m_41783_().m_128473_("Servant");
                playerIn.m_5496_(SoundEvents.f_11686_, 1.0f, 0.45f);
                if (!worldIn.f_46443_) {
                    ModNetwork.sendTo(playerIn, new SPlayEntitySoundPacket(playerIn.m_20148_(), SoundEvents.f_11686_, 1.0f, 0.45f));
                }
            }
            return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)worldIn.m_5776_());
        }
        if (this.getSpell(itemstack) != null) {
            if (this.cannotCast((LivingEntity)playerIn, itemstack)) {
                return InteractionResultHolder.m_19098_((Object)itemstack);
            }
            if (this.isNotInstant(this.getSpell(itemstack))) {
                if ((SEHelper.getSoulsAmount(playerIn, this.getSpell(itemstack).soulCost((LivingEntity)playerIn)) || playerIn.m_150110_().f_35937_) && !worldIn.f_46443_) {
                    playerIn.m_6672_(handIn);
                }
            } else if (this.notTouch(this.getSpell(itemstack))) {
                playerIn.m_6674_(handIn);
                this.MagicResults(itemstack, worldIn, (LivingEntity)playerIn);
            }
        }
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public void useParticles(Level worldIn, LivingEntity livingEntity, ISpell iSpell) {
        double d0 = worldIn.f_46441_.m_188583_() * 0.2;
        double d1 = worldIn.f_46441_.m_188583_() * 0.2;
        double d2 = worldIn.f_46441_.m_188583_() * 0.2;
        if (iSpell != null) {
            d0 = iSpell.particleColors(livingEntity).red();
            d1 = iSpell.particleColors(livingEntity).green();
            d2 = iSpell.particleColors(livingEntity).blue();
        }
        worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123811_, livingEntity.m_20185_(), livingEntity.m_20191_().f_82292_ + 0.5, livingEntity.m_20189_(), d0, d1, d2);
    }

    public void setSpellConditions(@Nullable ISpell spell, ItemStack stack, LivingEntity livingEntity) {
        if (stack.m_41783_() != null) {
            if (spell != null) {
                stack.m_41783_().m_128405_(SOULCOST, spell.soulCost(livingEntity));
                stack.m_41783_().m_128405_(DURATION, spell.castDuration(livingEntity));
                if (spell instanceof IChargingSpell) {
                    stack.m_41783_().m_128405_(COOLDOWN, ((IChargingSpell)spell).Cooldown());
                } else {
                    stack.m_41783_().m_128405_(COOLDOWN, 0);
                }
            } else {
                stack.m_41783_().m_128405_(SOULCOST, 0);
                stack.m_41783_().m_128405_(DURATION, 0);
                stack.m_41783_().m_128405_(COOLDOWN, 0);
            }
        }
    }

    public ISpell getSpell(ItemStack stack) {
        if (DarkWand.getMagicFocus(stack) != null && DarkWand.getMagicFocus(stack).getSpell() != null) {
            return DarkWand.getMagicFocus(stack).getSpell();
        }
        return null;
    }

    public int SoulCost(ItemStack itemStack) {
        if (itemStack.m_41783_() == null) {
            return 0;
        }
        return itemStack.m_41783_().m_128451_(SOULCOST);
    }

    public int CastDuration(ItemStack itemStack) {
        if (itemStack.m_41783_() != null) {
            return itemStack.m_41783_().m_128451_(DURATION);
        }
        return 0;
    }

    public int Cooldown(ItemStack itemStack) {
        if (itemStack.m_41783_() != null) {
            return itemStack.m_41783_().m_128451_(COOLDOWN);
        }
        return 0;
    }

    @Nullable
    public SoundEvent CastingSound(ItemStack stack) {
        if (this.getSpell(stack) != null) {
            return this.getSpell(stack).CastingSound();
        }
        return null;
    }

    public static ItemStack getFocus(ItemStack itemstack) {
        SoulUsingItemHandler handler = SoulUsingItemHandler.get(itemstack);
        return handler.getSlot();
    }

    public static IFocus getMagicFocus(ItemStack itemStack) {
        Item item;
        if (DarkWand.getFocus(itemStack) != null && !DarkWand.getFocus(itemStack).m_41619_() && (item = DarkWand.getFocus(itemStack).m_41720_()) instanceof IFocus) {
            IFocus magicFocus = (IFocus)item;
            return magicFocus;
        }
        return null;
    }

    public boolean canCastTouch(ItemStack stack, Level worldIn, LivingEntity caster) {
        Player playerEntity = (Player)caster;
        if (!worldIn.f_46443_ && this.getSpell(stack) != null && !this.cannotCast(caster, stack)) {
            if (playerEntity.m_7500_()) {
                SEHelper.addCooldown(playerEntity, DarkWand.getFocus(stack).m_41720_(), this.getSpell(stack).spellCooldown());
                return stack.m_41783_() != null;
            }
            if (SEHelper.getSoulsAmount(playerEntity, this.SoulUse(caster, stack)) && stack.m_41783_() != null) {
                SEHelper.decreaseSouls(playerEntity, this.SoulUse(caster, stack));
                SEHelper.addCooldown(playerEntity, DarkWand.getFocus(stack).m_41720_(), this.getSpell(stack).spellCooldown());
                SEHelper.sendSEUpdatePacket(playerEntity);
                return true;
            }
        }
        return false;
    }

    public void MagicResults(ItemStack stack, Level worldIn, LivingEntity caster) {
        Player playerEntity = (Player)caster;
        if (this.getSpell(stack) != null) {
            ISpell spell = GoetyEventFactory.onCastSpell(caster, this.getSpell(stack));
            if (spell != null) {
                if (!worldIn.f_46443_) {
                    ServerLevel serverWorld = (ServerLevel)worldIn;
                    if (playerEntity.m_7500_()) {
                        if (stack.m_41783_() != null) {
                            this.getSpell(stack).SpellResult(serverWorld, caster, stack);
                            SEHelper.addCooldown(playerEntity, DarkWand.getFocus(stack).m_41720_(), this.getSpell(stack).spellCooldown());
                        }
                    } else if (SEHelper.getSoulsAmount(playerEntity, this.SoulUse(caster, stack))) {
                        IChargingSpell spell1;
                        boolean spent = true;
                        ISpell iSpell = this.getSpell(stack);
                        if (iSpell instanceof IChargingSpell && (spell1 = (IChargingSpell)iSpell).everCharge() && stack.m_41783_() != null) {
                            stack.m_41783_().m_128405_(SECONDS, stack.m_41783_().m_128451_(SECONDS) + 1);
                            if (stack.m_41783_().m_128451_(SECONDS) != 20) {
                                spent = false;
                            } else {
                                stack.m_41783_().m_128405_(SECONDS, 0);
                            }
                        }
                        if (spent) {
                            SEHelper.decreaseSouls(playerEntity, this.SoulUse(caster, stack));
                            SEHelper.sendSEUpdatePacket(playerEntity);
                            if ((Integer)MobsConfig.VillagerHateSpells.get() > 0) {
                                for (Villager villager : caster.f_19853_.m_45976_(Villager.class, caster.m_20191_().m_82400_(16.0))) {
                                    if (!villager.m_142582_((Entity)caster)) continue;
                                    villager.m_35517_().m_26191_(caster.m_20148_(), GossipType.MINOR_NEGATIVE, ((Integer)MobsConfig.VillagerHateSpells.get()).intValue());
                                }
                            }
                        }
                        if (stack.m_41783_() != null) {
                            this.getSpell(stack).SpellResult(serverWorld, caster, stack);
                            SEHelper.addCooldown(playerEntity, DarkWand.getFocus(stack).m_41720_(), this.getSpell(stack).spellCooldown());
                        }
                    } else {
                        worldIn.m_6263_(null, caster.m_20185_(), caster.m_20186_(), caster.m_20189_(), SoundEvents.f_11937_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    }
                }
                if (worldIn.f_46443_) {
                    if (playerEntity.m_7500_()) {
                        ISpell iSpell = this.getSpell(stack);
                        if (iSpell instanceof IBreathingSpell) {
                            breathingSpells = (IBreathingSpell)iSpell;
                            breathingSpells.showWandBreath(caster);
                        }
                    } else if (SEHelper.getSoulsAmount(playerEntity, this.SoulUse(caster, stack))) {
                        ISpell iSpell = this.getSpell(stack);
                        if (iSpell instanceof IBreathingSpell) {
                            breathingSpells = (IBreathingSpell)iSpell;
                            breathingSpells.showWandBreath(caster);
                        }
                    } else {
                        this.failParticles(worldIn, caster);
                    }
                }
            } else {
                this.failParticles(worldIn, caster);
                worldIn.m_6263_(null, caster.m_20185_(), caster.m_20186_(), caster.m_20189_(), SoundEvents.f_11937_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
        } else {
            this.failParticles(worldIn, caster);
            worldIn.m_6263_(null, caster.m_20185_(), caster.m_20186_(), caster.m_20189_(), SoundEvents.f_11937_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
    }

    public void failParticles(Level worldIn, LivingEntity entityLiving) {
        for (int i = 0; i < entityLiving.f_19853_.f_46441_.m_188503_(35) + 10; ++i) {
            double d = worldIn.f_46441_.m_188583_() * 0.2;
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123796_, entityLiving.m_20185_(), entityLiving.m_20188_(), entityLiving.m_20189_(), d, d, d);
        }
    }

    private static IItemHandler getItemHandler(ItemStack itemStack) {
        return (IItemHandler)itemStack.getCapability(ForgeCapabilities.ITEM_HANDLER).orElseThrow(() -> new IllegalArgumentException("Expected an item handler for the Magic Focus item, but " + itemStack + " does not expose an item handler."));
    }

    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag nbt;
        IItemHandler iitemHandler = DarkWand.getItemHandler(stack);
        CompoundTag compoundTag = nbt = stack.m_41783_() != null ? stack.m_41783_() : new CompoundTag();
        if (iitemHandler instanceof ItemStackHandler) {
            ItemStackHandler itemHandler = (ItemStackHandler)iitemHandler;
            nbt.m_128365_("cap", (Tag)itemHandler.serializeNBT());
        }
        return nbt;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
        if (nbt == null) {
            stack.m_41751_(null);
        } else {
            IItemHandler iitemHandler = DarkWand.getItemHandler(stack);
            if (iitemHandler instanceof ItemStackHandler) {
                ItemStackHandler itemHandler = (ItemStackHandler)iitemHandler;
                itemHandler.deserializeNBT(nbt.m_128469_("cap"));
            }
            stack.m_41751_(nbt);
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged) && slotChanged;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, @Nullable CompoundTag nbt) {
        return new SoulUsingItemCapability(stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (stack.m_41783_() != null) {
            int SoulUse = stack.m_41783_().m_128451_(SOULUSE);
            tooltip.add((Component)Component.m_237110_((String)"info.goety.wand.cost", (Object[])new Object[]{SoulUse}));
            if (this.getSpell(stack) != null) {
                if (this.isNotInstant(this.getSpell(stack)) && !(this.getSpell(stack) instanceof IChargingSpell)) {
                    int CastTime = stack.m_41783_().m_128451_(CASTTIME);
                    tooltip.add((Component)Component.m_237110_((String)"info.goety.wand.castTime", (Object[])new Object[]{Float.valueOf((float)CastTime / 20.0f)}));
                }
                if (this.getSpell(stack).spellCooldown() > 0) {
                    tooltip.add((Component)Component.m_237110_((String)"info.goety.wand.coolDown", (Object[])new Object[]{Float.valueOf((float)this.getSpell(stack).spellCooldown() / 20.0f)}));
                }
            }
        } else {
            tooltip.add((Component)Component.m_237110_((String)"info.goety.wand.cost", (Object[])new Object[]{this.SoulCost(stack)}));
        }
        if (!DarkWand.getFocus(stack).m_41619_()) {
            tooltip.add((Component)Component.m_237110_((String)"info.goety.wand.focus", (Object[])new Object[]{DarkWand.getFocus(stack).m_41720_().m_41466_()}));
            if (DarkWand.getFocus(stack).m_41720_() instanceof RecallFocus) {
                ItemStack recallFocus = DarkWand.getFocus(stack);
                RecallFocus.addRecallText(recallFocus, tooltip);
            }
        } else {
            tooltip.add((Component)Component.m_237110_((String)"info.goety.wand.focus", (Object[])new Object[]{"Empty"}));
        }
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientItemExtensions(){
            private static final HumanoidModel.ArmPose WAND_POSE = HumanoidModel.ArmPose.create((String)"WAND", (boolean)false, (model, entity, arm) -> {
                float f5 = entity.f_267362_.m_267590_(Minecraft.m_91087_().getPartialTick());
                if (arm == HumanoidArm.RIGHT) {
                    model.f_102811_.f_104203_ -= MathHelper.modelDegrees(105.0f);
                    model.f_102811_.f_104205_ = Mth.m_14089_((float)(f5 * 0.6662f)) * 0.25f;
                    model.f_102812_.f_104203_ += MathHelper.modelDegrees(25.0f);
                } else {
                    model.f_102812_.f_104203_ -= MathHelper.modelDegrees(105.0f);
                    model.f_102812_.f_104205_ = -Mth.m_14089_((float)(f5 * 0.6662f)) * 0.25f;
                    model.f_102811_.f_104203_ += MathHelper.modelDegrees(25.0f);
                }
            });

            public HumanoidModel.ArmPose getArmPose(LivingEntity entityLiving, InteractionHand hand, ItemStack itemStack) {
                if (!itemStack.m_41619_() && itemStack.m_41720_() instanceof DarkWand && entityLiving.m_7655_() == hand && entityLiving.m_21212_() > 0) {
                    return WAND_POSE;
                }
                return HumanoidModel.ArmPose.EMPTY;
            }

            public boolean applyForgeHandTransform(PoseStack poseStack, LocalPlayer player, HumanoidArm arm, ItemStack itemInHand, float partialTick, float equipProcess, float swingProcess) {
                int i;
                int n = i = arm == HumanoidArm.RIGHT ? 1 : -1;
                if (player.m_6117_()) {
                    this.applyItemArmTransform(poseStack, arm, equipProcess);
                    poseStack.m_85837_((double)((float)i * -0.2785682f), 0.18344387412071228, 0.15731531381607056);
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(-13.935f));
                    poseStack.m_252781_(Axis.f_252436_.m_252977_((float)i * 35.3f));
                    poseStack.m_252781_(Axis.f_252403_.m_252977_((float)i * -9.785f));
                    float f8 = (float)itemInHand.m_41779_() - ((float)player.m_21212_() - partialTick + 1.0f);
                    float f12 = f8 / 20.0f;
                    f12 = (f12 * f12 + f12 * 2.0f) / 3.0f;
                    if (f12 > 1.0f) {
                        f12 = 1.0f;
                    }
                    if (f12 > 0.1f) {
                        float f15 = Mth.m_14031_((float)((f8 - 0.1f) * 1.3f));
                        float f18 = f12 - 0.1f;
                        float f20 = f15 * f18;
                        poseStack.m_85837_((double)(f20 * 0.0f), (double)(f20 * 0.004f), (double)(f20 * 0.0f));
                    }
                    poseStack.m_85837_((double)(f12 * 0.0f), (double)(f12 * 0.0f), (double)(f12 * 0.04f));
                    poseStack.m_85841_(1.0f, 1.0f, 1.0f + f12 * 0.2f);
                    poseStack.m_252781_(Axis.f_252392_.m_252977_((float)i * 45.0f));
                } else {
                    float f5 = -0.4f * Mth.m_14031_((float)(Mth.m_14116_((float)swingProcess) * (float)Math.PI));
                    float f6 = 0.2f * Mth.m_14031_((float)(Mth.m_14116_((float)swingProcess) * ((float)Math.PI * 2)));
                    float f10 = -0.2f * Mth.m_14031_((float)(swingProcess * (float)Math.PI));
                    poseStack.m_85837_((double)((float)i * f5), (double)f6, (double)f10);
                    this.applyItemArmTransform(poseStack, arm, equipProcess);
                    this.applyItemArmAttackTransform(poseStack, arm, swingProcess);
                }
                return true;
            }

            private void applyItemArmTransform(PoseStack poseStack, HumanoidArm arm, float equipProcess) {
                int i = arm == HumanoidArm.RIGHT ? 1 : -1;
                poseStack.m_85837_((double)((float)i * 0.56f), (double)(-0.52f + equipProcess * -0.6f), (double)-0.72f);
            }

            private void applyItemArmAttackTransform(PoseStack poseStack, HumanoidArm humanoidArm, float swingProcess) {
                int i = humanoidArm == HumanoidArm.RIGHT ? 1 : -1;
                float f = Mth.m_14031_((float)(swingProcess * swingProcess * (float)Math.PI));
                poseStack.m_252781_(Axis.f_252436_.m_252977_((float)i * (45.0f + f * -20.0f)));
                float f1 = Mth.m_14031_((float)(Mth.m_14116_((float)swingProcess) * (float)Math.PI));
                poseStack.m_252781_(Axis.f_252403_.m_252977_((float)i * f1 * -20.0f));
                poseStack.m_252781_(Axis.f_252529_.m_252977_(f1 * -80.0f));
                poseStack.m_252781_(Axis.f_252436_.m_252977_((float)i * -45.0f));
            }
        });
    }
}

