/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.items.handler;

import com.Polarice3.Goety.common.items.brew.ThrowableBrewItem;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class BrewBagItemHandler
extends ItemStackHandler {
    private final ItemStack itemStack;
    private int slot;

    public BrewBagItemHandler(ItemStack itemStack) {
        super(11);
        this.itemStack = itemStack;
    }

    public ItemStack extractItem() {
        return this.extractItem(this.slot, 1, false);
    }

    public ItemStack insertItem(ItemStack insert) {
        return this.insertItem(this.slot, insert, false);
    }

    public ItemStack getSlot() {
        return this.getStackInSlot(this.slot);
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return stack.m_41720_() instanceof ThrowableBrewItem;
    }

    public int getSlotLimit(int slot) {
        return 11;
    }

    public NonNullList<ItemStack> getContents() {
        return this.stacks;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        nbt.m_128405_("slot", this.slot);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
        ListTag tagList = nbt.m_128437_("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTags = tagList.m_128728_(i);
            if (!nbt.m_128441_("slot")) continue;
            this.slot = nbt.m_128451_("slot");
            this.stacks.set(this.slot, (Object)ItemStack.m_41712_((CompoundTag)itemTags));
        }
        this.onLoad();
    }

    protected void onContentsChanged(int slot) {
        CompoundTag nbt;
        nbt.m_128379_("goety-dirty", !(nbt = this.itemStack.m_41784_()).m_128471_("goety-dirty"));
    }

    public static BrewBagItemHandler get(ItemStack stack) {
        IItemHandler handler = (IItemHandler)stack.getCapability(ForgeCapabilities.ITEM_HANDLER).orElseThrow(() -> new IllegalArgumentException("ItemStack is missing item capability"));
        return (BrewBagItemHandler)handler;
    }
}

