/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.items.equipment;

import com.Polarice3.Goety.ItemConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.Tags;

public class HammerItem
extends TieredItem
implements Vanishable {
    private static float initialDamage = ((Double)ItemConfig.HammerBaseDamage.get()).floatValue();
    private final Multimap<Attribute, AttributeModifier> hammerAttributes;
    protected final float speed;

    public HammerItem(Tier itemTier) {
        super(itemTier, new Item.Properties().m_41497_(Rarity.UNCOMMON).m_41503_(itemTier.m_6609_()));
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        initialDamage = ((Double)ItemConfig.HammerBaseDamage.get()).floatValue() + itemTier.m_6631_();
        double attackSpeed = 4.0 - (Double)ItemConfig.HammerAttackSpeed.get();
        this.speed = itemTier.m_6624_() - 2.0f;
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", (double)initialDamage - 1.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", -attackSpeed, AttributeModifier.Operation.ADDITION));
        this.hammerAttributes = builder.build();
    }

    public HammerItem() {
        this((Tier)Tiers.IRON);
    }

    public static float getInitialDamage() {
        return initialDamage;
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        Player player;
        float f2;
        pStack.m_41622_(1, pAttacker, p_220045_0_ -> p_220045_0_.m_21166_(EquipmentSlot.MAINHAND));
        if (pAttacker instanceof Player && (f2 = (player = (Player)pAttacker).m_36403_(0.5f)) > 0.9f) {
            Level level;
            this.attackMobs(pTarget, player);
            player.f_19853_.m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ModSounds.HAMMER_SWING.get(), player.m_5720_(), 1.0f, 1.0f);
            if (pTarget.m_20096_()) {
                player.f_19853_.m_6263_((Player)null, pTarget.m_20185_(), pTarget.m_20186_(), pTarget.m_20189_(), (SoundEvent)ModSounds.DIRT_DEBRIS.get(), player.m_5720_(), 1.0f, 1.0f);
            }
            if ((level = player.f_19853_) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                BlockPos blockPos = BlockPos.m_274561_((double)pTarget.m_20185_(), (double)(pTarget.m_20186_() - 1.0), (double)pTarget.m_20189_());
                BlockParticleOption option = new BlockParticleOption(ParticleTypes.f_123794_, serverLevel.m_8055_(blockPos));
                for (int i = 0; i < 8; ++i) {
                    ServerParticleUtil.circularParticles(serverLevel, (ParticleOptions)option, pTarget.m_20185_(), pTarget.m_20186_() + 0.25, pTarget.m_20189_(), 1.5f);
                }
            }
        }
        return true;
    }

    public InteractionResult m_6225_(UseOnContext p_41427_) {
        Level level = p_41427_.m_43725_();
        BlockPos blockpos = p_41427_.m_8083_();
        Player player = p_41427_.m_43723_();
        BlockState blockstate = level.m_8055_(blockpos);
        if (player != null) {
            ItemStack itemStack = player.m_21211_();
            if (blockstate.m_204336_(Tags.Blocks.STORAGE_BLOCKS_IRON)) {
                itemStack.m_41622_(5, (LivingEntity)player, p_220045_0_ -> p_220045_0_.m_21166_(EquipmentSlot.MAINHAND));
                level.m_46597_(blockpos, Blocks.f_50324_.m_49966_());
            }
        }
        return super.m_6225_(p_41427_);
    }

    public boolean getMineBlocks(BlockState pState) {
        return pState.m_204336_(BlockTags.f_144282_);
    }

    public float m_8102_(ItemStack pStack, BlockState pState) {
        return pState.m_204336_(BlockTags.f_144282_) ? this.speed : 1.0f;
    }

    public boolean m_6813_(ItemStack pStack, Level pLevel, BlockState pState, BlockPos pPos, LivingEntity pEntityLiving) {
        if (pState.m_60800_((BlockGetter)pLevel, pPos) != 0.0f) {
            pStack.m_41622_(this.getMineBlocks(pState) ? 1 : 2, pEntityLiving, p_220044_0_ -> p_220044_0_.m_21166_(EquipmentSlot.MAINHAND));
        }
        if (this.getMineBlocks(pState)) {
            pLevel.m_6263_((Player)null, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), (SoundEvent)ModSounds.DIRT_DEBRIS.get(), pEntityLiving.m_5720_(), 1.0f, 1.0f);
            for (BlockPos blockPos : BlockFinder.multiBlockBreak(pEntityLiving, pPos, 1, 1, 1)) {
                BlockState blockstate = pLevel.m_8055_(blockPos);
                if (!this.getMineBlocks(blockstate) || !this.destroyBlock(pLevel, blockPos, (Entity)pEntityLiving, pStack) || blockstate.m_60800_((BlockGetter)pLevel, blockPos) == 0.0f) continue;
                pStack.m_41622_(1, pEntityLiving, p_220044_0_ -> p_220044_0_.m_21166_(EquipmentSlot.MAINHAND));
            }
        }
        return true;
    }

    public boolean destroyBlock(Level level, BlockPos blockPos, Entity entity, ItemStack itemStack) {
        BlockState blockstate = level.m_8055_(blockPos);
        if (blockstate.m_60795_()) {
            return false;
        }
        FluidState fluidstate = level.m_6425_(blockPos);
        if (!(blockstate.m_60734_() instanceof BaseFireBlock)) {
            level.m_46796_(2001, blockPos, Block.m_49956_((BlockState)blockstate));
        }
        BlockEntity blockentity = blockstate.m_155947_() ? level.m_7702_(blockPos) : null;
        Block.dropResources((BlockState)blockstate, (Level)level, (BlockPos)blockPos, (BlockEntity)blockentity, (Entity)entity, (ItemStack)itemStack, (boolean)false);
        boolean flag = level.m_6933_(blockPos, fluidstate.m_76188_(), 3, 512);
        if (flag) {
            level.m_220407_(GameEvent.f_157794_, blockPos, GameEvent.Context.m_223719_((Entity)entity, (BlockState)blockstate));
        }
        return flag;
    }

    public void attackMobs(LivingEntity pTarget, Player pPlayer) {
        float f = (float)pPlayer.m_21133_(Attributes.f_22281_);
        float f1 = EnchantmentHelper.m_44833_((ItemStack)pPlayer.m_21205_(), (MobType)pTarget.m_6336_());
        float f2 = pPlayer.m_36403_(0.5f);
        f *= 0.2f + f2 * f2 * 0.8f;
        if ((f += (f1 *= f2)) > 0.5f || f1 > 0.5f) {
            float f3 = 1.0f + EnchantmentHelper.m_44821_((LivingEntity)pPlayer) * f;
            int j = EnchantmentHelper.m_44914_((LivingEntity)pPlayer);
            double area = 1.0;
            if (f2 > 0.9f) {
                area = 1.75;
            }
            for (LivingEntity livingentity : pPlayer.f_19853_.m_45976_(LivingEntity.class, pTarget.m_20191_().m_82377_(area, 0.25, area))) {
                if (livingentity == pPlayer || livingentity == pTarget || pPlayer.m_7307_((Entity)livingentity) || livingentity instanceof ArmorStand && ((ArmorStand)livingentity).m_31677_() || !(pPlayer.m_20280_((Entity)livingentity) < 16.0) || livingentity == pPlayer.m_20202_()) continue;
                livingentity.m_147240_((double)0.4f, (double)Mth.m_14031_((float)(pPlayer.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(pPlayer.m_146908_() * ((float)Math.PI / 180)))));
                if (!livingentity.m_6469_(pPlayer.m_269291_().m_269075_(pPlayer), f3)) continue;
                if (j > 0) {
                    livingentity.m_20254_(j * 4);
                }
                EnchantmentHelper.m_44823_((LivingEntity)livingentity, (Entity)pPlayer);
                EnchantmentHelper.m_44896_((LivingEntity)pPlayer, (Entity)livingentity);
            }
        }
        pPlayer.f_19853_.m_6263_((Player)null, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), (SoundEvent)ModSounds.HAMMER_IMPACT.get(), pPlayer.m_5720_(), 1.0f, 1.0f);
    }

    public boolean m_8096_(BlockState pBlock) {
        return pBlock.m_204336_(BlockTags.f_144282_);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.f_44672_ == EnchantmentCategory.WEAPON || enchantment.f_44672_ == EnchantmentCategory.DIGGER || super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.MAINHAND ? this.hammerAttributes : super.m_7167_(equipmentSlot);
    }
}

