/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.items;

import com.Polarice3.Goety.ItemConfig;
import com.Polarice3.Goety.common.blocks.ModBlocks;
import com.Polarice3.Goety.common.blocks.entities.CursedCageBlockEntity;
import com.Polarice3.Goety.init.ModSounds;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraftforge.registries.ForgeRegistries;

public class FlameCaptureItem
extends Item {
    public FlameCaptureItem() {
        super(new Item.Properties().m_41487_(1));
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack stack = context.m_43722_();
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        if (this.getEntity(stack, level) != null) {
            BlockEntity blockEntity;
            if (level.m_8055_(pos).m_60734_() == ModBlocks.CURSED_CAGE_BLOCK.get() && (blockEntity = level.m_7702_(pos)) instanceof CursedCageBlockEntity) {
                CursedCageBlockEntity cursedCageBlock = (CursedCageBlockEntity)blockEntity;
                if (!cursedCageBlock.getItem().m_41619_()) {
                    return InteractionResult.PASS;
                }
                if (!level.f_46443_) {
                    level.m_46597_(pos, Blocks.f_50085_.m_49966_());
                    BlockEntity blockentity = level.m_7702_(pos);
                    if (blockentity instanceof SpawnerBlockEntity) {
                        ((SpawnerBlockEntity)blockentity).m_59801_().m_253197_(this.getEntity(stack, level).m_6095_(), level, level.f_46441_, pos);
                    }
                }
                this.clearEntity(stack);
                if (player != null) {
                    player.m_216990_((SoundEvent)ModSounds.FLAME_CAPTURE_RELEASE.get());
                }
                stack.m_41774_(1);
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
        } else if (((Boolean)ItemConfig.FireSpawnCage.get()).booleanValue() && level.m_8055_(pos).m_60734_() == Blocks.f_50085_) {
            Entity entity;
            BlockEntity blockentity;
            if (!level.m_5776_() && (blockentity = level.m_7702_(pos)) instanceof SpawnerBlockEntity && (entity = ((SpawnerBlockEntity)blockentity).m_59801_().m_253067_(level, level.f_46441_, blockentity.m_58899_())) != null) {
                this.setEntity(entity, stack);
                level.m_46961_(pos, false);
            }
            if (player != null) {
                player.m_216990_((SoundEvent)ModSounds.FLAME_CAPTURE_CATCH.get());
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return super.m_6225_(context);
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        if (((Boolean)ItemConfig.FireSpawnCage.get()).booleanValue()) {
            if (level != null && this.getEntity(stack, level) != null) {
                Entity entity = this.getEntity(stack, level);
                if (entity == null) {
                    return;
                }
                MutableComponent textComponent = Component.m_237115_((String)"tooltip.goety.entity").m_130946_(": ").m_7220_((Component)Component.m_237113_((String)Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_())).toString())).m_130940_(ChatFormatting.GREEN);
                tooltip.add((Component)textComponent);
            }
        } else {
            MutableComponent textComponent = Component.m_237115_((String)"tooltip.goety.disabled").m_130940_(ChatFormatting.DARK_RED);
            tooltip.add((Component)textComponent);
        }
    }

    public static boolean hasEntity(ItemStack itemStack) {
        return itemStack.m_41783_() != null;
    }

    private void setEntity(Entity entity, ItemStack stack) {
        CompoundTag entityTag = stack.m_41784_();
        ResourceLocation name = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        if (name == null) {
            return;
        }
        entityTag.m_128359_("mob", name.toString());
    }

    private Entity getEntity(ItemStack stack, Level level) {
        CompoundTag itemTag = stack.m_41783_();
        if (itemTag == null) {
            return null;
        }
        EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(itemTag.m_128461_("mob")));
        if (entityType == null) {
            return null;
        }
        return entityType.m_20615_(level);
    }

    private void clearEntity(ItemStack stack) {
        stack.m_41751_(null);
    }
}

