/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.events;

import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.utils.SEHelper;
import javax.annotation.Nullable;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="goety", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class StunnedEvents {
    private static boolean isStunned(@Nullable LivingEntity entity) {
        Player player;
        return entity != null && entity.m_6084_() && (entity.m_21023_((MobEffect)GoetyEffects.STUNNED.get()) || entity instanceof Player && SEHelper.hasCamera(player = (Player)entity));
    }

    public static void cancelEvent(LivingEvent event) {
        if (event.isCancelable() && StunnedEvents.isStunned(event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void cancelPlayerAttack(AttackEntityEvent event) {
        StunnedEvents.cancelEvent((LivingEvent)event);
    }

    @SubscribeEvent
    public static void cancelBreakSpeed(PlayerEvent.BreakSpeed event) {
        StunnedEvents.cancelEvent((LivingEvent)event);
    }

    @SubscribeEvent
    public static void cancelActivateBlock(PlayerInteractEvent.RightClickBlock event) {
        StunnedEvents.cancelEvent((LivingEvent)event);
    }

    @SubscribeEvent
    public static void cancelInteract(PlayerInteractEvent.EntityInteract event) {
        StunnedEvents.cancelEvent((LivingEvent)event);
    }

    @SubscribeEvent
    public static void cancelUsingItem(LivingEntityUseItemEvent.Start event) {
        StunnedEvents.cancelEvent((LivingEvent)event);
    }

    @SubscribeEvent
    public static void cancelTickUsingItem(LivingEntityUseItemEvent.Tick event) {
        StunnedEvents.cancelEvent((LivingEvent)event);
    }

    @SubscribeEvent
    public static void cancelPlayerUseItem(PlayerInteractEvent.RightClickItem event) {
        StunnedEvents.cancelEvent((LivingEvent)event);
    }

    @SubscribeEvent
    public static void onLivingTarget(LivingChangeTargetEvent event) {
        Mob mob;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Mob && StunnedEvents.isStunned((LivingEntity)(mob = (Mob)livingEntity))) {
            event.setNewTarget(null);
        }
    }
}

