/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.util;

import com.Polarice3.Goety.SpellConfig;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.projectiles.FireTornado;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;

public class UpdraftBlast
extends Entity {
    public LivingEntity owner;
    private UUID ownerUniqueId;
    private float damage = ((Double)SpellConfig.UpdraftBlastDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();
    private float areaOfEffect = 0.0f;

    public UpdraftBlast(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
        this.f_19794_ = true;
    }

    public UpdraftBlast(Level worldIn, double x, double y, double z) {
        this((EntityType)ModEntityType.UPDRAFT_BLAST.get(), worldIn);
        this.m_6034_(x, y, z);
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128403_("Owner")) {
            this.ownerUniqueId = compound.m_128342_("Owner");
        }
        this.damage = compound.m_128457_("Damage");
        this.areaOfEffect = compound.m_128457_("AreaOfEffect");
    }

    protected void m_7380_(CompoundTag compound) {
        if (this.ownerUniqueId != null) {
            compound.m_128362_("Owner", this.ownerUniqueId);
        }
        compound.m_128350_("Damage", this.damage);
        compound.m_128350_("AreaOfEffect", this.areaOfEffect);
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public float getDamage() {
        return this.damage;
    }

    public void setAreaOfEffect(float damage) {
        this.areaOfEffect = damage;
    }

    public float getAreaOfEffect() {
        return this.areaOfEffect;
    }

    public void setOwner(@Nullable LivingEntity ownerIn) {
        this.owner = ownerIn;
        this.ownerUniqueId = ownerIn == null ? null : ownerIn.m_20148_();
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUniqueId != null && this.f_19853_ instanceof ServerLevel && (entity = ((ServerLevel)this.f_19853_).m_8791_(this.ownerUniqueId)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    public void m_8119_() {
        super.m_8119_();
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            float area = this.getAreaOfEffect() / 2.0f;
            float f = 1.5f + area;
            float f5 = (float)Math.PI * f * f;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_() + Math.cos((double)this.f_19797_ * 0.25) * (double)this.getAreaOfEffect(), this.m_20186_() + 0.5, this.m_20189_() + Math.sin((double)this.f_19797_ * 0.25) * (double)this.getAreaOfEffect(), 0, 0.0, 0.0, 0.0, 0.5);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_() + Math.cos((double)this.f_19797_ * 0.25 + Math.PI) * (double)this.getAreaOfEffect(), this.m_20186_() + 0.5, this.m_20189_() + Math.sin((double)this.f_19797_ * 0.25 + Math.PI) * (double)this.getAreaOfEffect(), 0, 0.0, 0.0, 0.0, 0.5);
            if (this.f_19797_ % 20 == 0) {
                for (int j1 = 0; j1 < 16; ++j1) {
                    int k1 = 0;
                    while ((float)k1 < f5) {
                        float f6 = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
                        float f7 = Mth.m_14116_((float)this.f_19796_.m_188501_()) * f;
                        float f8 = Mth.m_14089_((float)f6) * f7;
                        float f9 = Mth.m_14031_((float)f6) * f7;
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_() + (double)f8, this.m_20186_(), this.m_20189_() + (double)f9, 0, 0.0, 0.5, 0.0, 0.5);
                        ++k1;
                    }
                }
                ArrayList<Entity> targets = new ArrayList<Entity>();
                for (Entity entity : this.f_19853_.m_45976_(Entity.class, this.m_20191_().m_82377_((double)(1.0f + area), 1.0, (double)(1.0f + area)))) {
                    if (this.owner != null) {
                        if (entity == this.owner || entity.m_7307_((Entity)this.owner)) continue;
                        targets.add(entity);
                        continue;
                    }
                    targets.add(entity);
                }
                if (!targets.isEmpty()) {
                    for (Entity entity : targets) {
                        if (entity instanceof LivingEntity) {
                            LivingEntity livingEntity = (LivingEntity)entity;
                            livingEntity.m_6469_(ModDamageSource.windBlast(this, (Entity)this.owner), this.damage);
                            MobUtil.push((Entity)livingEntity, 0.0, 1.0, 0.0);
                            continue;
                        }
                        if (!(entity instanceof FireTornado)) continue;
                        FireTornado fireTornado = (FireTornado)entity;
                        fireTornado.trueRemove();
                    }
                }
            }
        }
        if (this.f_19797_ == 1) {
            this.m_5496_((SoundEvent)ModSounds.UPDRAFT_BLAST.get(), 1.0f, 1.0f);
        }
        if (this.f_19797_ % 20 == 0) {
            this.m_146870_();
        }
    }

    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }
}

