/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.util;

import com.Polarice3.Goety.utils.EntityFinder;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;

public class TunnelingFang
extends Mob {
    private static final EntityDataAccessor<Optional<UUID>> OWNER = SynchedEntityData.m_135353_(TunnelingFang.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private int duration = 600;
    private int coolDown = 0;
    private int durationOnUse;

    public TunnelingFang(EntityType<? extends Mob> p_i48576_1_, Level p_i48576_2_) {
        super(p_i48576_1_, p_i48576_2_);
    }

    public float getStepHeight() {
        return 1.0f;
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22279_, (double)0.35f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OWNER, Optional.empty());
    }

    public void m_7378_(CompoundTag pCompound) {
        UUID uuid;
        if (pCompound.m_128441_("Duration")) {
            this.duration = pCompound.m_128451_("Duration");
        }
        if (pCompound.m_128441_("DurationOnUse")) {
            this.durationOnUse = pCompound.m_128451_("DurationOnUse");
        }
        if (pCompound.m_128441_("CoolDown")) {
            this.coolDown = pCompound.m_128451_("CoolDown");
        }
        if (pCompound.m_128403_("owner")) {
            uuid = pCompound.m_128342_("owner");
        } else {
            String s = pCompound.m_128461_("owner");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
        }
        if (uuid != null) {
            try {
                this.setOwnerUUID(uuid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void m_7380_(CompoundTag pCompound) {
        pCompound.m_128405_("Duration", this.duration);
        pCompound.m_128405_("DurationOnUse", this.durationOnUse);
        pCompound.m_128405_("CoolDown", this.coolDown);
        if (this.getOwnerID() != null) {
            pCompound.m_128362_("owner", this.getOwnerID());
        }
    }

    @Nullable
    public LivingEntity getOwner() {
        try {
            UUID uuid = this.getOwnerID();
            if (uuid != null) {
                return EntityFinder.getLivingEntityByUuiD(uuid);
            }
            return null;
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    @Nullable
    public UUID getOwnerID() {
        return ((Optional)this.f_19804_.m_135370_(OWNER)).orElse(null);
    }

    public void setOwnerUUID(UUID uuid) {
        this.f_19804_.m_135381_(OWNER, Optional.ofNullable(uuid));
    }

    public void setOwner(LivingEntity livingEntity) {
        this.setOwnerUUID(livingEntity.m_20148_());
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int durationIn) {
        this.duration = durationIn;
    }

    public void m_7601_(BlockState pState, Vec3 pMotionMultiplier) {
        super.m_7601_(pState, Vec3.f_82478_);
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.durationOnUse;
        if (this.getOwner() == null || this.getOwner().m_21224_()) {
            if (this.durationOnUse % 20 == 0) {
                this.m_146870_();
            }
        } else {
            int k;
            int j;
            int i;
            BlockPos pos;
            BlockState blockstate;
            Mob mob;
            LivingEntity livingEntity2;
            AttributeInstance gravity = this.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
            if (gravity != null) {
                gravity.m_22100_(0.8);
            }
            if ((livingEntity2 = this.getOwner()) instanceof Mob && (mob = (Mob)livingEntity2).m_5448_() != null) {
                this.m_6710_(mob.m_5448_());
            } else if (this.m_5448_() == null && this.durationOnUse % 20 == 0) {
                this.m_146870_();
            }
            if (this.coolDown > 0) {
                --this.coolDown;
            }
            if (this.m_20184_().m_165925_() > 2.500000277905201E-7 && !(blockstate = this.f_19853_.m_8055_(pos = new BlockPos(i = Mth.m_14107_((double)this.m_20185_()), j = Mth.m_14107_((double)(this.m_20186_() - (double)0.2f)), k = Mth.m_14107_((double)this.m_20189_())))).m_60795_()) {
                this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate).setPos(pos), this.m_20185_() + ((double)this.f_19796_.m_188501_() - 0.5) * (double)this.m_20205_(), this.m_20186_() + 0.1, this.m_20189_() + ((double)this.f_19796_.m_188501_() - 0.5) * (double)this.m_20205_(), 4.0 * ((double)this.f_19796_.m_188501_() - 0.5), 0.5, ((double)this.f_19796_.m_188501_() - 0.5) * 4.0);
            }
            if (this.m_5448_() != null && this.durationOnUse >= 20) {
                LivingEntity target;
                this.f_21342_.m_6849_(this.m_5448_().m_20185_(), this.m_20186_(), this.m_5448_().m_20189_(), 1.0);
                if (this.coolDown <= 0 && (target = (LivingEntity)this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_()).stream().filter(livingEntity -> livingEntity != this.getOwner() && livingEntity != this && !this.getOwner().m_7307_((Entity)livingEntity) && !livingEntity.m_7307_((Entity)this.getOwner()) && this.m_20191_().m_82381_(livingEntity.m_20191_())).findFirst().orElse(null)) != null) {
                    WandUtil.spawnFangs((LivingEntity)this, this.m_20185_(), this.m_20189_(), this.m_20186_(), this.m_20186_() + 1.0, this.m_146908_(), 1);
                    this.coolDown = 25;
                }
            }
        }
        if (this.durationOnUse >= this.getDuration()) {
            this.m_146870_();
        }
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        return false;
    }

    public boolean m_142535_(float p_146828_, float p_146829_, DamageSource p_146830_) {
        return false;
    }

    public boolean m_6128_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7324_(Entity pEntity) {
    }

    protected void m_6138_() {
    }

    protected boolean m_6129_() {
        return false;
    }
}

