/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.util;

import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.entities.hostile.SkullLord;
import com.Polarice3.Goety.utils.EntityFinder;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;

public class SkullLaser
extends Mob {
    private static final EntityDataAccessor<Optional<UUID>> SKULL_LORD = SynchedEntityData.m_135353_(SkullLaser.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private int duration = 600;
    private int durationOnUse;

    public SkullLaser(EntityType<? extends Mob> p_i48576_1_, Level p_i48576_2_) {
        super(p_i48576_1_, p_i48576_2_);
    }

    public float getStepHeight() {
        return 1.0f;
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22279_, (double)0.23f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SKULL_LORD, Optional.empty());
    }

    public void m_7378_(CompoundTag pCompound) {
        UUID uuid;
        this.duration = pCompound.m_128451_("Duration");
        this.durationOnUse = pCompound.m_128451_("DurationOnUse");
        if (pCompound.m_128403_("skullLord")) {
            uuid = pCompound.m_128342_("skullLord");
        } else {
            String s = pCompound.m_128461_("skullLord");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
        }
        if (uuid != null) {
            try {
                this.setSkullLordUUID(uuid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void m_7380_(CompoundTag pCompound) {
        pCompound.m_128405_("Duration", this.duration);
        pCompound.m_128405_("DurationOnUse", this.durationOnUse);
        if (this.getSkullLordUUID() != null) {
            pCompound.m_128362_("skullLord", this.getSkullLordUUID());
        }
    }

    @Nullable
    public SkullLord getSkullLord() {
        try {
            UUID uuid = this.getSkullLordUUID();
            if (uuid != null && EntityFinder.getLivingEntityByUuiD(uuid) instanceof SkullLord) {
                return (SkullLord)EntityFinder.getLivingEntityByUuiD(uuid);
            }
            return null;
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    @Nullable
    public UUID getSkullLordUUID() {
        return ((Optional)this.f_19804_.m_135370_(SKULL_LORD)).orElse(null);
    }

    public void setSkullLordUUID(UUID uuid) {
        this.f_19804_.m_135381_(SKULL_LORD, Optional.ofNullable(uuid));
    }

    public void setSkullLord(SkullLord skullLord) {
        this.setSkullLordUUID(skullLord.m_20148_());
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int durationIn) {
        this.duration = durationIn;
    }

    public void m_7601_(BlockState pState, Vec3 pMotionMultiplier) {
        super.m_7601_(pState, Vec3.f_82478_);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            if (this.getSkullLord() == null || this.getSkullLord().m_21224_() || this.getSkullLord().m_20147_()) {
                if (this.f_19797_ % 20 == 0) {
                    this.m_146870_();
                }
            } else {
                AttributeInstance gravity = this.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
                if (gravity != null) {
                    gravity.m_22100_(0.8);
                }
                if (this.getSkullLord().isHalfHealth()) {
                    Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_(0.3);
                    if (this.f_19853_.m_46791_() == Difficulty.HARD) {
                        this.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 20, 1, false, false));
                    }
                }
                if (this.getSkullLord().m_5448_() != null) {
                    this.m_6710_(this.getSkullLord().m_5448_());
                } else if (this.f_19797_ % 20 == 0) {
                    this.m_146870_();
                }
                if (this.m_5448_() != null && this.f_19797_ >= 20) {
                    if (this.f_19797_ % 2 == 0) {
                        this.f_19853_.m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.25f, Level.ExplosionInteraction.NONE);
                    }
                    this.f_21342_.m_6849_(this.m_5448_().m_20185_(), this.m_20186_(), this.m_5448_().m_20189_(), 1.0);
                    for (LivingEntity livingEntity : this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_().m_82400_(0.5))) {
                        if (livingEntity == this.getSkullLord() || !MobUtil.areNotFullAllies((Entity)this.getSkullLord(), (Entity)livingEntity) || livingEntity == this) continue;
                        this.m_5448_().m_6469_(this.m_269291_().m_269104_((Entity)this, (Entity)this.getSkullLord()), (float)this.getSkullLord().m_21172_(Attributes.f_22281_));
                        this.m_5448_().m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.SAPPED.get(), 100));
                    }
                }
            }
            if (this.f_19797_ >= this.getDuration()) {
                if (this.getSkullLord() != null) {
                    this.getSkullLord().boneLordRegen = 50 + this.f_19796_.m_188503_(100);
                }
                this.m_146870_();
            }
        }
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        return false;
    }

    public boolean m_142535_(float p_146828_, float p_146829_, DamageSource p_146830_) {
        return false;
    }

    public boolean m_6128_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7324_(Entity pEntity) {
    }

    protected void m_6138_() {
    }

    protected boolean m_6129_() {
        return false;
    }
}

