/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.util;

import com.Polarice3.Goety.common.entities.ModEntityType;
import java.util.Optional;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.network.NetworkHooks;

public class ModFallingBlock
extends Entity {
    public static float GRAVITY = 0.1f;
    private static final EntityDataAccessor<Optional<BlockState>> BLOCK_STATE = SynchedEntityData.m_135353_(ModFallingBlock.class, (EntityDataSerializer)EntityDataSerializers.f_268618_);
    private static final EntityDataAccessor<Integer> DURATION = SynchedEntityData.m_135353_(ModFallingBlock.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TICKS_EXISTED = SynchedEntityData.m_135353_(ModFallingBlock.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> MODE = SynchedEntityData.m_135353_(ModFallingBlock.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Float> POP_UP_LEVEL = SynchedEntityData.m_135353_(ModFallingBlock.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public double prevMotionX;
    public double prevMotionY;
    public double prevMotionZ;
    public float animY = 0.0f;
    public float prevAnimY = 0.0f;

    public ModFallingBlock(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
        this.setBlock(Blocks.f_50493_.m_49966_());
        this.setDuration(70);
    }

    public ModFallingBlock(Level worldIn, int duration, BlockState blockState) {
        super((EntityType)ModEntityType.FALLING_BLOCK.get(), worldIn);
        this.setBlock(blockState);
        this.setDuration(duration);
    }

    public ModFallingBlock(Level worldIn, BlockState blockState, float popUp) {
        super((EntityType)ModEntityType.FALLING_BLOCK.get(), worldIn);
        this.setBlock(blockState);
        this.setMode(FallingBlockMode.POPUP_ANIM);
        this.setPopUp(popUp);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(BLOCK_STATE, Optional.of(Blocks.f_50493_.m_49966_()));
        this.f_19804_.m_135372_(DURATION, (Object)70);
        this.f_19804_.m_135372_(TICKS_EXISTED, (Object)0);
        this.f_19804_.m_135372_(MODE, (Object)FallingBlockMode.MOBILE.toString());
        this.f_19804_.m_135372_(POP_UP_LEVEL, (Object)Float.valueOf(1.0f));
    }

    protected void m_7378_(CompoundTag compound) {
        Tag blockStateCompound = compound.m_128423_("BlockState");
        if (blockStateCompound != null) {
            BlockState blockState = NbtUtils.m_247651_((HolderGetter)this.m_9236_().m_246945_(Registries.f_256747_), (CompoundTag)compound.m_128469_("BlockState"));
            this.setBlock(blockState);
        }
        this.setDuration(compound.m_128451_("duration"));
        this.f_19797_ = compound.m_128451_("tickCount");
        this.f_19804_.m_135381_(MODE, (Object)compound.m_128461_("mode"));
        this.setPopUp(compound.m_128457_("popUp"));
    }

    protected void m_7380_(CompoundTag compound) {
        BlockState blockState = this.getBlock();
        if (blockState != null) {
            compound.m_128365_("BlockState", (Tag)NbtUtils.m_129202_((BlockState)blockState));
        }
        compound.m_128405_("duration", this.getDuration());
        compound.m_128405_("tickCount", this.f_19797_);
        compound.m_128359_("mode", (String)this.f_19804_.m_135370_(MODE));
        compound.m_128350_("popUp", ((Float)this.f_19804_.m_135370_(POP_UP_LEVEL)).floatValue());
    }

    public void onAddedToWorld() {
        if (this.m_20184_().m_7096_() > 0.0 || this.m_20184_().m_7094_() > 0.0) {
            this.m_146922_((float)(57.29577951308232 * Math.atan2(this.m_20184_().m_7096_(), this.m_20184_().m_7094_())));
        }
        this.m_146926_(this.m_146909_() + this.f_19796_.m_188501_() * 360.0f);
        super.onAddedToWorld();
    }

    public void m_8119_() {
        if (this.getMode() == FallingBlockMode.POPUP_ANIM) {
            this.m_20334_(0.0, 0.0, 0.0);
            this.m_146850_(GameEvent.f_157795_);
        }
        this.prevMotionX = this.m_20184_().f_82479_;
        this.prevMotionY = this.m_20184_().f_82480_;
        this.prevMotionZ = this.m_20184_().f_82481_;
        super.m_8119_();
        if (this.getMode() == FallingBlockMode.MOBILE) {
            this.m_20256_(this.m_20184_().m_82492_(0.0, (double)GRAVITY, 0.0));
            if (this.m_20096_()) {
                this.m_20256_(this.m_20184_().m_82490_((double)0.7f));
            } else {
                this.m_146926_(this.m_146909_() + 15.0f);
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
            if (this.getTicksExisted() > this.getDuration()) {
                this.m_146870_();
            }
        } else {
            this.prevAnimY = this.animY;
            this.animY += this.getPopUp();
            this.setPopUp(this.getPopUp() - GRAVITY);
            if (this.animY < -0.5f) {
                this.m_146870_();
            }
        }
    }

    public BlockState getBlock() {
        Optional blockState = (Optional)this.f_19804_.m_135370_(BLOCK_STATE);
        return blockState.orElse(null);
    }

    public void setBlock(BlockState block) {
        this.f_19804_.m_135381_(BLOCK_STATE, Optional.of(block));
    }

    public int getDuration() {
        return (Integer)this.f_19804_.m_135370_(DURATION);
    }

    public void setDuration(int duration) {
        this.f_19804_.m_135381_(DURATION, (Object)duration);
    }

    public int getTicksExisted() {
        return (Integer)this.f_19804_.m_135370_(TICKS_EXISTED);
    }

    public void setTicksExisted(int ticksExisted) {
        this.f_19804_.m_135381_(TICKS_EXISTED, (Object)ticksExisted);
    }

    public FallingBlockMode getMode() {
        String mode = (String)this.f_19804_.m_135370_(MODE);
        if (mode.isEmpty()) {
            return FallingBlockMode.MOBILE;
        }
        return FallingBlockMode.valueOf((String)this.f_19804_.m_135370_(MODE));
    }

    private void setMode(FallingBlockMode mode) {
        this.f_19804_.m_135381_(MODE, (Object)mode.toString());
    }

    public float getPopUp() {
        return ((Float)this.f_19804_.m_135370_(POP_UP_LEVEL)).floatValue();
    }

    private void setPopUp(float power) {
        this.f_19804_.m_135381_(POP_UP_LEVEL, (Object)Float.valueOf(power));
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static enum FallingBlockMode {
        MOBILE,
        POPUP_ANIM;

    }
}

