/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.SpellConfig;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class ViciousPike
extends Entity {
    private LivingEntity owner;
    private UUID ownerUUID;
    private boolean sentSpikeEvent;
    private int lifeTicks = 22;
    public AnimationState mainAnimationState = new AnimationState();

    public ViciousPike(EntityType<? extends Entity> p_i50170_1_, Level p_i50170_2_) {
        super(p_i50170_1_, p_i50170_2_);
    }

    public ViciousPike(Level pLevel, LivingEntity pOwner) {
        this((EntityType<? extends Entity>)((EntityType)ModEntityType.VICIOUS_PIKE.get()), pLevel);
        this.owner = pOwner;
    }

    public ViciousPike(Level pLevel, double x, double y, double z, LivingEntity pOwner) {
        this((EntityType<? extends Entity>)((EntityType)ModEntityType.VICIOUS_PIKE.get()), pLevel);
        this.setOwner(pOwner);
        this.m_6034_(x, y, z);
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag pCompound) {
        if (pCompound.m_128403_("Owner")) {
            this.ownerUUID = pCompound.m_128342_("Owner");
        }
    }

    protected void m_7380_(CompoundTag pCompound) {
        if (this.ownerUUID != null) {
            pCompound.m_128362_("Owner", this.ownerUUID);
        }
    }

    public void setOwner(@Nullable LivingEntity p_190549_1_) {
        this.owner = p_190549_1_;
        this.ownerUUID = p_190549_1_ == null ? null : p_190549_1_.m_20148_();
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.f_19853_ instanceof ServerLevel && (entity = ((ServerLevel)this.f_19853_).m_8791_(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            --this.lifeTicks;
        } else {
            if (this.f_19797_ == 2) {
                for (LivingEntity livingentity : this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_().m_82377_(0.2, 0.0, 0.2))) {
                    this.dealDamageTo(livingentity);
                }
            }
            if (!this.sentSpikeEvent) {
                this.f_19853_.m_7605_((Entity)this, (byte)4);
                this.sentSpikeEvent = true;
            }
            if (--this.lifeTicks < 0) {
                this.m_146870_();
            }
        }
    }

    public void m_7601_(BlockState p_20006_, Vec3 p_20007_) {
        super.m_7601_(p_20006_, Vec3.f_82478_);
    }

    private void dealDamageTo(LivingEntity target) {
        LivingEntity livingentity = this.getOwner();
        float baseDamage = ((Double)SpellConfig.FangDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();
        if (target.m_6084_() && !target.m_20147_() && MobUtil.validEntity((Entity)target) && target != livingentity) {
            if (livingentity != null) {
                if (target.m_7307_((Entity)livingentity)) {
                    return;
                }
                if (livingentity.m_7307_((Entity)target)) {
                    return;
                }
                target.m_6469_(this.m_269291_().m_269104_((Entity)this, (Entity)livingentity), baseDamage);
            } else {
                target.m_6469_(this.m_269291_().m_269425_(), baseDamage);
            }
            if (!target.f_19812_) {
                MobUtil.push((Entity)target, 0.0, 1.0, 0.0);
                target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 4, false, false));
            }
        }
    }

    public void m_7822_(byte p_36935_) {
        super.m_7822_(p_36935_);
        if (p_36935_ == 4) {
            this.mainAnimationState.m_216977_(this.f_19797_);
            if (!this.m_20067_()) {
                this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.IMPALE.get(), this.m_5720_(), 1.0f, this.f_19796_.m_188501_() * 0.2f + 0.85f, false);
            }
        }
    }

    public float getAnimationProgress(float p_36937_) {
        int i = this.lifeTicks;
        return i <= 0 ? 1.0f : 1.0f - ((float)i - p_36937_) / 20.0f;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

