/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.SpellConfig;
import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.WandUtil;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class SoulBolt
extends AbstractHurtingProjectile {
    private static final EntityDataAccessor<Integer> DATA_TYPE_ID = SynchedEntityData.m_135353_(SoulBolt.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final Map<Integer, ResourceLocation> TEXTURE_BY_TYPE = (Map)Util.m_137469_((Object)Maps.newHashMap(), map -> {
        map.put(0, Goety.location("textures/entity/projectiles/soul_bolt/soul_bolt_1.png"));
        map.put(1, Goety.location("textures/entity/projectiles/soul_bolt/soul_bolt_2.png"));
        map.put(2, Goety.location("textures/entity/projectiles/soul_bolt/soul_bolt_3.png"));
    });
    public float boltSpeed = 0.0f;

    public SoulBolt(EntityType<? extends AbstractHurtingProjectile> p_36833_, Level p_36834_) {
        super(p_36833_, p_36834_);
    }

    public SoulBolt(double pX, double pY, double pZ, double pXPower, double pYPower, double pZPower, Level pLevel) {
        super((EntityType)ModEntityType.SOUL_BOLT.get(), pX, pY, pZ, pXPower, pYPower, pZPower, pLevel);
    }

    public SoulBolt(LivingEntity pShooter, double pXPower, double pYPower, double pZPower, Level pLevel) {
        super((EntityType)ModEntityType.SOUL_BOLT.get(), pShooter, pXPower, pYPower, pZPower, pLevel);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_TYPE_ID, (Object)0);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setAnimation(compound.m_128451_("Animation"));
        if (compound.m_128441_("BoltSpeed")) {
            this.boltSpeed = compound.m_128457_("BoltSpeed");
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Animation", this.getAnimation());
        compound.m_128350_("BoltSpeed", this.boltSpeed);
    }

    public ResourceLocation getResourceLocation() {
        return TEXTURE_BY_TYPE.getOrDefault(this.getAnimation(), TEXTURE_BY_TYPE.get(0));
    }

    public void rotateToMatchMovement() {
        this.m_37283_();
    }

    public int getAnimation() {
        return (Integer)this.f_19804_.m_135370_(DATA_TYPE_ID);
    }

    public void setAnimation(int pType) {
        this.f_19804_.m_135381_(DATA_TYPE_ID, (Object)pType);
    }

    public void setBoltSpeed(int increase) {
        this.boltSpeed += (float)increase / 50.0f;
    }

    protected float m_6884_() {
        return 0.82f + Math.min(this.boltSpeed, 0.18f);
    }

    public boolean m_6060_() {
        return false;
    }

    protected void m_5790_(EntityHitResult p_37626_) {
        super.m_5790_(p_37626_);
        if (!this.f_19853_.f_46443_) {
            boolean flag;
            float baseDamage = ((Double)SpellConfig.SoulBoltDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();
            Entity entity = p_37626_.m_82443_();
            Entity entity1 = this.m_19749_();
            if (entity1 instanceof LivingEntity) {
                Mob mob;
                LivingEntity livingentity = (LivingEntity)entity1;
                if (WandUtil.enchantedFocus(livingentity)) {
                    baseDamage += (float)WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), livingentity);
                } else if (livingentity instanceof Mob && (mob = (Mob)livingentity).m_21051_(Attributes.f_22281_) != null && mob.m_21133_(Attributes.f_22281_) > 0.0) {
                    baseDamage = (float)mob.m_21133_(Attributes.f_22281_);
                }
                flag = entity.m_6469_(entity.m_269291_().m_269104_((Entity)this, (Entity)livingentity), baseDamage);
                if (flag && entity.m_6084_()) {
                    this.m_19970_(livingentity, entity);
                }
            } else {
                flag = entity.m_6469_(entity.m_269291_().m_269425_(), baseDamage);
            }
            if (flag && entity instanceof LivingEntity) {
                double x = this.m_20185_();
                double z = this.m_20189_();
                if (entity1 != null) {
                    x = entity1.m_20185_();
                    z = entity1.m_20189_();
                }
                ((LivingEntity)entity).m_147240_(1.0, x - entity.m_20185_(), z - entity.m_20189_());
            }
        }
    }

    protected void m_6532_(HitResult p_37628_) {
        super.m_6532_(p_37628_);
        this.m_216990_((SoundEvent)ModSounds.BOLT_IMPACT.get());
        if (!this.f_19853_.f_46443_) {
            ServerLevel serverLevel = (ServerLevel)this.f_19853_;
            for (int p = 0; p < 32; ++p) {
                double d0 = this.m_20185_() + this.f_19853_.f_46441_.m_188500_();
                double d1 = this.m_20186_() + this.f_19853_.f_46441_.m_188500_();
                double d2 = this.m_20189_() + this.f_19853_.f_46441_.m_188500_();
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.BULLET_EFFECT.get()), d0, d1, d2, 0, 0.45, 0.45, 0.45, 0.5);
            }
            this.m_146870_();
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.getAnimation() < 2) {
            this.setAnimation(this.getAnimation() + 1);
        } else {
            this.setAnimation(0);
        }
        Entity entity = this.m_19749_();
        if (this.f_19797_ >= MathHelper.secondsToTicks(10)) {
            this.m_146870_();
        }
        if (this.f_19853_.f_46443_ || (entity == null || !entity.m_213877_()) && this.f_19853_.m_46805_(this.m_20183_())) {
            Vec3 vec3 = this.m_20184_();
            double d0 = this.m_20185_() - vec3.f_82479_;
            double d1 = this.m_20186_() - vec3.f_82480_;
            double d2 = this.m_20189_() - vec3.f_82481_;
            this.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.SUMMON.get(), d0, d1 + 0.15, d2, 0.0, 0.0, 0.0);
        }
    }

    protected boolean m_5603_(Entity pEntity) {
        if (this.m_19749_() != null) {
            Mob mob;
            Entity entity = this.m_19749_();
            if (entity instanceof Mob && (mob = (Mob)entity).m_5448_() == pEntity) {
                return super.m_5603_(pEntity);
            }
            if (this.m_19749_().m_7307_(pEntity) || pEntity.m_7307_(this.m_19749_())) {
                return false;
            }
            if (this.m_19749_() instanceof Enemy && pEntity instanceof Enemy) {
                return false;
            }
            if (pEntity instanceof IOwned) {
                IOwned owned0 = (IOwned)pEntity;
                Entity entity2 = this.m_19749_();
                if (entity2 instanceof IOwned) {
                    IOwned owned1 = (IOwned)entity2;
                    return !MobUtil.ownerStack(owned0, owned1);
                }
            }
        }
        return super.m_5603_(pEntity);
    }

    protected ParticleOptions m_5967_() {
        return (ParticleOptions)ModParticleTypes.NONE.get();
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6469_(DamageSource p_37616_, float p_37617_) {
        return false;
    }

    protected boolean m_5931_() {
        return false;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

