/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.client.particles.PulsatingCircleParticleOption;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;

public class ScatterMine
extends Entity {
    public float getGlow = 1.0f;
    public float glowAmount = 0.0045f;
    public float size = 3.0f;
    private LivingEntity owner;
    private UUID ownerUUID;
    public int lifeTicks = MathHelper.secondsToTicks(10);

    public ScatterMine(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    public ScatterMine(Level pLevel, LivingEntity pOwner, BlockPos blockPos) {
        this((EntityType)ModEntityType.SCATTER_MINE.get(), pLevel);
        if (blockPos != null) {
            this.m_6034_(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
        }
        this.setOwner(pOwner);
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag pCompound) {
        UUID ownerUUID;
        if (pCompound.m_128403_("Owner")) {
            ownerUUID = pCompound.m_128342_("Owner");
        } else {
            String s = pCompound.m_128461_("Owner");
            ownerUUID = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
        }
        if (ownerUUID != null) {
            this.ownerUUID = ownerUUID;
        }
        if (pCompound.m_128441_("LifeTicks")) {
            this.lifeTicks = pCompound.m_128451_("LifeTicks");
        }
    }

    protected void m_7380_(CompoundTag pCompound) {
        if (this.ownerUUID != null) {
            pCompound.m_128362_("Owner", this.ownerUUID);
        }
        pCompound.m_128405_("LifeTicks", this.lifeTicks);
    }

    public void setOwner(@Nullable LivingEntity p_190549_1_) {
        this.owner = p_190549_1_;
        this.ownerUUID = p_190549_1_ == null ? null : p_190549_1_.m_20148_();
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.f_19853_ instanceof ServerLevel && (entity = ((ServerLevel)this.f_19853_).m_8791_(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    public void m_7822_(byte id) {
        if (id == 4) {
            this.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.ELECTRIC.get(), this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), -0.05 + this.f_19796_.m_188500_() * 0.05, -0.05 + this.f_19796_.m_188500_() * 0.05, -0.05 + this.f_19796_.m_188500_() * 0.05);
        } else if (id == 5) {
            for (int i = 0; i < 20; ++i) {
                double d0 = this.f_19796_.m_188583_() * 0.02;
                double d1 = this.f_19796_.m_188583_() * 0.02;
                double d2 = this.f_19796_.m_188583_() * 0.02;
                double d3 = 10.0;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20208_(1.0) - d0 * d3, this.m_20187_() - d1 * d3, this.m_20262_(1.0) - d2 * d3, d0, d1, d2);
            }
        } else if (id == 6) {
            this.finalizeExplosion();
        } else {
            super.m_7822_(id);
        }
    }

    public boolean startGlow() {
        return this.lifeTicks < MathHelper.secondsToTicks(10) - 5;
    }

    public boolean startShrink() {
        return this.lifeTicks < MathHelper.secondsToTicks(10) - 2;
    }

    public void m_8119_() {
        super.m_8119_();
        --this.lifeTicks;
        if (this.f_19853_.f_46443_) {
            if (this.startGlow()) {
                this.glow();
            }
            if (this.startShrink()) {
                this.shrink();
            }
        }
        if (!this.f_19853_.f_46443_) {
            if (!this.m_20068_()) {
                MobUtil.moveDownToGround(this);
            }
            this.f_19853_.m_7605_((Entity)this, (byte)4);
            if (this.lifeTicks <= 0) {
                this.f_19853_.m_7605_((Entity)this, (byte)5);
                this.m_146870_();
            } else if (this.lifeTicks < MathHelper.secondsToTicks(9)) {
                Level level;
                if (this.f_19797_ % 10 == 0 && (level = this.f_19853_) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)new PulsatingCircleParticleOption(1.0f), this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.5);
                }
                for (LivingEntity livingentity : this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_().m_82377_(0.6, 0.3, 0.6))) {
                    if (!livingentity.m_6084_() || livingentity.m_20147_()) continue;
                    if (this.getOwner() != null) {
                        if (this.getOwner().m_7307_((Entity)livingentity) || livingentity.m_7307_((Entity)this.getOwner()) || livingentity == this.getOwner()) continue;
                        this.explode(livingentity);
                        continue;
                    }
                    this.explode(livingentity);
                }
            }
        }
    }

    private void glow() {
        this.getGlow = Mth.m_14036_((float)(this.getGlow - this.glowAmount), (float)0.0f, (float)1.0f);
    }

    private void shrink() {
        this.size = Mth.m_14036_((float)(this.size - 0.5f), (float)1.25f, (float)3.0f);
    }

    public void explode(LivingEntity livingEntity) {
        if (!this.f_19853_.f_46443_) {
            this.f_19853_.m_7605_((Entity)this, (byte)6);
            LivingEntity owner = null;
            float damage = 12.0f;
            if (this.getOwner() != null) {
                owner = this.getOwner();
                if (this.getOwner().m_21051_(Attributes.f_22281_) != null && this.getOwner().m_21133_(Attributes.f_22281_) > 0.0) {
                    damage = (float)this.getOwner().m_21133_(Attributes.f_22281_);
                }
            }
            livingEntity.m_6469_(livingEntity.m_269291_().m_269036_((Entity)owner, (Entity)owner), damage);
            this.m_146870_();
        }
    }

    private void createParticleBall(double p_106779_, int radius) {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                for (int k = -radius; k <= radius; ++k) {
                    double d3 = (double)j + (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 0.5;
                    double d4 = (double)i + (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 0.5;
                    double d5 = (double)k + (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 0.5;
                    double d6 = Math.sqrt(d3 * d3 + d4 * d4 + d5 * d5) / p_106779_ + this.f_19796_.m_188583_() * 0.05;
                    this.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.REDSTONE_EXPLODE.get(), d0, d1, d2, d3 / d6, d4 / d6, d5 / d6);
                    if (i == -radius || i == radius || j == -radius || j == radius) continue;
                    k += radius * 2 - 1;
                }
            }
        }
    }

    public void finalizeExplosion() {
        if (this.f_19853_.f_46443_) {
            this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.REDSTONE_EXPLODE.get(), SoundSource.BLOCKS, 4.0f, (1.0f + (this.f_19853_.f_46441_.m_188501_() - this.f_19853_.f_46441_.m_188501_()) * 0.2f) * 0.7f, false);
        }
        this.createParticleBall(0.5, 2);
        this.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.BIG_ELECTRIC.get(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.0, 0.0, 0.0);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

