/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.SpellConfig;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.projectiles.AbstractSpellCloud;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SThunderBoltPacket;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.ModDamageSource;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class MonsoonCloud
extends AbstractSpellCloud {
    public boolean staff = false;

    public MonsoonCloud(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
        this.setRainParticle((ParticleOptions)ParticleTypes.f_123761_);
    }

    public MonsoonCloud(Level pLevel, LivingEntity pOwner, LivingEntity pTarget) {
        this((EntityType)ModEntityType.MONSOON_CLOUD.get(), pLevel);
        if (pOwner != null) {
            this.setOwner(pOwner);
        }
        if (pTarget != null) {
            BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos(pTarget.m_20185_(), pTarget.m_20186_(), pTarget.m_20189_());
            while ((double)blockpos$mutable.m_123342_() < pTarget.m_20186_() + 4.0 && !this.f_19853_.m_8055_((BlockPos)blockpos$mutable).m_280555_()) {
                blockpos$mutable.m_122173_(Direction.UP);
            }
            this.m_6034_(pTarget.m_20185_(), blockpos$mutable.m_123342_(), pTarget.m_20189_());
        }
        this.m_5496_(SoundEvents.f_12090_, 0.5f, 1.25f);
    }

    @Override
    protected void m_7378_(CompoundTag p_20052_) {
        super.m_7378_(p_20052_);
        if (p_20052_.m_128441_("staff")) {
            this.staff = p_20052_.m_128471_("staff");
        }
    }

    @Override
    protected void m_7380_(CompoundTag p_20139_) {
        super.m_7380_(p_20139_);
        p_20139_.m_128379_("staff", this.staff);
    }

    public void setStaff(boolean staff) {
        this.staff = staff;
    }

    @Override
    public int getColor() {
        return 0x434343;
    }

    @Override
    public void hurtEntities(LivingEntity livingEntity) {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (livingEntity != null && !livingEntity.m_21224_() && EntitySelector.f_20406_.test(livingEntity)) {
                if (livingEntity.m_6126_()) {
                    livingEntity.m_6469_(livingEntity.m_269291_().m_269104_((Entity)this, (Entity)this.getOwner()), 1.0f);
                }
                if (this.f_19796_.m_188501_() <= 0.05f) {
                    Vec3 vec3 = this.m_20182_();
                    float damage = ((Double)SpellConfig.ThunderboltDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();
                    damage += this.extraDamage;
                    BlockHitResult rayTraceResult = this.blockResult((Level)serverLevel, this, 16.0);
                    Optional<BlockPos> lightningRod = BlockFinder.findLightningRod(serverLevel, BlockPos.m_274446_((Position)rayTraceResult.m_82450_()), 16);
                    if (lightningRod.isPresent() && !this.staff) {
                        BlockPos blockPos = lightningRod.get();
                        ModNetwork.sendToALL(new SThunderBoltPacket(vec3, new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), 10));
                        serverLevel.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.THUNDERBOLT.get(), this.m_5720_(), 1.0f, 1.0f);
                    } else {
                        Vec3 vec31 = new Vec3(livingEntity.m_20185_(), livingEntity.m_20186_() + (double)(livingEntity.m_20206_() / 2.0f), livingEntity.m_20189_());
                        ModNetwork.sendToALL(new SThunderBoltPacket(vec3, vec31, 10));
                        if (livingEntity.m_6469_(ModDamageSource.indirectShock(this, (Entity)this.getOwner()), damage)) {
                            float chance = 0.05f;
                            if (serverLevel.f_46441_.m_188501_() <= chance + 0.1f) {
                                livingEntity.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.TRIPPING.get(), MathHelper.secondsToTicks(5)));
                            }
                        }
                        serverLevel.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.THUNDERBOLT.get(), this.m_5720_(), 1.0f, 1.0f);
                    }
                }
            }
        }
    }

    public BlockHitResult blockResult(Level worldIn, Entity entity, double range) {
        float f = entity.m_146909_();
        float f1 = entity.m_146908_();
        Vec3 vector3d = entity.m_20299_(1.0f);
        float f2 = Mth.m_14089_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.m_14031_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.m_14089_((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        Vec3 vector3d1 = vector3d.m_82520_((double)f6 * range, (double)f5 * range, (double)f7 * range);
        return worldIn.m_45547_(new ClipContext(vector3d, vector3d1, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, entity));
    }
}

