/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.SpellConfig;
import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.WandUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;

public class ModFireball
extends Fireball {
    public static final EntityDataAccessor<Boolean> DATA_DANGEROUS = SynchedEntityData.m_135353_(ModFireball.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Float> DATA_DAMAGE = SynchedEntityData.m_135353_(ModFireball.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    public ModFireball(EntityType<? extends ModFireball> p_i50160_1_, Level p_i50160_2_) {
        super(p_i50160_1_, p_i50160_2_);
    }

    public ModFireball(Level p_i1771_1_, LivingEntity p_i1771_2_, double p_i1771_3_, double p_i1771_5_, double p_i1771_7_) {
        super((EntityType)ModEntityType.MOD_FIREBALL.get(), p_i1771_2_, p_i1771_3_, p_i1771_5_, p_i1771_7_, p_i1771_1_);
    }

    public ModFireball(Level pWorld, double pX, double pY, double pZ, double pAccelX, double pAccelY, double pAccelZ) {
        super((EntityType)ModEntityType.MOD_FIREBALL.get(), pX, pY, pZ, pAccelX, pAccelY, pAccelZ, pWorld);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_DANGEROUS, (Object)true);
        this.f_19804_.m_135372_(DATA_DAMAGE, (Object)Float.valueOf(5.0f));
    }

    public boolean isDangerous() {
        return (Boolean)this.f_19804_.m_135370_(DATA_DANGEROUS);
    }

    public void setDangerous(boolean pDangerous) {
        this.f_19804_.m_135381_(DATA_DANGEROUS, (Object)pDangerous);
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DATA_DAMAGE)).floatValue();
    }

    public void setDamage(float pDamage) {
        this.f_19804_.m_135381_(DATA_DAMAGE, (Object)Float.valueOf(pDamage));
    }

    protected void m_5790_(EntityHitResult pResult) {
        Entity entity;
        super.m_5790_(pResult);
        if (!this.f_19853_.f_46443_ && !(entity = pResult.m_82443_()).m_5825_()) {
            Entity entity1 = this.m_19749_();
            float enchantment = 0.0f;
            float damage = 5.0f;
            int flaming = 1;
            if (entity1 instanceof Player) {
                Player player = (Player)entity1;
                if (WandUtil.enchantedFocus((LivingEntity)player)) {
                    enchantment = WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), (LivingEntity)player);
                    flaming += WandUtil.getLevels((Enchantment)ModEnchantments.BURNING.get(), (LivingEntity)player);
                }
                damage = ((Double)SpellConfig.FireballDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();
            } else if (entity1 instanceof LivingEntity) {
                damage = this.getDamage();
            }
            int i = entity.m_20094_() + (flaming - 1);
            entity.m_20254_(5 * flaming);
            boolean flag = entity.m_6469_(entity.m_269291_().m_269453_((Fireball)this, entity1), damage + enchantment);
            if (!flag) {
                entity.m_7311_(i);
            } else if (entity1 instanceof LivingEntity) {
                this.m_19970_((LivingEntity)entity1, entity);
            }
        }
    }

    protected void m_8060_(BlockHitResult p_230299_1_) {
        super.m_8060_(p_230299_1_);
        if (!this.f_19853_.f_46443_) {
            Entity entity = this.m_19749_();
            if (this.isDangerous()) {
                BlockPos blockpos;
                IOwned iOwned;
                boolean flag = ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this.m_19749_());
                if (entity instanceof Player || entity instanceof IOwned && (iOwned = (IOwned)entity).getTrueOwner() instanceof Player) {
                    flag = (Boolean)SpellConfig.FireballGriefing.get();
                }
                if (flag && this.f_19853_.m_46859_(blockpos = p_230299_1_.m_82425_().m_121945_(p_230299_1_.m_82434_()))) {
                    this.f_19853_.m_46597_(blockpos, BaseFireBlock.m_49245_((BlockGetter)this.f_19853_, (BlockPos)blockpos));
                }
            }
        }
    }

    protected void m_6532_(HitResult pResult) {
        super.m_6532_(pResult);
        if (!this.f_19853_.f_46443_) {
            this.m_146870_();
        }
    }

    protected boolean m_5603_(Entity pEntity) {
        if (this.m_19749_() != null) {
            Mob mob;
            if (pEntity == this.m_19749_()) {
                return false;
            }
            Entity entity = this.m_19749_();
            if (entity instanceof Mob && (mob = (Mob)entity).m_5448_() == pEntity) {
                return super.m_5603_(pEntity);
            }
            if (this.m_19749_().m_7307_(pEntity) || pEntity.m_7307_(this.m_19749_())) {
                return false;
            }
            if (pEntity instanceof IOwned) {
                IOwned owned0 = (IOwned)pEntity;
                Entity entity2 = this.m_19749_();
                if (entity2 instanceof IOwned) {
                    IOwned owned1 = (IOwned)entity2;
                    return !MobUtil.ownerStack(owned0, owned1);
                }
            }
        }
        return super.m_5603_(pEntity);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("Dangerous", this.isDangerous());
        pCompound.m_128350_("Damage", this.getDamage());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("Dangerous")) {
            this.setDangerous(pCompound.m_128471_("Dangerous"));
        }
        if (pCompound.m_128441_("Damage")) {
            this.setDamage(pCompound.m_128457_("Damage"));
        }
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        return false;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

