/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.SpellConfig;
import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.projectiles.ExplosiveProjectile;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.WandUtil;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.NetworkHooks;

public class Lavaball
extends ExplosiveProjectile {
    private static final EntityDataAccessor<Boolean> DATA_UPGRADED = SynchedEntityData.m_135353_(Lavaball.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public float explosionPower = 1.0f;

    public Lavaball(EntityType<? extends Lavaball> p_i50163_1_, Level p_i50163_2_) {
        super(p_i50163_1_, p_i50163_2_);
    }

    public Lavaball(Level pWorld, double pX, double pY, double pZ, double pAccelX, double pAccelY, double pAccelZ) {
        super((EntityType<? extends ExplosiveProjectile>)((EntityType)ModEntityType.LAVABALL.get()), pX, pY, pZ, pAccelX, pAccelY, pAccelZ, pWorld);
    }

    public Lavaball(Level p_i1769_1_, LivingEntity p_i1769_2_, double p_i1769_3_, double p_i1769_5_, double p_i1769_7_) {
        super((EntityType<? extends ExplosiveProjectile>)((EntityType)ModEntityType.LAVABALL.get()), p_i1769_2_, p_i1769_3_, p_i1769_5_, p_i1769_7_, p_i1769_1_);
    }

    @Override
    public boolean defaultDangerous() {
        return true;
    }

    protected void m_6532_(HitResult pResult) {
        super.m_6532_(pResult);
        if (!this.f_19853_.f_46443_) {
            Entity owner = this.m_19749_();
            float enchantment = 0.0f;
            boolean flag = this.isDangerous();
            if (owner instanceof Player) {
                Player player = (Player)owner;
                if (WandUtil.enchantedFocus((LivingEntity)player)) {
                    enchantment = (float)WandUtil.getLevels((Enchantment)ModEnchantments.RADIUS.get(), (LivingEntity)player) / 2.5f;
                }
                if (!((Boolean)SpellConfig.LavaballGriefing.get()).booleanValue()) {
                    flag = false;
                }
            }
            this.f_19853_.m_255391_(owner, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.explosionPower + enchantment, flag, flag ? Level.ExplosionInteraction.BLOCK : Level.ExplosionInteraction.NONE);
            this.m_146870_();
        }
    }

    protected void m_5790_(EntityHitResult pResult) {
        super.m_5790_(pResult);
        if (!this.f_19853_.f_46443_) {
            Entity entity = pResult.m_82443_();
            Entity entity1 = this.m_19749_();
            float damage = 6.0f;
            float enchantment = 0.0f;
            int flaming = 0;
            if (entity1 instanceof Player) {
                Player player = (Player)entity1;
                if (WandUtil.enchantedFocus((LivingEntity)player)) {
                    enchantment = WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), (LivingEntity)player);
                    flaming = WandUtil.getLevels((Enchantment)ModEnchantments.BURNING.get(), (LivingEntity)player);
                }
                damage = ((Double)SpellConfig.LavaballDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();
            }
            entity.m_6469_(ModDamageSource.modFireball(this.m_19749_(), this.f_19853_), damage + enchantment);
            if (flaming != 0) {
                entity.m_20254_(5 * flaming);
            }
            if (entity1 instanceof LivingEntity) {
                this.m_19970_((LivingEntity)entity1, entity);
            }
        }
    }

    @Override
    protected boolean m_5603_(Entity pEntity) {
        Entity entity = this.m_19749_();
        if (entity instanceof IOwned) {
            IOwned owned = (IOwned)entity;
            if (pEntity instanceof IOwned) {
                IOwned owned1 = (IOwned)pEntity;
                if (owned.getTrueOwner() == owned1.getTrueOwner()) {
                    return false;
                }
            }
            if (owned.getTrueOwner() == pEntity) {
                return false;
            }
        }
        if (this.isUpgraded() && pEntity instanceof AbstractHurtingProjectile) {
            return false;
        }
        return super.m_5603_(pEntity);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_UPGRADED, (Object)false);
    }

    @Override
    public void setExplosionPower(float pExplosionPower) {
        this.explosionPower = pExplosionPower;
    }

    @Override
    public float getExplosionPower() {
        return this.explosionPower;
    }

    public boolean m_6128_() {
        return this.isUpgraded();
    }

    public boolean isUpgraded() {
        return (Boolean)this.f_19804_.m_135370_(DATA_UPGRADED);
    }

    public void setUpgraded(boolean pInvulnerable) {
        this.f_19804_.m_135381_(DATA_UPGRADED, (Object)pInvulnerable);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

